/*
 * Decompiled with CFR 0.152.
 */
package com.pixplicity.htmlcompat;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import com.pixplicity.htmlcompat.ColorUtils;
import com.pixplicity.htmlcompat.HtmlCompat;
import com.pixplicity.htmlcompat.R;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class HtmlToSpannedConverter
implements ContentHandler {
    private static final float[] HEADING_SIZES = new float[]{1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
    private final Context mContext;
    private String mSource;
    private final HtmlCompat.SpanCallback mSpanCallback;
    private XMLReader mReader;
    private SpannableStringBuilder mSpannableStringBuilder;
    private HtmlCompat.ImageGetter mImageGetter;
    private HtmlCompat.TagHandler mTagHandler;
    private int mFlags;
    private static Pattern sTextAlignPattern;
    private static Pattern sForegroundColorPattern;
    private static Pattern sBackgroundColorPattern;
    private static Pattern sTextDecorationPattern;
    private static Pattern sTextFontSizePattern;
    private static final Map<String, Integer> sColorMap;

    private static Pattern getTextAlignPattern() {
        if (sTextAlignPattern == null) {
            sTextAlignPattern = Pattern.compile("(?:\\s+|\\A)text-align\\s*:\\s*(\\S*)\\b");
        }
        return sTextAlignPattern;
    }

    private static Pattern getForegroundColorPattern() {
        if (sForegroundColorPattern == null) {
            sForegroundColorPattern = Pattern.compile("(?:\\s+|\\A)color\\s*:\\s*(\\S*)\\b");
        }
        return sForegroundColorPattern;
    }

    private static Pattern getBackgroundColorPattern() {
        if (sBackgroundColorPattern == null) {
            sBackgroundColorPattern = Pattern.compile("(?:\\s+|\\A)background(?:-color)?\\s*:\\s*(\\S*)\\b");
        }
        return sBackgroundColorPattern;
    }

    private static Pattern getTextDecorationPattern() {
        if (sTextDecorationPattern == null) {
            sTextDecorationPattern = Pattern.compile("(?:\\s+|\\A)text-decoration\\s*:\\s*(\\S*)\\b");
        }
        return sTextDecorationPattern;
    }

    private static Pattern getFontSizePattern() {
        if (sTextFontSizePattern == null) {
            sTextFontSizePattern = Pattern.compile("(?:\\s+|\\A)font-size\\s*:\\s*(\\S*)\\b");
        }
        return sTextFontSizePattern;
    }

    HtmlToSpannedConverter(Context context, String source, HtmlCompat.ImageGetter imageGetter, HtmlCompat.TagHandler tagHandler, HtmlCompat.SpanCallback spanCallback, Parser parser, int flags) {
        this.mContext = context;
        this.mSource = source;
        this.mSpannableStringBuilder = new SpannableStringBuilder();
        this.mImageGetter = imageGetter;
        this.mTagHandler = tagHandler;
        this.mSpanCallback = spanCallback;
        this.mReader = parser;
        this.mFlags = flags;
    }

    Spanned convert() {
        Object[] spans;
        this.mReader.setContentHandler(this);
        try {
            this.mReader.parse(new InputSource(new StringReader(this.mSource)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        for (Object span : spans = this.mSpannableStringBuilder.getSpans(0, this.mSpannableStringBuilder.length(), ParagraphStyle.class)) {
            int start = this.mSpannableStringBuilder.getSpanStart(span);
            int end = this.mSpannableStringBuilder.getSpanEnd(span);
            if (end - 2 >= 0 && this.mSpannableStringBuilder.charAt(end - 1) == '\n' && this.mSpannableStringBuilder.charAt(end - 2) == '\n') {
                --end;
            }
            if (end == start) {
                this.mSpannableStringBuilder.removeSpan(span);
                continue;
            }
            this.mSpannableStringBuilder.setSpan(span, start, end, 51);
        }
        return this.mSpannableStringBuilder;
    }

    private void handleStartTag(String tag, Attributes attributes) {
        if (!tag.equalsIgnoreCase("br")) {
            if (tag.equalsIgnoreCase("p")) {
                this.startBlockElement((Editable)this.mSpannableStringBuilder, attributes, this.getMarginParagraph());
                this.startCssStyle((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("ul")) {
                this.startBlockElement((Editable)this.mSpannableStringBuilder, attributes, this.getMarginList());
            } else if (tag.equalsIgnoreCase("li")) {
                this.startLi((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("div")) {
                this.startBlockElement((Editable)this.mSpannableStringBuilder, attributes, this.getMarginDiv());
            } else if (tag.equalsIgnoreCase("span")) {
                this.startCssStyle((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("strong")) {
                this.start((Editable)this.mSpannableStringBuilder, new Bold());
            } else if (tag.equalsIgnoreCase("b")) {
                this.start((Editable)this.mSpannableStringBuilder, new Bold());
            } else if (tag.equalsIgnoreCase("em")) {
                this.start((Editable)this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("cite")) {
                this.start((Editable)this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("dfn")) {
                this.start((Editable)this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("i")) {
                this.start((Editable)this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("big")) {
                this.start((Editable)this.mSpannableStringBuilder, new Big());
            } else if (tag.equalsIgnoreCase("small")) {
                this.start((Editable)this.mSpannableStringBuilder, new Small());
            } else if (tag.equalsIgnoreCase("font")) {
                this.startFont((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("blockquote")) {
                this.startBlockquote((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("tt")) {
                this.start((Editable)this.mSpannableStringBuilder, new Monospace());
            } else if (tag.equalsIgnoreCase("a")) {
                this.startA((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("u")) {
                this.start((Editable)this.mSpannableStringBuilder, new Underline());
            } else if (tag.equalsIgnoreCase("del")) {
                this.start((Editable)this.mSpannableStringBuilder, new Strikethrough());
            } else if (tag.equalsIgnoreCase("s")) {
                this.start((Editable)this.mSpannableStringBuilder, new Strikethrough());
            } else if (tag.equalsIgnoreCase("strike")) {
                this.start((Editable)this.mSpannableStringBuilder, new Strikethrough());
            } else if (tag.equalsIgnoreCase("sup")) {
                this.start((Editable)this.mSpannableStringBuilder, new Super());
            } else if (tag.equalsIgnoreCase("sub")) {
                this.start((Editable)this.mSpannableStringBuilder, new Sub());
            } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
                this.startHeading((Editable)this.mSpannableStringBuilder, attributes, tag.charAt(1) - 49);
            } else if (tag.equalsIgnoreCase("img")) {
                this.startImg((Editable)this.mSpannableStringBuilder, attributes, this.mImageGetter);
            } else if (this.mTagHandler != null) {
                this.mTagHandler.handleTag(true, tag, attributes, (Editable)this.mSpannableStringBuilder, this.mReader);
            }
        }
    }

    private void handleEndTag(String tag) {
        if (tag.equalsIgnoreCase("br")) {
            this.handleBr((Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("p")) {
            this.endCssStyle(tag, (Editable)this.mSpannableStringBuilder);
            this.endBlockElement(tag, (Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("ul")) {
            this.endBlockElement(tag, (Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("li")) {
            this.endLi(tag, (Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("div")) {
            this.endBlockElement(tag, (Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("span")) {
            this.endCssStyle(tag, (Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("strong")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
        } else if (tag.equalsIgnoreCase("b")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
        } else if (tag.equalsIgnoreCase("em")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("cite")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("dfn")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("i")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("big")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Big.class, new RelativeSizeSpan(1.25f));
        } else if (tag.equalsIgnoreCase("small")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Small.class, new RelativeSizeSpan(0.8f));
        } else if (tag.equalsIgnoreCase("font")) {
            this.endFont(tag, (Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("blockquote")) {
            this.endBlockquote(tag, (Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("tt")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Monospace.class, new TypefaceSpan("monospace"));
        } else if (tag.equalsIgnoreCase("a")) {
            this.endA(tag, (Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("u")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Underline.class, new UnderlineSpan());
        } else if (tag.equalsIgnoreCase("del")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("s")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("strike")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("sup")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Super.class, new SuperscriptSpan());
        } else if (tag.equalsIgnoreCase("sub")) {
            this.end(tag, (Editable)this.mSpannableStringBuilder, Sub.class, new SubscriptSpan());
        } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
            this.endHeading(tag, (Editable)this.mSpannableStringBuilder);
        } else if (this.mTagHandler != null) {
            this.mTagHandler.handleTag(false, tag, null, (Editable)this.mSpannableStringBuilder, this.mReader);
        }
    }

    private int getMarginParagraph() {
        return this.getMargin(1);
    }

    private int getMarginHeading() {
        return this.getMargin(2);
    }

    private int getMarginListItem() {
        return this.getMargin(4);
    }

    private int getMarginList() {
        return this.getMargin(8);
    }

    private int getMarginDiv() {
        return this.getMargin(16);
    }

    private int getMarginBlockquote() {
        return this.getMargin(32);
    }

    private int getMargin(int flag) {
        if ((flag & this.mFlags) != 0) {
            return 1;
        }
        return 2;
    }

    private void appendNewlines(Editable text, int minNewline) {
        int len = text.length();
        if (len == 0) {
            return;
        }
        int existingNewlines = 0;
        for (int i = len - 1; i >= 0 && text.charAt(i) == '\n'; --i) {
            ++existingNewlines;
        }
        for (int j = existingNewlines; j < minNewline; ++j) {
            text.append((CharSequence)"\n");
        }
    }

    private void startBlockElement(Editable text, Attributes attributes, int margin) {
        Matcher m;
        String style;
        if (margin > 0) {
            this.appendNewlines(text, margin);
            this.start(text, new Newline(margin));
        }
        if ((style = attributes.getValue("", "style")) != null && (m = HtmlToSpannedConverter.getTextAlignPattern().matcher(style)).find()) {
            String alignment = m.group(1);
            if (alignment.equalsIgnoreCase("start")) {
                this.start(text, new Alignment(Layout.Alignment.ALIGN_NORMAL));
            } else if (alignment.equalsIgnoreCase("center")) {
                this.start(text, new Alignment(Layout.Alignment.ALIGN_CENTER));
            } else if (alignment.equalsIgnoreCase("end")) {
                this.start(text, new Alignment(Layout.Alignment.ALIGN_OPPOSITE));
            }
        }
    }

    private void endBlockElement(String tag, Editable text) {
        Alignment a;
        Newline n = this.getLast((Spanned)text, Newline.class);
        if (n != null) {
            this.appendNewlines(text, n.mNumNewlines);
            text.removeSpan((Object)n);
        }
        if ((a = this.getLast((Spanned)text, Alignment.class)) != null) {
            this.setSpanFromMark(tag, (Spannable)text, a, new AlignmentSpan.Standard(a.mAlignment));
        }
    }

    private void handleBr(Editable text) {
        text.append('\n');
    }

    private void startLi(Editable text, Attributes attributes) {
        this.startBlockElement(text, attributes, this.getMarginListItem());
        this.start(text, new Bullet());
        this.startCssStyle(text, attributes);
    }

    private void endLi(String tag, Editable text) {
        this.endCssStyle(tag, text);
        this.endBlockElement(tag, text);
        this.end(tag, text, Bullet.class, new BulletSpan());
    }

    private void startBlockquote(Editable text, Attributes attributes) {
        this.startBlockElement(text, attributes, this.getMarginBlockquote());
        this.start(text, new Blockquote());
    }

    private void endBlockquote(String tag, Editable text) {
        this.endBlockElement(tag, text);
        this.end(tag, text, Blockquote.class, new QuoteSpan());
    }

    private void startHeading(Editable text, Attributes attributes, int level) {
        this.startBlockElement(text, attributes, this.getMarginHeading());
        this.start(text, new Heading(level));
    }

    private void endHeading(String tag, Editable text) {
        Heading h = this.getLast((Spanned)text, Heading.class);
        if (h != null) {
            this.setSpanFromMark(tag, (Spannable)text, h, new RelativeSizeSpan(HEADING_SIZES[h.mLevel]), new StyleSpan(1));
        }
        this.endBlockElement(tag, text);
    }

    private <T> T getLast(Spanned text, Class<T> kind) {
        Object[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        return (T)objs[objs.length - 1];
    }

    private void setSpanFromMark(String tag, Spannable text, Object mark, Object ... spans) {
        int where = text.getSpanStart(mark);
        text.removeSpan(mark);
        int len = text.length();
        if (where != len) {
            for (Object span : spans) {
                if (this.mSpanCallback != null) {
                    span = this.mSpanCallback.onSpanCreated(tag, span);
                }
                text.setSpan(span, where, len, 33);
            }
        }
    }

    private void start(Editable text, Object mark) {
        int len = text.length();
        text.setSpan(mark, len, len, 17);
    }

    private void end(String tag, Editable text, Class kind, Object repl) {
        Object obj = this.getLast((Spanned)text, kind);
        if (obj != null) {
            this.setSpanFromMark(tag, (Spannable)text, obj, repl);
        }
    }

    private void startCssStyle(Editable text, Attributes attributes) {
        String style = attributes.getValue("", "style");
        if (style != null) {
            String textSizeString;
            String textDecoration;
            int c;
            Matcher m = HtmlToSpannedConverter.getForegroundColorPattern().matcher(style);
            if (m.find() && (c = this.getHtmlColor(m.group(1))) != -1) {
                this.start(text, new Foreground(c | 0xFF000000));
            }
            if ((m = HtmlToSpannedConverter.getBackgroundColorPattern().matcher(style)).find() && (c = this.getHtmlColor(m.group(1))) != -1) {
                this.start(text, new Background(c | 0xFF000000));
            }
            if ((m = HtmlToSpannedConverter.getTextDecorationPattern().matcher(style)).find() && (textDecoration = m.group(1)).equalsIgnoreCase("line-through")) {
                this.start(text, new Strikethrough());
            }
            if ((m = HtmlToSpannedConverter.getFontSizePattern().matcher(style)).find() && !TextUtils.isEmpty((CharSequence)(textSizeString = m.group(1)))) {
                if (textSizeString.contains("px")) {
                    int textSize = Integer.valueOf(textSizeString.replaceAll("\\D+", ""));
                    textSize = (int)((float)textSize * this.mContext.getResources().getDisplayMetrics().density);
                    this.start(text, new AbsoluteSize(textSize));
                }
                if (textSizeString.contains("em")) {
                    float textSize = Float.valueOf(textSizeString.replaceAll("\\D+", "")).floatValue();
                    this.start(text, new RelativeSize(textSize));
                }
            }
        }
    }

    private void endCssStyle(String tag, Editable text) {
        RelativeSize r;
        AbsoluteSize a;
        Foreground f;
        Background b;
        Strikethrough s = this.getLast((Spanned)text, Strikethrough.class);
        if (s != null) {
            this.setSpanFromMark(tag, (Spannable)text, s, new StrikethroughSpan());
        }
        if ((b = this.getLast((Spanned)text, Background.class)) != null) {
            this.setSpanFromMark(tag, (Spannable)text, b, new BackgroundColorSpan(b.mBackgroundColor));
        }
        if ((f = this.getLast((Spanned)text, Foreground.class)) != null) {
            this.setSpanFromMark(tag, (Spannable)text, f, new ForegroundColorSpan(f.mForegroundColor));
        }
        if ((a = this.getLast((Spanned)text, AbsoluteSize.class)) != null) {
            this.setSpanFromMark(tag, (Spannable)text, a, new AbsoluteSizeSpan(a.getTextSize()));
        }
        if ((r = this.getLast((Spanned)text, RelativeSize.class)) != null) {
            this.setSpanFromMark(tag, (Spannable)text, r, new RelativeSizeSpan(r.getTextProportion()));
        }
    }

    private void startImg(Editable text, Attributes attributes, HtmlCompat.ImageGetter img) {
        String src = attributes.getValue("", "src");
        Drawable d = null;
        if (img != null) {
            d = img.getDrawable(src, attributes);
        }
        if (d == null) {
            Resources res = this.mContext.getResources();
            d = res.getDrawable(R.drawable.unknown_image);
            d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
        }
        int len = text.length();
        text.append((CharSequence)"\ufffc");
        text.setSpan((Object)new ImageSpan(d, src), len, text.length(), 33);
    }

    private void startFont(Editable text, Attributes attributes) {
        int c;
        String color = attributes.getValue("", "color");
        String face = attributes.getValue("", "face");
        if (!TextUtils.isEmpty((CharSequence)color) && (c = this.getHtmlColor(color)) != -1) {
            this.start(text, new Foreground(c | 0xFF000000));
        }
        if (!TextUtils.isEmpty((CharSequence)face)) {
            this.start(text, new Font(face));
        }
    }

    private void endFont(String tag, Editable text) {
        Foreground foreground;
        Font font = this.getLast((Spanned)text, Font.class);
        if (font != null) {
            this.setSpanFromMark(tag, (Spannable)text, font, new TypefaceSpan(font.mFace));
        }
        if ((foreground = this.getLast((Spanned)text, Foreground.class)) != null) {
            this.setSpanFromMark(tag, (Spannable)text, foreground, new ForegroundColorSpan(foreground.mForegroundColor));
        }
    }

    private void startA(Editable text, Attributes attributes) {
        String href = attributes.getValue("", "href");
        this.start(text, new Href(href));
    }

    private void endA(String tag, Editable text) {
        Href h = this.getLast((Spanned)text, Href.class);
        if (h != null && h.mHref != null) {
            this.setSpanFromMark(tag, (Spannable)text, h, new Object[]{new HtmlCompat.DefensiveURLSpan(h.mHref)});
        }
    }

    private int getHtmlColor(String color) {
        Integer i;
        if ((this.mFlags & 0x100) == 256 && (i = sColorMap.get(color.toLowerCase(Locale.US))) != null) {
            return i;
        }
        return ColorUtils.getHtmlColor(color);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.handleStartTag(localName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handleEndTag(localName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = ch[i + start];
            if (c == ' ' || c == '\n') {
                int len = sb.length();
                int pred = len == 0 ? ((len = this.mSpannableStringBuilder.length()) == 0 ? 10 : (int)this.mSpannableStringBuilder.charAt(len - 1)) : sb.charAt(len - 1);
                if (pred == 32 || pred == 10) continue;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        this.mSpannableStringBuilder.append((CharSequence)sb);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    static {
        sColorMap = new HashMap<String, Integer>();
        sColorMap.put("aliceblue", -984833);
        sColorMap.put("antiquewhite", -332841);
        sColorMap.put("aqua", -16711681);
        sColorMap.put("aquamarine", -8388652);
        sColorMap.put("azure", -983041);
        sColorMap.put("beige", -657956);
        sColorMap.put("bisque", -6972);
        sColorMap.put("black", -16777216);
        sColorMap.put("blanchedalmond", -5171);
        sColorMap.put("blue", -16776961);
        sColorMap.put("blueviolet", -7722014);
        sColorMap.put("brown", -5952982);
        sColorMap.put("burlywood", -2180985);
        sColorMap.put("cadetblue", -10510688);
        sColorMap.put("chartreuse", -8388864);
        sColorMap.put("chocolate", -2987746);
        sColorMap.put("coral", -32944);
        sColorMap.put("cornflowerblue", -10185235);
        sColorMap.put("cornsilk", -1828);
        sColorMap.put("crimson", -2354116);
        sColorMap.put("cyan", -16711681);
        sColorMap.put("darkblue", -16777077);
        sColorMap.put("darkcyan", -16741493);
        sColorMap.put("darkgoldenrod", -4684277);
        sColorMap.put("darkgray", -5658199);
        sColorMap.put("darkgrey", -5658199);
        sColorMap.put("darkgreen", -16751616);
        sColorMap.put("darkkhaki", -4343957);
        sColorMap.put("darkmagenta", -7667573);
        sColorMap.put("darkolivegreen", -11179217);
        sColorMap.put("darkorange", -29696);
        sColorMap.put("darkorchid", -6737204);
        sColorMap.put("darkred", -7667712);
        sColorMap.put("darksalmon", -1468806);
        sColorMap.put("darkseagreen", -7357297);
        sColorMap.put("darkslateblue", -12042869);
        sColorMap.put("darkslategray", -13676721);
        sColorMap.put("darkslategrey", -13676721);
        sColorMap.put("darkturquoise", -16724271);
        sColorMap.put("darkviolet", -7077677);
        sColorMap.put("deeppink", -60269);
        sColorMap.put("deepskyblue", -16728065);
        sColorMap.put("dimgray", -9868951);
        sColorMap.put("dimgrey", -9868951);
        sColorMap.put("dodgerblue", -14774017);
        sColorMap.put("firebrick", -5103070);
        sColorMap.put("floralwhite", -1296);
        sColorMap.put("forestgreen", -14513374);
        sColorMap.put("fuchsia", -65281);
        sColorMap.put("gainsboro", -2302756);
        sColorMap.put("ghostwhite", -460545);
        sColorMap.put("gold", -10496);
        sColorMap.put("goldenrod", -2448096);
        sColorMap.put("gray", -8355712);
        sColorMap.put("grey", -8355712);
        sColorMap.put("green", -16744448);
        sColorMap.put("greenyellow", -5374161);
        sColorMap.put("honeydew", -983056);
        sColorMap.put("hotpink", -38476);
        sColorMap.put("indianred ", -3318692);
        sColorMap.put("indigo  ", -11861886);
        sColorMap.put("ivory", -16);
        sColorMap.put("khaki", -989556);
        sColorMap.put("lavender", -1644806);
        sColorMap.put("lavenderblush", -3851);
        sColorMap.put("lawngreen", -8586240);
        sColorMap.put("lemonchiffon", -1331);
        sColorMap.put("lightblue", -5383962);
        sColorMap.put("lightcoral", -1015680);
        sColorMap.put("lightcyan", -2031617);
        sColorMap.put("lightgoldenrodyellow", -329006);
        sColorMap.put("lightgray", -2894893);
        sColorMap.put("lightgrey", -2894893);
        sColorMap.put("lightgreen", -7278960);
        sColorMap.put("lightpink", -18751);
        sColorMap.put("lightsalmon", -24454);
        sColorMap.put("lightseagreen", -14634326);
        sColorMap.put("lightskyblue", -7876870);
        sColorMap.put("lightslategray", -8943463);
        sColorMap.put("lightslategrey", -8943463);
        sColorMap.put("lightsteelblue", -5192482);
        sColorMap.put("lightyellow", -32);
        sColorMap.put("lime", -16711936);
        sColorMap.put("limegreen", -13447886);
        sColorMap.put("linen", -331546);
        sColorMap.put("magenta", -65281);
        sColorMap.put("maroon", -8388608);
        sColorMap.put("mediumaquamarine", -10039894);
        sColorMap.put("mediumblue", -16777011);
        sColorMap.put("mediumorchid", -4565549);
        sColorMap.put("mediumpurple", -7114533);
        sColorMap.put("mediumseagreen", -12799119);
        sColorMap.put("mediumslateblue", -8689426);
        sColorMap.put("mediumspringgreen", -16713062);
        sColorMap.put("mediumturquoise", -12004916);
        sColorMap.put("mediumvioletred", -3730043);
        sColorMap.put("midnightblue", -15132304);
        sColorMap.put("mintcream", -655366);
        sColorMap.put("mistyrose", -6943);
        sColorMap.put("moccasin", -6987);
        sColorMap.put("navajowhite", -8531);
        sColorMap.put("navy", -16777088);
        sColorMap.put("oldlace", -133658);
        sColorMap.put("olive", -8355840);
        sColorMap.put("olivedrab", -9728477);
        sColorMap.put("orange", -23296);
        sColorMap.put("orangered", -47872);
        sColorMap.put("orchid", -2461482);
        sColorMap.put("palegoldenrod", -1120086);
        sColorMap.put("palegreen", -6751336);
        sColorMap.put("paleturquoise", -5247250);
        sColorMap.put("palevioletred", -2396013);
        sColorMap.put("papayawhip", -4139);
        sColorMap.put("peachpuff", -9543);
        sColorMap.put("peru", -3308225);
        sColorMap.put("pink", -16181);
        sColorMap.put("plum", -2252579);
        sColorMap.put("powderblue", -5185306);
        sColorMap.put("purple", -8388480);
        sColorMap.put("rebeccapurple", -10079335);
        sColorMap.put("red", -65536);
        sColorMap.put("rosybrown", -4419697);
        sColorMap.put("royalblue", -12490271);
        sColorMap.put("saddlebrown", -7650029);
        sColorMap.put("salmon", -360334);
        sColorMap.put("sandybrown", -744352);
        sColorMap.put("seagreen", -13726889);
        sColorMap.put("seashell", -2578);
        sColorMap.put("sienna", -6270419);
        sColorMap.put("silver", -4144960);
        sColorMap.put("skyblue", -7876885);
        sColorMap.put("slateblue", -9807155);
        sColorMap.put("slategray", -9404272);
        sColorMap.put("slategrey", -9404272);
        sColorMap.put("snow", -1286);
        sColorMap.put("springgreen", -16711809);
        sColorMap.put("steelblue", -12156236);
        sColorMap.put("tan", -2968436);
        sColorMap.put("teal", -16744320);
        sColorMap.put("thistle", -2572328);
        sColorMap.put("tomato", -40121);
        sColorMap.put("turquoise", -12525360);
        sColorMap.put("violet", -1146130);
        sColorMap.put("wheat", -663885);
        sColorMap.put("white", -1);
        sColorMap.put("whitesmoke", -657931);
        sColorMap.put("yellow", -256);
        sColorMap.put("yellowgreen", -6632142);
    }

    private static class Alignment {
        private Layout.Alignment mAlignment;

        Alignment(Layout.Alignment alignment) {
            this.mAlignment = alignment;
        }
    }

    private static class Newline {
        private int mNumNewlines;

        Newline(int numNewlines) {
            this.mNumNewlines = numNewlines;
        }
    }

    private static class RelativeSize {
        private float mTextProportion;

        RelativeSize(float textProportion) {
            this.mTextProportion = textProportion;
        }

        public float getTextProportion() {
            return this.mTextProportion;
        }
    }

    private static class AbsoluteSize {
        private int mTextSize;

        AbsoluteSize(int textSize) {
            this.mTextSize = textSize;
        }

        public int getTextSize() {
            return this.mTextSize;
        }
    }

    private static class Heading {
        private int mLevel;

        Heading(int level) {
            this.mLevel = level;
        }
    }

    private static class Background {
        private int mBackgroundColor;

        Background(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
        }
    }

    private static class Foreground {
        private int mForegroundColor;

        Foreground(int foregroundColor) {
            this.mForegroundColor = foregroundColor;
        }
    }

    private static class Href {
        String mHref;

        Href(String href) {
            this.mHref = href;
        }
    }

    private static class Font {
        String mFace;

        Font(String face) {
            this.mFace = face;
        }
    }

    private static class Bullet {
        private Bullet() {
        }
    }

    private static class Sub {
        private Sub() {
        }
    }

    private static class Super {
        private Super() {
        }
    }

    private static class Blockquote {
        private Blockquote() {
        }
    }

    private static class Monospace {
        private Monospace() {
        }
    }

    private static class Small {
        private Small() {
        }
    }

    private static class Big {
        private Big() {
        }
    }

    private static class Strikethrough {
        private Strikethrough() {
        }
    }

    private static class Underline {
        private Underline() {
        }
    }

    private static class Italic {
        private Italic() {
        }
    }

    private static class Bold {
        private Bold() {
        }
    }
}

