/*
 * Decompiled with CFR 0.152.
 */
package com.pixplicity.htmlcompat;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import com.pixplicity.htmlcompat.HtmlToSpannedConverter;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class HtmlCompat {
    public static final int TO_HTML_PARAGRAPH_LINES_CONSECUTIVE = 0;
    public static final int TO_HTML_PARAGRAPH_LINES_INDIVIDUAL = 1;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_PARAGRAPH = 1;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_HEADING = 2;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_LIST_ITEM = 4;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_LIST = 8;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_DIV = 16;
    public static final int FROM_HTML_SEPARATOR_LINE_BREAK_BLOCKQUOTE = 32;
    public static final int FROM_HTML_OPTION_USE_CSS_COLORS = 256;
    public static final int FROM_HTML_MODE_LEGACY = 0;
    public static final int FROM_HTML_MODE_COMPACT = 63;
    private static final int TO_HTML_PARAGRAPH_FLAG = 1;

    private HtmlCompat() {
    }

    public static Spanned fromHtml(@NonNull Context context, @NonNull String source, int flags) {
        return HtmlCompat.fromHtml(context, source, flags, null, null);
    }

    public static Spanned fromHtml(@NonNull Context context, @NonNull String source, int flags, @Nullable ImageGetter imageGetter) {
        return HtmlCompat.fromHtml(context, source, flags, imageGetter, null, null);
    }

    public static Spanned fromHtml(@NonNull Context context, @NonNull String source, int flags, @Nullable ImageGetter imageGetter, @Nullable TagHandler tagHandler) {
        return HtmlCompat.fromHtml(context, source, flags, imageGetter, tagHandler, null);
    }

    public static Spanned fromHtml(@NonNull Context context, @NonNull String source, int flags, @Nullable ImageGetter imageGetter, @Nullable TagHandler tagHandler, @Nullable SpanCallback spanCallback) {
        if (source == null) {
            return null;
        }
        Parser parser = new Parser();
        try {
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", HtmlParser.schema);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        HtmlToSpannedConverter converter = new HtmlToSpannedConverter(context, source, imageGetter, tagHandler, spanCallback, parser, flags);
        return converter.convert();
    }

    public static String toHtml(Context context, Spanned text, int option) {
        StringBuilder out = new StringBuilder();
        HtmlCompat.withinHtml(context, out, text, option);
        return out.toString();
    }

    public static String escapeHtml(CharSequence text) {
        StringBuilder out = new StringBuilder();
        HtmlCompat.withinStyle(out, text, 0, text.length());
        return out.toString();
    }

    private static void withinHtml(Context context, StringBuilder out, Spanned text, int option) {
        if ((option & 1) == 0) {
            HtmlCompat.encodeTextAlignmentByDiv(context, out, text, option);
            return;
        }
        HtmlCompat.withinDiv(context, out, text, 0, text.length(), option);
    }

    private static void encodeTextAlignmentByDiv(Context context, StringBuilder out, Spanned text, int option) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            int next = text.nextSpanTransition(i, len, ParagraphStyle.class);
            ParagraphStyle[] styles = (ParagraphStyle[])text.getSpans(i, next, ParagraphStyle.class);
            String elements = " ";
            boolean needDiv = false;
            for (ParagraphStyle style : styles) {
                if (!(style instanceof AlignmentSpan)) continue;
                Layout.Alignment align = ((AlignmentSpan)style).getAlignment();
                needDiv = true;
                elements = align == Layout.Alignment.ALIGN_CENTER ? "align=\"center\" " + elements : (align == Layout.Alignment.ALIGN_OPPOSITE ? "align=\"right\" " + elements : "align=\"left\" " + elements);
            }
            if (needDiv) {
                out.append("<div ").append(elements).append(">");
            }
            HtmlCompat.withinDiv(context, out, text, i, next, option);
            if (needDiv) {
                out.append("</div>");
            }
            i = next;
        }
    }

    private static void withinDiv(Context context, StringBuilder out, Spanned text, int start, int end, int option) {
        int i = start;
        while (i < end) {
            QuoteSpan[] quotes;
            int next = text.nextSpanTransition(i, end, QuoteSpan.class);
            for (QuoteSpan quote : quotes = (QuoteSpan[])text.getSpans(i, next, QuoteSpan.class)) {
                out.append("<blockquote>");
            }
            HtmlCompat.withinBlockquote(context, out, text, i, next, option);
            for (QuoteSpan quote : quotes) {
                out.append("</blockquote>\n");
            }
            i = next;
        }
    }

    private static String getTextDirection(Spanned text, int start, int end) {
        int paraDir = 1;
        switch (paraDir) {
            case -1: {
                return " dir=\"rtl\"";
            }
        }
        return " dir=\"ltr\"";
    }

    private static String getTextStyles(Spanned text, int start, int end, boolean forceNoVerticalMargin, boolean includeTextAlign) {
        String margin = null;
        String textAlign = null;
        if (forceNoVerticalMargin) {
            margin = "margin-top:0; margin-bottom:0;";
        }
        if (includeTextAlign) {
            AlignmentSpan[] alignmentSpans = (AlignmentSpan[])text.getSpans(start, end, AlignmentSpan.class);
            for (int i = alignmentSpans.length - 1; i >= 0; --i) {
                AlignmentSpan s = alignmentSpans[i];
                if ((text.getSpanFlags((Object)s) & 0x33) != 51) continue;
                Layout.Alignment alignment = s.getAlignment();
                if (alignment == Layout.Alignment.ALIGN_NORMAL) {
                    textAlign = "text-align:start;";
                    break;
                }
                if (alignment == Layout.Alignment.ALIGN_CENTER) {
                    textAlign = "text-align:center;";
                    break;
                }
                if (alignment != Layout.Alignment.ALIGN_OPPOSITE) break;
                textAlign = "text-align:end;";
                break;
            }
        }
        if (margin == null && textAlign == null) {
            return "";
        }
        StringBuilder style = new StringBuilder(" style=\"");
        if (margin != null && textAlign != null) {
            style.append(margin).append(" ").append(textAlign);
        } else if (margin != null) {
            style.append(margin);
        } else if (textAlign != null) {
            style.append(textAlign);
        }
        return style.append("\"").toString();
    }

    private static void withinBlockquote(Context context, StringBuilder out, Spanned text, int start, int end, int option) {
        if ((option & 1) == 0) {
            HtmlCompat.withinBlockquoteConsecutive(context, out, text, start, end);
        } else {
            HtmlCompat.withinBlockquoteIndividual(context, out, text, start, end);
        }
    }

    private static void withinBlockquoteIndividual(Context context, StringBuilder out, Spanned text, int start, int end) {
        boolean isInList = false;
        int i = start;
        while (i <= end) {
            int next = TextUtils.indexOf((CharSequence)text, (char)'\n', (int)i, (int)end);
            if (next < 0) {
                next = end;
            }
            if (next == i) {
                if (isInList) {
                    isInList = false;
                    out.append("</ul>\n");
                }
                out.append("<br>\n");
            } else {
                ParagraphStyle[] paragraphStyles;
                boolean isListItem = false;
                for (ParagraphStyle paragraphStyle : paragraphStyles = (ParagraphStyle[])text.getSpans(i, next, ParagraphStyle.class)) {
                    int spanFlags = text.getSpanFlags((Object)paragraphStyle);
                    if ((spanFlags & 0x33) != 51 || !(paragraphStyle instanceof BulletSpan)) continue;
                    isListItem = true;
                    break;
                }
                if (isListItem && !isInList) {
                    isInList = true;
                    out.append("<ul").append(HtmlCompat.getTextStyles(text, i, next, true, false)).append(">\n");
                }
                if (isInList && !isListItem) {
                    isInList = false;
                    out.append("</ul>\n");
                }
                String tagType = isListItem ? "li" : "p";
                out.append("<").append(tagType).append(HtmlCompat.getTextDirection(text, i, next)).append(HtmlCompat.getTextStyles(text, i, next, !isListItem, true)).append(">");
                HtmlCompat.withinParagraph(context, out, text, i, next);
                out.append("</");
                out.append(tagType);
                out.append(">\n");
                if (next == end && isInList) {
                    isInList = false;
                    out.append("</ul>\n");
                }
            }
            i = ++next;
        }
    }

    private static void withinBlockquoteConsecutive(Context context, StringBuilder out, Spanned text, int start, int end) {
        out.append("<p").append(HtmlCompat.getTextDirection(text, start, end)).append(">");
        int i = start;
        while (i < end) {
            int next = TextUtils.indexOf((CharSequence)text, (char)'\n', (int)i, (int)end);
            if (next < 0) {
                next = end;
            }
            int nl = 0;
            while (next < end && text.charAt(next) == '\n') {
                ++nl;
                ++next;
            }
            HtmlCompat.withinParagraph(context, out, text, i, next - nl);
            if (nl == 1) {
                out.append("<br>\n");
            } else {
                for (int j = 2; j < nl; ++j) {
                    out.append("<br>");
                }
                if (next != end) {
                    out.append("</p>\n");
                    out.append("<p").append(HtmlCompat.getTextDirection(text, start, end)).append(">");
                }
            }
            i = next;
        }
        out.append("</p>\n");
    }

    private static void withinParagraph(Context context, StringBuilder out, Spanned text, int start, int end) {
        int i = start;
        while (i < end) {
            CharacterStyle[] styles;
            int next = text.nextSpanTransition(i, end, CharacterStyle.class);
            for (CharacterStyle style : styles = (CharacterStyle[])text.getSpans(i, next, CharacterStyle.class)) {
                int color;
                String s;
                if (style instanceof StyleSpan) {
                    int s2 = ((StyleSpan)style).getStyle();
                    if ((s2 & 1) != 0) {
                        out.append("<b>");
                    }
                    if ((s2 & 2) != 0) {
                        out.append("<i>");
                    }
                }
                if (style instanceof TypefaceSpan && "monospace".equals(s = ((TypefaceSpan)style).getFamily())) {
                    out.append("<tt>");
                }
                if (style instanceof SuperscriptSpan) {
                    out.append("<sup>");
                }
                if (style instanceof SubscriptSpan) {
                    out.append("<sub>");
                }
                if (style instanceof UnderlineSpan) {
                    out.append("<u>");
                }
                if (style instanceof StrikethroughSpan) {
                    out.append("<span style=\"text-decoration:line-through;\">");
                }
                if (style instanceof URLSpan) {
                    out.append("<a href=\"");
                    out.append(((URLSpan)style).getURL());
                    out.append("\">");
                }
                if (style instanceof ImageSpan) {
                    out.append("<img src=\"");
                    out.append(((ImageSpan)style).getSource());
                    out.append("\">");
                    i = next;
                }
                if (style instanceof AbsoluteSizeSpan) {
                    AbsoluteSizeSpan s3 = (AbsoluteSizeSpan)style;
                    float sizeDip = s3.getSize();
                    if (!s3.getDip()) {
                        sizeDip /= context.getResources().getDisplayMetrics().density;
                    }
                    out.append(String.format("<span style=\"font-size:%.0fpx\";>", Float.valueOf(sizeDip)));
                }
                if (style instanceof RelativeSizeSpan) {
                    float sizeEm = ((RelativeSizeSpan)style).getSizeChange();
                    out.append(String.format("<span style=\"font-size:%.2fem;\">", Float.valueOf(sizeEm)));
                }
                if (style instanceof ForegroundColorSpan) {
                    color = ((ForegroundColorSpan)style).getForegroundColor();
                    out.append(String.format("<span style=\"color:#%06X;\">", 0xFFFFFF & color));
                }
                if (!(style instanceof BackgroundColorSpan)) continue;
                color = ((BackgroundColorSpan)style).getBackgroundColor();
                out.append(String.format("<span style=\"background-color:#%06X;\">", 0xFFFFFF & color));
            }
            HtmlCompat.withinStyle(out, (CharSequence)text, i, next);
            for (int j = styles.length - 1; j >= 0; --j) {
                String s;
                if (styles[j] instanceof BackgroundColorSpan) {
                    out.append("</span>");
                }
                if (styles[j] instanceof ForegroundColorSpan) {
                    out.append("</span>");
                }
                if (styles[j] instanceof RelativeSizeSpan) {
                    out.append("</span>");
                }
                if (styles[j] instanceof AbsoluteSizeSpan) {
                    out.append("</span>");
                }
                if (styles[j] instanceof URLSpan) {
                    out.append("</a>");
                }
                if (styles[j] instanceof StrikethroughSpan) {
                    out.append("</span>");
                }
                if (styles[j] instanceof UnderlineSpan) {
                    out.append("</u>");
                }
                if (styles[j] instanceof SubscriptSpan) {
                    out.append("</sub>");
                }
                if (styles[j] instanceof SuperscriptSpan) {
                    out.append("</sup>");
                }
                if (styles[j] instanceof TypefaceSpan && (s = ((TypefaceSpan)styles[j]).getFamily()).equals("monospace")) {
                    out.append("</tt>");
                }
                if (!(styles[j] instanceof StyleSpan)) continue;
                int s2 = ((StyleSpan)styles[j]).getStyle();
                if ((s2 & 1) != 0) {
                    out.append("</b>");
                }
                if ((s2 & 2) == 0) continue;
                out.append("</i>");
            }
            i = next;
        }
    }

    private static void withinStyle(StringBuilder out, CharSequence text, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                char d;
                if (c >= '\udc00' || i + 1 >= end || (d = text.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                ++i;
                int codepoint = 0x10000 | c - 55296 << 10 | d - 56320;
                out.append("&#").append(codepoint).append(";");
                continue;
            }
            if (c > '~' || c < ' ') {
                out.append("&#").append((int)c).append(";");
                continue;
            }
            if (c == ' ') {
                while (i + 1 < end && text.charAt(i + 1) == ' ') {
                    out.append("&nbsp;");
                    ++i;
                }
                out.append(' ');
                continue;
            }
            out.append(c);
        }
    }

    private static class HtmlParser {
        private static final HTMLSchema schema = new HTMLSchema();

        private HtmlParser() {
        }
    }

    @SuppressLint(value={"ParcelCreator"})
    public static class DefensiveURLSpan
    extends URLSpan {
        public DefensiveURLSpan(String url) {
            super(url);
        }

        public void onClick(View widget) {
            try {
                super.onClick(widget);
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                // empty catch block
            }
        }
    }

    public static interface SpanCallback {
        public Object onSpanCreated(String var1, Object var2);
    }

    public static interface TagHandler {
        public void handleTag(boolean var1, String var2, Attributes var3, Editable var4, XMLReader var5);
    }

    public static interface ImageGetter {
        public Drawable getDrawable(String var1, Attributes var2);
    }
}

