/*
 * Decompiled with CFR 0.152.
 */
package com.pixplicity.htmlcompat;

import android.support.annotation.ColorInt;
import com.pixplicity.htmlcompat.XmlUtils;
import java.util.HashMap;
import java.util.Locale;

class ColorUtils {
    private static final HashMap<String, Integer> sColorNameMap = new HashMap();

    ColorUtils() {
    }

    @ColorInt
    public static int getHtmlColor(String color) {
        Integer i = sColorNameMap.get(color.toLowerCase(Locale.ROOT));
        if (i != null) {
            return i;
        }
        try {
            return XmlUtils.convertValueToInt(color, -1);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    static {
        sColorNameMap.put("black", -16777216);
        sColorNameMap.put("darkgray", -12303292);
        sColorNameMap.put("gray", -7829368);
        sColorNameMap.put("lightgray", -3355444);
        sColorNameMap.put("white", -1);
        sColorNameMap.put("red", -65536);
        sColorNameMap.put("green", -16711936);
        sColorNameMap.put("blue", -16776961);
        sColorNameMap.put("yellow", -256);
        sColorNameMap.put("cyan", -16711681);
        sColorNameMap.put("magenta", -65281);
        sColorNameMap.put("aqua", -16711681);
        sColorNameMap.put("fuchsia", -65281);
        sColorNameMap.put("darkgrey", -12303292);
        sColorNameMap.put("grey", -7829368);
        sColorNameMap.put("lightgrey", -3355444);
        sColorNameMap.put("lime", -16711936);
        sColorNameMap.put("maroon", -8388608);
        sColorNameMap.put("navy", -16777088);
        sColorNameMap.put("olive", -8355840);
        sColorNameMap.put("purple", -8388480);
        sColorNameMap.put("silver", -4144960);
        sColorNameMap.put("teal", -16744320);
    }
}

