/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.license.server;

import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import org.smartboot.license.client.LicenseEntity;
import org.smartboot.license.server.RasUtil;

class SourceLicense {
    public static final String PROPERTY_APPLY_DATE = "applyDate";
    public static final String PROPERTY_EXPIRE_DATE = "expireDate";
    public static final String PROPERTY_BASE64_CONTENT = "base64Content";
    public static final String PROPERTY_PUBLIC_KEY = "publicKey";
    public static final String PROPERTY_PRIVATE_KEY = "privateKey";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final String applyDate;
    private final String expireDate;
    private final String publicKey;
    private final String privateKey;
    private final String base64Content;

    public SourceLicense(LicenseEntity entity, KeyPair keyPair) {
        Base64.Encoder base64Encoder = Base64.getEncoder();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        this.applyDate = sdf.format(new Date(entity.getApplyTime()));
        this.expireDate = sdf.format(new Date(entity.getExpireTime()));
        this.base64Content = base64Encoder.encodeToString(entity.getData());
        this.privateKey = base64Encoder.encodeToString(RasUtil.getPrivateKey(keyPair));
        this.publicKey = base64Encoder.encodeToString(RasUtil.getPublicKey(keyPair));
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getBase64Content() {
        return this.base64Content;
    }

    public String getApplyDate() {
        return this.applyDate;
    }

    public String getExpireDate() {
        return this.expireDate;
    }
}

