/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.license.server;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import org.smartboot.license.client.LicenseException;

public class RasUtil {
    private static final String KEY_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 1024;

    public static KeyPair initKey() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGenerator.initialize(1024);
        return keyPairGenerator.generateKeyPair();
    }

    public static byte[] encryptByPrivateKey(byte[] data, byte[] key) {
        return RasUtil.encryptByPrivateKey(data, key, 0, data.length);
    }

    public static byte[] encryptByPrivateKey(byte[] data, byte[] key, int start, int length) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, privateKey);
            return cipher.doFinal(data, start, length);
        }
        catch (Exception e) {
            throw new LicenseException("encrypt exception", (Throwable)e);
        }
    }

    public static byte[] getPrivateKey(KeyPair keyPair) {
        return keyPair.getPrivate().getEncoded();
    }

    public static byte[] getPublicKey(KeyPair keyPair) {
        return keyPair.getPublic().getEncoded();
    }
}

