/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial;

import com.pi4j.context.Context;
import com.pi4j.io.IO;
import com.pi4j.io.IODataReader;
import com.pi4j.io.IODataWriter;
import com.pi4j.io.serial.DataBits;
import com.pi4j.io.serial.FlowControl;
import com.pi4j.io.serial.Parity;
import com.pi4j.io.serial.SerialConfig;
import com.pi4j.io.serial.SerialConfigBuilder;
import com.pi4j.io.serial.SerialProvider;
import com.pi4j.io.serial.StopBits;

public interface Serial
extends IO<Serial, SerialConfig, SerialProvider>,
AutoCloseable,
IODataWriter,
IODataReader {
    public static final int DEFAULT_BAUD = 9600;
    public static final DataBits DEFAULT_DATA_BITS = DataBits._8;
    public static final Parity DEFAULT_PARITY = Parity.NONE;
    public static final StopBits DEFAULT_STOP_BITS = StopBits._1;
    public static final FlowControl DEFAULT_FLOW_CONTROL = FlowControl.NONE;

    public static SerialConfigBuilder newConfigBuilder(Context context) {
        return SerialConfigBuilder.newInstance(context);
    }

    public boolean isOpen();

    public int available();

    default public int drain() {
        int avail = this.available();
        if (avail > 0) {
            byte[] temp = new byte[avail];
            return this.read(temp);
        }
        return 0;
    }

    public void open();

    @Override
    public void close();
}

