/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial;

public enum Parity {
    NONE(0),
    ODD(1),
    EVEN(2),
    MARK(3),
    SPACE(4);

    private int index = 0;

    private Parity(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public static Parity getInstance(String parity) {
        return Parity.valueOf(parity.toUpperCase());
    }

    public static Parity getInstance(int parity) {
        for (Parity p : Parity.values()) {
            if (p.getIndex() != parity) continue;
            return p;
        }
        return null;
    }

    public static Parity parse(String parity) {
        if (parity.equalsIgnoreCase("0")) {
            return NONE;
        }
        if (parity.equalsIgnoreCase("1")) {
            return ODD;
        }
        if (parity.equalsIgnoreCase("2")) {
            return EVEN;
        }
        if (parity.equalsIgnoreCase("3")) {
            return MARK;
        }
        if (parity.equalsIgnoreCase("4")) {
            return SPACE;
        }
        if (parity.toLowerCase().startsWith("n")) {
            return NONE;
        }
        if (parity.toLowerCase().startsWith("o")) {
            return ODD;
        }
        if (parity.toLowerCase().startsWith("e")) {
            return EVEN;
        }
        if (parity.toLowerCase().startsWith("m")) {
            return MARK;
        }
        if (parity.toLowerCase().startsWith("s")) {
            return SPACE;
        }
        return NONE;
    }
}

