/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.pwm;

import java.util.EnumSet;

public enum PwmPolarity {
    NORMAL(0, "normal"),
    INVERSED(1, "inversed");

    private final int value;
    private final String name;

    private PwmPolarity(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toUpperCase();
    }

    public static EnumSet<PwmPolarity> all() {
        return EnumSet.allOf(PwmPolarity.class);
    }

    public static PwmPolarity parse(String polarity) {
        if (polarity.equalsIgnoreCase("0")) {
            return NORMAL;
        }
        if (polarity.equalsIgnoreCase("1")) {
            return INVERSED;
        }
        if (polarity.toLowerCase().startsWith("n")) {
            return NORMAL;
        }
        if (polarity.toLowerCase().startsWith("i")) {
            return INVERSED;
        }
        return NORMAL;
    }
}

