/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public interface I2CRegisterDataWriter {
    public int writeRegister(int var1, byte var2);

    default public int writeRegister(int register, int b) {
        return this.writeRegister(register, (byte)b);
    }

    default public int writeRegisterWord(int register, int word) {
        byte[] buffer = new byte[]{(byte)(word >> 8), (byte)word};
        return this.writeRegister(register, buffer);
    }

    public int writeRegister(int var1, byte[] var2, int var3, int var4);

    default public int writeRegister(int register, byte[] data, int length) {
        return this.writeRegister(register, data, 0, length);
    }

    public int writeRegister(byte[] var1, byte[] var2, int var3, int var4);

    default public int writeRegister(byte[] register, byte[] data, int length) {
        return this.writeRegister(register, data, 0, length);
    }

    default public int writeRegister(int register, byte ... data) {
        return this.writeRegister(register, data, 0, data.length);
    }

    default public int writeRegister(int register, byte[] ... data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (byte[] ba : data) {
            os.write(ba);
        }
        return this.writeRegister(register, os.toByteArray());
    }

    default public int writeRegister(int register, Collection<byte[]> data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (byte[] ba : data) {
            os.write(ba);
        }
        return this.writeRegister(register, os.toByteArray());
    }

    default public int writeRegister(int register, ByteBuffer buffer, int offset, int length) throws IOException {
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        return this.writeRegister(register, buffer.array(), offset, length);
    }

    default public int writeRegister(int register, ByteBuffer buffer, int length) throws IOException {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.writeRegister(register, buffer, buffer.position(), length);
    }

    default public int writeRegister(int register, ByteBuffer buffer) throws IOException {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        return this.writeRegister(register, buffer, buffer.position(), buffer.remaining());
    }

    default public int writeRegister(int register, ByteBuffer ... buffer) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (ByteBuffer bb : buffer) {
            if (bb.position() == bb.limit()) {
                bb.flip();
            }
            os.write(bb.array());
        }
        return this.writeRegister(register, os.toByteArray());
    }

    default public int writeRegister(int register, InputStream stream) throws IOException {
        return this.writeRegister(register, stream.readAllBytes());
    }

    default public int write(int register, InputStream stream, int length) throws IOException {
        return this.writeRegister(register, stream.readNBytes(length));
    }

    default public int writeRegister(int register, InputStream ... stream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (InputStream is : stream) {
            os.write(is.readAllBytes());
        }
        return this.writeRegister(register, os.toByteArray());
    }

    default public int writeRegister(int register, Charset charset, CharSequence data) throws IOException {
        return this.writeRegister(register, data.toString().getBytes(charset));
    }

    default public int writeRegister(int register, Charset charset, CharSequence ... data) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (CharSequence d : data) {
            builder.append(d);
        }
        return this.writeRegister(register, charset, (CharSequence)builder);
    }

    default public int writeRegister(int register, Charset charset, Collection<CharSequence> ... data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (Collection<CharSequence> csc : data) {
            for (CharSequence cs : csc) {
                os.write(cs.toString().getBytes(charset));
            }
        }
        return this.writeRegister(register, os.toByteArray());
    }

    default public int writeRegister(int register, CharSequence data) throws IOException {
        return this.writeRegister(register, StandardCharsets.US_ASCII, data);
    }

    default public int writeRegister(int register, CharSequence ... data) throws IOException {
        return this.writeRegister(register, StandardCharsets.US_ASCII, data);
    }

    default public int writeRegister(int register, Collection<CharSequence> ... data) throws IOException {
        return this.writeRegister(register, StandardCharsets.US_ASCII, data);
    }

    default public int writeRegister(int register, char[] data, int offset, int length) throws IOException {
        return this.writeRegister(register, StandardCharsets.US_ASCII, data, offset, length);
    }

    default public int writeRegister(int register, char[] data, int length) throws IOException {
        return this.writeRegister(register, StandardCharsets.US_ASCII, data, length);
    }

    default public int writeRegister(int register, char ... data) throws IOException {
        return this.writeRegister(register, StandardCharsets.US_ASCII, data);
    }

    default public int writeRegister(int register, Charset charset, char[] data, int offset, int length) throws IOException {
        ByteBuffer bb = charset.encode(CharBuffer.wrap(data, offset, length));
        return this.writeRegister(register, bb.array());
    }

    default public int writeRegister(int register, Charset charset, char[] data, int length) throws IOException {
        ByteBuffer bb = charset.encode(CharBuffer.wrap(data, 0, length));
        return this.writeRegister(register, bb.array());
    }

    default public int writeRegister(int register, Charset charset, char ... data) throws IOException {
        ByteBuffer bb = charset.encode(CharBuffer.wrap(data));
        return this.writeRegister(register, bb.array());
    }

    default public int writeRegister(int register, Charset charset, Collection<char[]> data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (char[] ca : data) {
            ByteBuffer bb = charset.encode(CharBuffer.wrap(ca));
            os.write(bb.array());
        }
        return this.writeRegister(register, os.toByteArray());
    }

    default public int writeRegister(int register, CharBuffer data, int offset, int length) throws IOException {
        return this.writeRegister(register, StandardCharsets.US_ASCII, data, offset, length);
    }

    default public int writeRegister(int register, CharBuffer data, int length) throws IOException {
        return this.writeRegister(register, StandardCharsets.US_ASCII, data, length);
    }

    default public int writeRegister(int register, CharBuffer data) throws IOException {
        return this.writeRegister(register, StandardCharsets.US_ASCII, data);
    }

    default public int writeRegister(int register, CharBuffer ... data) throws IOException {
        return this.writeRegister(register, StandardCharsets.US_ASCII, data);
    }

    default public int writeRegister(int register, Charset charset, CharBuffer buffer, int offset, int length) throws IOException {
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        ByteBuffer bb = charset.encode(CharBuffer.wrap(buffer.array(), offset, length));
        return this.writeRegister(register, bb.array());
    }

    default public int writeRegister(int register, Charset charset, CharBuffer buffer, int length) throws IOException {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.writeRegister(register, charset, buffer, buffer.position(), length);
    }

    default public int writeRegister(int register, Charset charset, CharBuffer buffer) throws IOException {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        return this.writeRegister(register, charset, buffer, buffer.position(), buffer.remaining());
    }

    default public int writeRegister(int register, Charset charset, CharBuffer ... data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (CharBuffer cb : data) {
            if (cb.position() == cb.limit()) {
                cb.flip();
            }
            ByteBuffer bb = charset.encode(CharBuffer.wrap(cb.array(), cb.position(), cb.remaining()));
            os.write(bb.array());
        }
        return this.writeRegister(register, os.toByteArray());
    }
}

