/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c;

import com.pi4j.context.Context;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.IOBase;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CProvider;
import com.pi4j.io.i2c.I2CRegister;
import com.pi4j.io.i2c.impl.DefaultI2CRegister;

public abstract class I2CBase
extends IOBase<I2C, I2CConfig, I2CProvider>
implements I2C {
    protected boolean isOpen = false;

    public I2CBase(I2CProvider provider, I2CConfig config) {
        super(provider, config);
        this.name = config.name();
        this.id = config.id();
        this.description = config.description();
        this.isOpen = true;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() {
        this.isOpen = false;
    }

    @Override
    public I2CRegister getRegister(int address) {
        return new DefaultI2CRegister(this, address);
    }

    @Override
    public I2C shutdown(Context context) throws ShutdownException {
        if (this.isOpen()) {
            try {
                this.close();
            }
            catch (Exception e) {
                throw new ShutdownException(e);
            }
        }
        return this;
    }
}

