/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.digital;

import java.util.EnumSet;

public enum PullResistance {
    OFF(0, "off"),
    PULL_DOWN(1, "down"),
    PULL_UP(2, "up");

    private final int value;
    private final String name;

    private PullResistance(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toUpperCase();
    }

    public static EnumSet<PullResistance> all() {
        return EnumSet.allOf(PullResistance.class);
    }

    public static PullResistance parse(String pull) {
        if (pull.equalsIgnoreCase("0")) {
            return OFF;
        }
        if (pull.equalsIgnoreCase("1")) {
            return PULL_DOWN;
        }
        if (pull.equalsIgnoreCase("2")) {
            return PULL_UP;
        }
        if (pull.toLowerCase().startsWith("u")) {
            return PULL_UP;
        }
        if (pull.toLowerCase().startsWith("d")) {
            return PULL_DOWN;
        }
        if (pull.toLowerCase().contains("up")) {
            return PULL_UP;
        }
        if (pull.toLowerCase().contains("down")) {
            return PULL_DOWN;
        }
        return OFF;
    }
}

