/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.binding.impl;

import com.pi4j.io.binding.DigitalOutputBinding;
import com.pi4j.io.binding.impl.BindingBase;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.io.gpio.digital.DigitalStateChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDigitalBinding
extends BindingBase<DigitalOutputBinding, DigitalOutput>
implements DigitalOutputBinding {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean inverted = false;

    public DefaultDigitalBinding(DigitalOutput ... member) {
        super(member);
    }

    @Override
    public void process(DigitalStateChangeEvent event) {
        this.members.forEach(target -> {
            try {
                if (this.inverted) {
                    target.state(DigitalState.getInverseState(event.state()));
                } else {
                    target.state(event.state());
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    @Override
    public DigitalOutputBinding invertedState(boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    @Override
    public boolean invertedState() {
        return this.inverted;
    }
}

