/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class BitSetGenerator
extends Generator<BitSet> {
    public BitSetGenerator() {
        super(BitSet.class);
    }

    public BitSet generate(SourceOfRandomness random, GenerationStatus status) {
        int size = status.size();
        BitSet bits = new BitSet(size);
        for (int i = 0; i < size; ++i) {
            bits.set(i, random.nextBoolean());
        }
        return bits;
    }

    public List<BitSet> doShrink(SourceOfRandomness random, BitSet larger) {
        if (larger.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<BitSet> shrinks = new ArrayList<BitSet>();
        shrinks.addAll(larger.stream().mapToObj(i -> larger.get(0, i)).collect(Collectors.toList()));
        shrinks.addAll(larger.stream().mapToObj(i -> {
            BitSet smaller = (BitSet)larger.clone();
            smaller.clear(i);
            return smaller;
        }).collect(Collectors.toList()));
        return shrinks;
    }
}

