/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.TimePicker;
import com.philliphsu.bottomsheetpickers.time.numberpad.INumberPadTimePicker;
import com.philliphsu.bottomsheetpickers.time.numberpad.LocaleModel;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePicker;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePickerBottomSheetComponent;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePickerDialogPresenter;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePickerState;
import com.philliphsu.bottomsheetpickers.time.numberpad.OnAltKeyClickListener;
import com.philliphsu.bottomsheetpickers.time.numberpad.OnBackspaceClickHandler;
import com.philliphsu.bottomsheetpickers.time.numberpad.OnNumberKeyClickListener;
import com.philliphsu.bottomsheetpickers.time.numberpad.Preconditions;

final class NumberPadTimePickerDialogViewDelegate
implements INumberPadTimePicker.DialogView {
    private static final String KEY_DIGITS = "digits";
    private static final String KEY_COUNT = "count";
    private static final String KEY_AM_PM_STATE = "am_pm_state";
    @NonNull
    private final DialogInterface mDelegator;
    @NonNull
    private final NumberPadTimePicker mTimePicker;
    @Nullable
    private final TimePickerDialog.OnTimeSetListener mTimeSetListener;
    private final INumberPadTimePicker.DialogPresenter mPresenter;
    private final TimePicker mDummy;
    private View mOkButton;

    NumberPadTimePickerDialogViewDelegate(@NonNull DialogInterface delegator, @NonNull Context context, @NonNull NumberPadTimePicker timePicker, @Nullable View okButton, @Nullable TimePickerDialog.OnTimeSetListener listener, boolean is24HourMode) {
        this.mDelegator = Preconditions.checkNotNull(delegator);
        this.mTimePicker = Preconditions.checkNotNull(timePicker);
        this.mOkButton = okButton;
        this.mTimeSetListener = listener;
        this.mDummy = new TimePicker(context);
        LocaleModel localeModel = new LocaleModel(context);
        this.mPresenter = new NumberPadTimePickerDialogPresenter(this, localeModel, is24HourMode);
        OnBackspaceClickHandler backspaceClickHandler = new OnBackspaceClickHandler(this.mPresenter);
        this.mTimePicker.setOnBackspaceClickListener(backspaceClickHandler);
        this.mTimePicker.setOnBackspaceLongClickListener(backspaceClickHandler);
        this.mTimePicker.setOnNumberKeyClickListener(new OnNumberKeyClickListener(this.mPresenter));
        this.mTimePicker.setOnAltKeyClickListener(new OnAltKeyClickListener(this.mPresenter));
    }

    @Override
    public void setNumberKeysEnabled(int start, int end) {
        this.mTimePicker.setNumberKeysEnabled(start, end);
    }

    @Override
    public void setBackspaceEnabled(boolean enabled) {
        this.mTimePicker.setBackspaceEnabled(enabled);
    }

    @Override
    public void updateTimeDisplay(CharSequence time) {
        this.mTimePicker.updateTimeDisplay(time);
    }

    @Override
    public void updateAmPmDisplay(CharSequence ampm) {
        this.mTimePicker.updateAmPmDisplay(ampm);
    }

    @Override
    public void setOkButtonEnabled(boolean enabled) {
        if (this.mTimePicker.getLayout() == 2) {
            ((NumberPadTimePickerBottomSheetComponent)this.mTimePicker.getComponent()).setOkButtonEnabled(enabled);
        } else {
            this.mOkButton.setEnabled(enabled);
        }
    }

    @Override
    public void setAmPmDisplayVisible(boolean visible) {
        this.mTimePicker.setAmPmDisplayVisible(visible);
    }

    @Override
    public void setAmPmDisplayIndex(int index) {
        this.mTimePicker.setAmPmDisplayIndex(index);
    }

    @Override
    public void setLeftAltKeyText(CharSequence text) {
        this.mTimePicker.setLeftAltKeyText(text);
    }

    @Override
    public void setRightAltKeyText(CharSequence text) {
        this.mTimePicker.setRightAltKeyText(text);
    }

    @Override
    public void setLeftAltKeyEnabled(boolean enabled) {
        this.mTimePicker.setLeftAltKeyEnabled(enabled);
    }

    @Override
    public void setRightAltKeyEnabled(boolean enabled) {
        this.mTimePicker.setRightAltKeyEnabled(enabled);
    }

    @Override
    public void setHeaderDisplayFocused(boolean focused) {
        this.mTimePicker.setHeaderDisplayFocused(focused);
    }

    @Override
    public void setResult(int hour, int minute) {
        if (this.mTimeSetListener != null) {
            this.mTimeSetListener.onTimeSet(this.mDummy, hour, minute);
        }
    }

    @Override
    public void cancel() {
        this.mDelegator.cancel();
    }

    @Override
    public void showOkButton() {
        if (this.mTimePicker.getLayout() == 2) {
            ((NumberPadTimePickerBottomSheetComponent)this.mTimePicker.getComponent()).showOkButton();
        }
    }

    void onCreate(@Nullable Bundle savedInstanceState) {
        this.mPresenter.onCreate(NumberPadTimePickerDialogViewDelegate.readStateFromBundle(savedInstanceState));
    }

    @NonNull
    Bundle onSaveInstanceState(@NonNull Bundle bundle) {
        INumberPadTimePicker.State state = this.mPresenter.getState();
        bundle.putIntArray(KEY_DIGITS, state.getDigits());
        bundle.putInt(KEY_COUNT, state.getCount());
        bundle.putInt(KEY_AM_PM_STATE, state.getAmPmState());
        return bundle;
    }

    void onStop() {
        this.mPresenter.onStop();
    }

    INumberPadTimePicker.DialogPresenter getPresenter() {
        return this.mPresenter;
    }

    void setOkButton(@NonNull View okButton) {
        this.mOkButton = Preconditions.checkNotNull(okButton);
    }

    @NonNull
    private static INumberPadTimePicker.State readStateFromBundle(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            int[] digits = savedInstanceState.getIntArray(KEY_DIGITS);
            int count = savedInstanceState.getInt(KEY_COUNT);
            int amPmState = savedInstanceState.getInt(KEY_AM_PM_STATE);
            return new NumberPadTimePickerState(digits, count, amPmState);
        }
        return NumberPadTimePickerState.EMPTY;
    }
}

