/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.app.Dialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.text.format.DateFormat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.TimePicker;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.time.BottomSheetTimePickerDialog;
import com.philliphsu.bottomsheetpickers.time.numberpad.BottomSheetNumberPadTimePickerDialog;
import com.philliphsu.bottomsheetpickers.time.numberpad.BottomSheetNumberPadTimePickerDialogThemer;

public class NumberPadTimePickerDialog
extends BottomSheetTimePickerDialog
implements TimePickerDialog.OnTimeSetListener {
    private static final String KEY_SET_24_HOUR_MODE_AT_RUNTIME = "set_24_hour_mode_at_runtime";
    private static final String KEY_IS_24_HOUR_MODE = "is_24_hour_mode";
    private static final String KEY_HINT = "hint";
    private static final String KEY_TEXT_SIZE = "text_size";
    private static final String KEY_HINT_RES_ID = "hint_res_id";
    private static final String KEY_HEADER_TEXT_COLOR = "header_text_color";
    private BottomSheetNumberPadTimePickerDialog mDialog;
    private BottomSheetTimePickerDialog.OnTimeSetListener mTimeSetListener;
    private TextView mInputField;
    private boolean mSet24HourModeAtRuntime;
    private boolean mIs24HourMode;
    private String mHint;
    private int mTextSize;
    private int mHintResId;
    private int mHeaderTextColor;

    public static NumberPadTimePickerDialog newInstance(BottomSheetTimePickerDialog.OnTimeSetListener callback) {
        NumberPadTimePickerDialog ret = new NumberPadTimePickerDialog();
        ret.initialize(callback, false, false);
        return ret;
    }

    public static NumberPadTimePickerDialog newInstance(BottomSheetTimePickerDialog.OnTimeSetListener callback, boolean is24HourMode) {
        NumberPadTimePickerDialog ret = new NumberPadTimePickerDialog();
        ret.initialize(callback, true, is24HourMode);
        return ret;
    }

    private void initialize(BottomSheetTimePickerDialog.OnTimeSetListener callback, boolean set24HourModeAtRuntime, boolean is24HourMode) {
        this.mTimeSetListener = callback;
        this.mThemeDark = false;
        this.mThemeSetAtRuntime = false;
        this.mSet24HourModeAtRuntime = set24HourModeAtRuntime;
        if (set24HourModeAtRuntime) {
            this.mIs24HourMode = is24HourMode;
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mSet24HourModeAtRuntime = savedInstanceState.getBoolean(KEY_SET_24_HOUR_MODE_AT_RUNTIME);
            this.mIs24HourMode = savedInstanceState.getBoolean(KEY_IS_24_HOUR_MODE);
            this.mHint = savedInstanceState.getString(KEY_HINT);
            this.mTextSize = savedInstanceState.getInt(KEY_TEXT_SIZE);
            this.mHintResId = savedInstanceState.getInt(KEY_HINT_RES_ID);
            this.mHeaderTextColor = savedInstanceState.getInt(KEY_HEADER_TEXT_COLOR);
        } else if (!this.mSet24HourModeAtRuntime) {
            this.mIs24HourMode = DateFormat.is24HourFormat((Context)this.getActivity());
        }
    }

    @Override
    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        this.mDialog = new BottomSheetNumberPadTimePickerDialog((Context)this.getActivity(), this, this.mIs24HourMode);
        return this.mDialog;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int[] buttonIds;
        super.onCreateView(inflater, container, savedInstanceState);
        this.mInputField = (TextView)this.mDialog.findViewById(R.id.bsp_input_time);
        BottomSheetNumberPadTimePickerDialogThemer themer = this.mDialog.getThemer();
        themer.setHeaderBackground((Drawable)new ColorDrawable(this.mHeaderColor)).setDivider((Drawable)new ColorDrawable(this.mHeaderColor));
        themer.setNumberPadBackground((Drawable)new ColorDrawable(this.mBackgroundColor)).setBackspaceLocation(1);
        int headerTextColor = this.mHeaderTextColor != 0 ? this.mHeaderTextColor : this.getDefaultHeaderTextColor();
        themer.setInputTimeTextColor(headerTextColor).setInputAmPmTextColor(headerTextColor);
        int disabledColor = ContextCompat.getColor((Context)this.getActivity(), (int)(this.mThemeDark ? R.color.bsp_fab_disabled_dark : R.color.bsp_fab_disabled_light));
        int[][] states = new int[][]{{-16842910}, new int[0]};
        int[] colors = new int[]{disabledColor, this.mAccentColor};
        themer.setFabBackgroundColor(new ColorStateList((int[][])states, colors));
        ColorStateList textColors = ContextCompat.getColorStateList((Context)this.getActivity(), (int)(this.mThemeDark ? R.color.bsp_numeric_keypad_button_text_dark : R.color.bsp_numeric_keypad_button_text));
        themer.setNumberKeysTextColor(textColors).setAltKeysTextColor(textColors);
        ColorStateList colorBackspace = ContextCompat.getColorStateList((Context)this.getActivity(), (int)(this.mThemeDark ? R.color.bsp_icon_color_dark : R.color.bsp_icon_color));
        themer.setBackspaceTint(colorBackspace);
        ColorStateList colorIcon = ContextCompat.getColorStateList((Context)this.getActivity(), (int)(this.mThemeDark ? R.color.bsp_icon_color_dark : R.color.bsp_fab_icon_color));
        themer.setFabIconTint(colorIcon);
        for (int id2 : buttonIds = new int[]{R.id.bsp_text0, R.id.bsp_text1, R.id.bsp_text2, R.id.bsp_text3, R.id.bsp_text4, R.id.bsp_text5, R.id.bsp_text6, R.id.bsp_text7, R.id.bsp_text8, R.id.bsp_text9, R.id.bsp_text10, R.id.bsp_text11}) {
            Utils.setColorControlHighlight(this.mDialog.findViewById(id2), this.mAccentColor);
        }
        Utils.setColorControlHighlight(this.mDialog.findViewById(R.id.bsp_backspace), this.mAccentColor);
        if (this.mHint != null || this.mHintResId != 0) {
            if (this.mHint != null) {
                this.mInputField.setHint((CharSequence)this.mHint);
            } else {
                this.mInputField.setHint(this.mHintResId);
            }
        }
        if (this.mTextSize != 0) {
            this.mInputField.setTextSize(0, (float)this.mTextSize);
        }
        return null;
    }

    @Override
    protected int contentLayout() {
        return 0;
    }

    public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
        if (this.mTimeSetListener != null) {
            this.mTimeSetListener.onTimeSet((ViewGroup)view, hourOfDay, minute);
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_SET_24_HOUR_MODE_AT_RUNTIME, this.mSet24HourModeAtRuntime);
        outState.putBoolean(KEY_IS_24_HOUR_MODE, this.mIs24HourMode);
        outState.putString(KEY_HINT, this.mHint);
        outState.putInt(KEY_TEXT_SIZE, this.mTextSize);
        outState.putInt(KEY_HINT_RES_ID, this.mHintResId);
        outState.putInt(KEY_HEADER_TEXT_COLOR, this.mHeaderTextColor);
    }

    public void setHint(String hint) {
        if (this.mInputField != null) {
            this.mInputField.setHint((CharSequence)this.mHint);
        }
        this.mHint = hint;
        this.mHintResId = 0;
    }

    public void setHint(@StringRes int resid) {
        if (this.mInputField != null) {
            this.mInputField.setHint(resid);
        }
        this.mHintResId = resid;
        this.mHint = null;
    }

    public void setInputTextSize(int textSize) {
        if (this.mInputField != null) {
            this.mInputField.setTextSize(0, (float)textSize);
        }
        this.mTextSize = textSize;
    }

    public TextView getInputTextView() {
        return this.mInputField;
    }

    public final void setHeaderTextColor(@ColorInt int color2) {
        this.mHeaderTextColor = color2;
    }

    @ColorInt
    private int getDefaultHeaderTextColor() {
        return this.getDefaultHeaderTextColorSelected();
    }

    public static final class Builder
    extends BottomSheetTimePickerDialog.Builder {
        private final boolean mSet24HourMode;
        private int mHeaderTextColor;

        public Builder(BottomSheetTimePickerDialog.OnTimeSetListener listener) {
            super(listener);
            this.mSet24HourMode = false;
        }

        public Builder(BottomSheetTimePickerDialog.OnTimeSetListener listener, boolean is24HourMode) {
            super(listener, is24HourMode);
            this.mSet24HourMode = true;
        }

        public Builder setHeaderTextColor(@ColorInt int color2) {
            this.mHeaderTextColor = color2;
            return this;
        }

        @Override
        public Builder setAccentColor(int accentColor) {
            return (Builder)super.setAccentColor(accentColor);
        }

        @Override
        public Builder setBackgroundColor(int backgroundColor) {
            return (Builder)super.setBackgroundColor(backgroundColor);
        }

        @Override
        public Builder setHeaderColor(int headerColor) {
            return (Builder)super.setHeaderColor(headerColor);
        }

        @Override
        public Builder setHeaderTextDark(boolean headerTextDark) {
            return (Builder)super.setHeaderTextDark(headerTextDark);
        }

        @Override
        public Builder setThemeDark(boolean themeDark) {
            return (Builder)super.setThemeDark(themeDark);
        }

        @Override
        public NumberPadTimePickerDialog build() {
            NumberPadTimePickerDialog dialog = this.mSet24HourMode ? NumberPadTimePickerDialog.newInstance(this.mListener, this.mIs24HourMode) : NumberPadTimePickerDialog.newInstance(this.mListener);
            this.super_build(dialog);
            dialog.setHeaderTextColor(this.mHeaderTextColor);
            return dialog;
        }
    }
}

