/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import com.philliphsu.bottomsheetpickers.time.numberpad.DigitwiseTimeModel;

final class DigitwiseTimeParser {
    private final DigitwiseTimeModel mModel;

    DigitwiseTimeParser(DigitwiseTimeModel model) {
        this.mModel = model;
    }

    int getHour(int amPmState) {
        int hours;
        if (!this.checkTimeValid(amPmState)) {
            throw new IllegalStateException("Cannot call hourOfDay() until legal time inputted");
        }
        int n = hours = this.count() < 4 ? this.valueAt(0) : this.valueAt(0) * 10 + this.valueAt(1);
        if (hours == 12) {
            switch (amPmState) {
                case 0: {
                    return 0;
                }
                case 1: 
                case 2: {
                    return 12;
                }
            }
        }
        return hours + (amPmState == 1 ? 12 : 0);
    }

    int getMinute(int amPmState) {
        if (!this.checkTimeValid(amPmState)) {
            throw new IllegalStateException("Cannot call minute() until legal time inputted");
        }
        return this.count() < 4 ? this.valueAt(1) * 10 + this.valueAt(2) : this.valueAt(2) * 10 + this.valueAt(3);
    }

    boolean checkTimeValid(int amPmState) {
        return amPmState != -1 && (amPmState != 2 || this.count() >= 3);
    }

    private int valueAt(int i) {
        return this.mModel.getDigit(i);
    }

    private int count() {
        return this.mModel.count();
    }
}

