/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.support.annotation.NonNull;
import com.philliphsu.bottomsheetpickers.time.numberpad.LocaleModel;
import java.text.DateFormatSymbols;

final class ButtonTextModel {
    private static final String[] NUMBERS_TEXTS = new String[10];
    private static final int[] ALT_DIGITS_00 = new int[]{0, 0};
    private static final int[] ALT_DIGITS_30 = new int[]{3, 0};
    private final String[] mAltButtonsTexts = new String[2];
    private final boolean mIs24HourMode;

    ButtonTextModel(@NonNull LocaleModel localeModel, boolean is24HourMode) {
        String rightAltText;
        String leftAltText;
        String timeSeparator = localeModel.getTimeSeparator(is24HourMode);
        if (is24HourMode) {
            leftAltText = String.format("%02d", 0);
            rightAltText = String.format("%02d", 30);
            leftAltText = localeModel.isLayoutRtl() ? leftAltText + timeSeparator : timeSeparator + leftAltText;
            rightAltText = localeModel.isLayoutRtl() ? rightAltText + timeSeparator : timeSeparator + rightAltText;
        } else {
            String[] amPm = new DateFormatSymbols().getAmPmStrings();
            leftAltText = amPm[0].length() > 2 ? "AM" : amPm[0];
            rightAltText = amPm[1].length() > 2 ? "PM" : amPm[1];
        }
        this.mAltButtonsTexts[0] = leftAltText;
        this.mAltButtonsTexts[1] = rightAltText;
        this.mIs24HourMode = is24HourMode;
    }

    static String text(int digit) {
        return NUMBERS_TEXTS[digit];
    }

    static int digit(String text) {
        for (int i = 0; i < NUMBERS_TEXTS.length; ++i) {
            if (!NUMBERS_TEXTS[i].equals(text)) continue;
            return i;
        }
        throw new IllegalArgumentException("Cannot convert \"" + text + "\" to digit");
    }

    String altText(int leftOrRight) {
        return this.mAltButtonsTexts[leftOrRight];
    }

    int[] altDigits(String altText) {
        if (!this.mIs24HourMode || this.mAltButtonsTexts[0].equals(altText)) {
            return ALT_DIGITS_00;
        }
        if (this.mAltButtonsTexts[1].equals(altText)) {
            return ALT_DIGITS_30;
        }
        throw new IllegalArgumentException("Cannot convert \"" + altText + "\" to alt digits");
    }

    static {
        for (int i = 0; i < 10; ++i) {
            ButtonTextModel.NUMBERS_TEXTS[i] = String.format("%d", i);
        }
    }
}

