/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialog;
import android.support.design.widget.FloatingActionButton;
import android.util.TypedValue;
import android.view.View;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.time.numberpad.BottomSheetNumberPadTimePickerDialogThemer;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePicker;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePickerBottomSheetComponent;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePickerDialogViewDelegate;

class BottomSheetNumberPadTimePickerDialog
extends BottomSheetDialog {
    private final NumberPadTimePickerDialogViewDelegate mViewDelegate;
    private final BottomSheetNumberPadTimePickerDialogThemer mThemer;
    private final BottomSheetBehavior<? extends View> mBottomSheetBehavior;

    public BottomSheetNumberPadTimePickerDialog(@NonNull Context context, @Nullable TimePickerDialog.OnTimeSetListener listener, boolean is24HourMode) {
        this(context, 0, listener, is24HourMode);
    }

    public BottomSheetNumberPadTimePickerDialog(@NonNull Context context, @StyleRes int themeResId, @Nullable TimePickerDialog.OnTimeSetListener listener, boolean is24HourMode) {
        super(context, BottomSheetNumberPadTimePickerDialog.resolveDialogTheme(context, themeResId));
        View root = this.getLayoutInflater().inflate(R.layout.bsp_bottomsheet_numberpad_time_picker_dialog, null);
        NumberPadTimePicker timePicker = (NumberPadTimePicker)root.findViewById(R.id.bsp_time_picker);
        NumberPadTimePickerBottomSheetComponent timePickerComponent = (NumberPadTimePickerBottomSheetComponent)timePicker.getComponent();
        FloatingActionButton okButton = timePickerComponent.getOkButton();
        this.mViewDelegate = new NumberPadTimePickerDialogViewDelegate((DialogInterface)this, this.getContext(), timePicker, (View)okButton, listener, is24HourMode);
        this.setContentView(root);
        this.mThemer = new BottomSheetNumberPadTimePickerDialogThemer(timePickerComponent);
        this.mBottomSheetBehavior = BottomSheetBehavior.from((View)((View)root.getParent()));
        okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BottomSheetNumberPadTimePickerDialog.this.mViewDelegate.getPresenter().onOkButtonClick();
            }
        });
        this.mBottomSheetBehavior.setPeekHeight(this.getContext().getResources().getDimensionPixelSize(R.dimen.bsp_bottom_sheet_grid_picker_peek_height));
        this.mBottomSheetBehavior.setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

            public void onStateChanged(@NonNull View bottomSheet, int newState) {
                switch (newState) {
                    case 5: {
                        BottomSheetNumberPadTimePickerDialog.this.cancel();
                        break;
                    }
                    case 4: {
                        BottomSheetNumberPadTimePickerDialog.this.mBottomSheetBehavior.setState(3);
                    }
                }
            }

            public void onSlide(@NonNull View bottomSheet, float slideOffset) {
            }
        });
    }

    public BottomSheetNumberPadTimePickerDialogThemer getThemer() {
        return this.mThemer;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.getWindow().setLayout(this.getContext().getResources().getDimensionPixelSize(R.dimen.bsp_bottom_sheet_dialog_width), -2);
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        this.mViewDelegate.onCreate(savedInstanceState);
    }

    protected void onStart() {
        super.onStart();
        this.mBottomSheetBehavior.setState(3);
    }

    public void show() {
        super.show();
        this.mViewDelegate.getPresenter().onDialogShow();
    }

    @NonNull
    public Bundle onSaveInstanceState() {
        return this.mViewDelegate.onSaveInstanceState(super.onSaveInstanceState());
    }

    protected void onStop() {
        super.onStop();
        this.mViewDelegate.onStop();
    }

    static int resolveDialogTheme(Context context, int resId) {
        if (resId == 0) {
            TypedValue outValue = new TypedValue();
            context.getTheme().resolveAttribute(R.attr.bsp_numberPadTimePickerBottomSheetDialogTheme, outValue, true);
            return outValue.resourceId;
        }
        return resId;
    }
}

