/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.grid;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.time.grid.NumbersGrid;
import com.philliphsu.bottomsheetpickers.time.grid.TwentyFourHourGridItem;

public class TwentyFourHoursGrid
extends NumbersGrid
implements View.OnLongClickListener {
    private static final String TAG = "TwentyFourHoursGrid";
    private int mSecondaryTextColor;

    public TwentyFourHoursGrid(Context context) {
        this(context, null);
    }

    public TwentyFourHoursGrid(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TwentyFourHoursGrid(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mSecondaryTextColor = ContextCompat.getColor((Context)context, (int)R.color.bsp_text_color_secondary_light);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setOnLongClickListener((View.OnLongClickListener)this);
        }
    }

    @Override
    protected boolean canRegisterClickListener(View view) {
        return view instanceof TwentyFourHourGridItem;
    }

    @Override
    public void onClick(View v) {
        int newVal = this.valueOf(v);
        this.setSelection(newVal);
        this.mSelectionListener.onNumberSelected(newVal);
    }

    public boolean onLongClick(View v) {
        TwentyFourHourGridItem item = (TwentyFourHourGridItem)v;
        int newVal = Integer.parseInt(item.getSecondaryText().toString());
        this.mSelectionListener.onNumberSelected(newVal);
        this.swapTexts();
        this.setSelection(newVal);
        return true;
    }

    @Override
    public void setSelection(int value) {
        super.setSelection(value);
        this.setIndicator(this.getChildAt(value % 12));
    }

    @Override
    protected void setIndicator(View view) {
        TwentyFourHourGridItem item = (TwentyFourHourGridItem)view;
        super.setIndicator((View)item.getPrimaryTextView());
    }

    @Override
    void setTheme(Context context, boolean themeDark) {
        this.mDefaultTextColor = ContextCompat.getColor((Context)context, (int)(themeDark ? R.color.bsp_text_color_primary_dark : R.color.bsp_text_color_primary_light));
        this.mSecondaryTextColor = ContextCompat.getColor((Context)context, (int)(themeDark ? R.color.bsp_text_color_secondary_dark : R.color.bsp_text_color_secondary_light));
        for (int i = 0; i < this.getChildCount(); ++i) {
            TwentyFourHourGridItem item = (TwentyFourHourGridItem)this.getChildAt(i);
            Utils.setColorControlHighlight((View)item, this.mSelectedTextColor);
            if (this.getSelection() != this.valueOf((View)item)) {
                item.getPrimaryTextView().setTextColor(this.mDefaultTextColor);
            }
            item.getSecondaryTextView().setTextColor(this.mSecondaryTextColor);
        }
    }

    public void swapTexts() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View v = this.getChildAt(i);
            ((TwentyFourHourGridItem)v).swapTexts();
        }
    }

    @Override
    protected int valueOf(View button) {
        return Integer.parseInt(((TwentyFourHourGridItem)button).getPrimaryText().toString());
    }
}

