/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.philliphsu.bottomsheetpickers.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class DayPickerViewPager
extends ViewPager {
    private static final String TAG = DayPickerViewPager.class.getSimpleName();
    private final ArrayList<View> mMatchParentChildren = new ArrayList(1);
    private Method mPopulateMethod;
    private boolean mAlreadyTriedAccessingMethod;

    public DayPickerViewPager(Context context) {
        this(context, null);
    }

    public DayPickerViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable drawable2;
        ViewPager.LayoutParams lp;
        View child;
        int i;
        this.callPopulate();
        int count = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            lp = (ViewPager.LayoutParams)child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            childState = DayPickerViewPager.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        if (Utils.checkApiLevel(23) && (drawable2 = this.getForeground()) != null) {
            maxHeight = Math.max(maxHeight, drawable2.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable2.getMinimumWidth());
        }
        this.setMeasuredDimension(DayPickerViewPager.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), DayPickerViewPager.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (i = 0; i < count; ++i) {
                child = this.mMatchParentChildren.get(i);
                lp = (ViewPager.LayoutParams)child.getLayoutParams();
                int childWidthMeasureSpec = lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000) : DayPickerViewPager.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)lp.width);
                int childHeightMeasureSpec = lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000) : DayPickerViewPager.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)lp.height);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
        this.mMatchParentChildren.clear();
    }

    private void initializePopulateMethod() {
        try {
            this.mPopulateMethod = ViewPager.class.getDeclaredMethod("populate", null);
            this.mPopulateMethod.setAccessible(true);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        this.mAlreadyTriedAccessingMethod = true;
    }

    private void callPopulate() {
        if (!this.mAlreadyTriedAccessingMethod) {
            this.initializePopulateMethod();
        }
        if (this.mPopulateMethod != null) {
            try {
                this.mPopulateMethod.invoke((Object)this, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            Log.e((String)TAG, (String)"Could not call `ViewPager.populate()`");
        }
    }
}

