/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.content.Context;
import android.content.res.ColorStateList;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.time.numberpad.ButtonTextModel;
import com.philliphsu.bottomsheetpickers.time.numberpad.GridPickerView;

class NumberPadView
extends GridPickerView {
    private final TextView[] mNumberButtons = new TextView[10];
    private final TextView[] mAltButtons = new TextView[2];

    public NumberPadView(Context context) {
        this(context, null);
    }

    public NumberPadView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NumberPadView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mNumberButtons[0] = this.getButton(10);
        this.mNumberButtons[0].setText((CharSequence)ButtonTextModel.text(0));
        for (int i = 0; i < this.mNumberButtons.length - 1; ++i) {
            TextView button = this.getButton(i);
            button.setText((CharSequence)ButtonTextModel.text(i + 1));
            this.mNumberButtons[i + 1] = button;
        }
        this.mAltButtons[0] = this.getButton(9);
        this.mAltButtons[1] = this.getButton(11);
    }

    void setNumberKeysEnabled(int lowerLimitInclusive, int upperLimitExclusive) {
        if (lowerLimitInclusive < 0 || upperLimitExclusive > this.mNumberButtons.length) {
            throw new IndexOutOfBoundsException("Upper limit out of range");
        }
        for (int i = 0; i < this.mNumberButtons.length; ++i) {
            this.mNumberButtons[i].setEnabled(i >= lowerLimitInclusive && i < upperLimitExclusive);
        }
    }

    void setOnNumberKeyClickListener(View.OnClickListener l) {
        for (TextView tv : this.mNumberButtons) {
            tv.setOnClickListener(l);
        }
    }

    void setOnAltKeyClickListener(View.OnClickListener l) {
        this.mAltButtons[0].setOnClickListener(l);
        this.mAltButtons[1].setOnClickListener(l);
    }

    void setLeftAltKeyEnabled(boolean enabled) {
        this.mAltButtons[0].setEnabled(enabled);
    }

    void setRightAltKeyEnabled(boolean enabled) {
        this.mAltButtons[1].setEnabled(enabled);
    }

    void setLeftAltKeyText(CharSequence text) {
        this.mAltButtons[0].setText(text);
    }

    void setRightAltKeyText(CharSequence text) {
        this.mAltButtons[1].setText(text);
    }

    void setNumberKeysTextColor(ColorStateList colors) {
        for (TextView tv : this.mNumberButtons) {
            tv.setTextColor(colors);
        }
    }

    void setAltKeysTextColor(ColorStateList colors) {
        for (TextView tv : this.mAltButtons) {
            tv.setTextColor(colors);
        }
    }
}

