/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.support.annotation.NonNull;
import com.philliphsu.bottomsheetpickers.time.numberpad.ButtonTextModel;
import com.philliphsu.bottomsheetpickers.time.numberpad.DigitwiseTimeModel;
import com.philliphsu.bottomsheetpickers.time.numberpad.INumberPadTimePicker;
import com.philliphsu.bottomsheetpickers.time.numberpad.LocaleModel;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePickerState;
import com.philliphsu.bottomsheetpickers.time.numberpad.Preconditions;

class NumberPadTimePickerPresenter
implements INumberPadTimePicker.Presenter,
DigitwiseTimeModel.OnInputChangeListener {
    private static final int MAX_CHARS = 5;
    private final StringBuilder mFormattedInput = new StringBuilder(5);
    private final String[] mAltTexts = new String[2];
    @NonNull
    private final LocaleModel mLocaleModel;
    private final ButtonTextModel mTextModel;
    private final String mTimeSeparator;
    private final boolean mIs24HourMode;
    private INumberPadTimePicker.View mView;
    private boolean mAltKeysDisabled;
    private boolean mAllNumberKeysDisabled;
    private boolean mHeaderDisplayFocused;
    final DigitwiseTimeModel mTimeModel = new DigitwiseTimeModel(this);
    int mAmPmState = -1;

    NumberPadTimePickerPresenter(@NonNull INumberPadTimePicker.View view, @NonNull LocaleModel localeModel, boolean is24HourMode) {
        this.mView = Preconditions.checkNotNull(view);
        this.mLocaleModel = Preconditions.checkNotNull(localeModel);
        this.mTimeSeparator = localeModel.getTimeSeparator(is24HourMode);
        this.mIs24HourMode = is24HourMode;
        ButtonTextModel textModel = new ButtonTextModel(localeModel, is24HourMode);
        this.mAltTexts[0] = textModel.altText(0);
        this.mAltTexts[1] = textModel.altText(1);
        this.mTextModel = textModel;
    }

    @Override
    public void onNumberKeyClick(CharSequence numberKeyText) {
        this.mTimeModel.storeDigit(ButtonTextModel.digit(numberKeyText.toString()));
    }

    @Override
    public void onAltKeyClick(CharSequence altKeyText) {
        String altKeyString = altKeyText.toString();
        int[] altDigits = this.mTextModel.altDigits(altKeyString);
        if (this.count() <= 2) {
            this.insertDigits(altDigits);
        }
        if (!this.is24HourFormat()) {
            this.mAmPmState = altKeyString.equalsIgnoreCase(this.mAltTexts[0]) ? 0 : 1;
            this.mView.updateAmPmDisplay(altKeyString);
        } else {
            this.mAmPmState = 2;
        }
        this.updateViewEnabledStates();
    }

    @Override
    public void onBackspaceClick() {
        if (!this.mIs24HourMode && this.mAmPmState != -1) {
            this.mAmPmState = -1;
            this.mView.updateAmPmDisplay(null);
            this.updateViewEnabledStates();
        } else {
            this.mTimeModel.removeDigit();
        }
    }

    @Override
    public boolean onBackspaceLongClick() {
        return this.mTimeModel.clearDigits();
    }

    @Override
    public void onCreate(@NonNull INumberPadTimePicker.State state) {
        this.initialize(state);
        if (!this.mIs24HourMode) {
            String amPmDisplayText;
            this.mView.setAmPmDisplayIndex(this.mLocaleModel.isAmPmWrittenBeforeTime() ? 0 : 1);
            switch (state.getAmPmState()) {
                case 0: {
                    amPmDisplayText = this.mAltTexts[0];
                    break;
                }
                case 1: {
                    amPmDisplayText = this.mAltTexts[1];
                    break;
                }
                default: {
                    amPmDisplayText = null;
                }
            }
            this.mView.updateAmPmDisplay(amPmDisplayText);
        }
        this.mView.setAmPmDisplayVisible(!this.mIs24HourMode);
        this.setAltKeysTexts();
        this.updateViewEnabledStates();
    }

    @Override
    public void onStop() {
        this.mView = null;
    }

    @Override
    public INumberPadTimePicker.State getState() {
        return new NumberPadTimePickerState(this.mTimeModel.getDigits(), this.mTimeModel.count(), this.mAmPmState);
    }

    @Override
    public void onDigitStored(int digit) {
        this.updateFormattedInputOnDigitInserted(digit);
        this.mView.updateTimeDisplay(this.mFormattedInput.toString());
        this.updateViewEnabledStates();
    }

    @Override
    public void onDigitRemoved(int digit) {
        this.updateFormattedInputOnDigitDeleted();
        this.mView.updateTimeDisplay(this.mFormattedInput.toString());
        this.updateViewEnabledStates();
    }

    @Override
    public void onDigitsCleared() {
        this.mFormattedInput.delete(0, this.mFormattedInput.length());
        this.mAmPmState = -1;
        this.updateViewEnabledStates();
        this.mView.updateTimeDisplay(null);
        if (!this.mIs24HourMode) {
            this.mView.updateAmPmDisplay(null);
        }
    }

    private void initialize(@NonNull INumberPadTimePicker.State savedInstanceState) {
        this.insertDigits(savedInstanceState.getDigits());
        this.mAmPmState = savedInstanceState.getAmPmState();
    }

    private int count() {
        return this.mTimeModel.count();
    }

    private boolean is24HourFormat() {
        return this.mIs24HourMode;
    }

    private int getDigitsAsInteger() {
        return this.mTimeModel.getDigitsAsInteger();
    }

    private void enable(int start, int end) {
        this.mView.setNumberKeysEnabled(start, end);
        this.mAllNumberKeysDisabled = start == 0 && end == 0;
    }

    private void insertDigits(int ... digits) {
        this.mTimeModel.storeDigits(digits);
    }

    private void setAltKeysTexts() {
        this.mView.setLeftAltKeyText(this.mAltTexts[0]);
        this.mView.setRightAltKeyText(this.mAltTexts[1]);
    }

    void updateViewEnabledStates() {
        this.updateNumberKeysStates();
        this.updateAltKeysStates();
        this.updateBackspaceState();
        this.updateHeaderDisplayFocus();
    }

    private void updateHeaderDisplayFocus() {
        boolean showHeaderDisplayFocused;
        boolean bl = showHeaderDisplayFocused = !this.mAllNumberKeysDisabled || !this.mAltKeysDisabled;
        if (this.mHeaderDisplayFocused != showHeaderDisplayFocused) {
            this.mView.setHeaderDisplayFocused(showHeaderDisplayFocused);
            this.mHeaderDisplayFocused = showHeaderDisplayFocused;
        }
    }

    private void updateBackspaceState() {
        this.mView.setBackspaceEnabled(this.count() > 0);
    }

    private void updateAltKeysStates() {
        boolean enabled = false;
        if (this.count() == 0) {
            enabled = false;
        } else if (this.count() == 1) {
            enabled = true;
        } else if (this.count() == 2) {
            int time = this.getDigitsAsInteger();
            enabled = this.is24HourFormat() ? time <= 23 : time >= 10 && time <= 12;
        } else if (this.count() == 3 || this.count() == 4) {
            enabled = !this.is24HourFormat() && this.mAmPmState == -1;
        }
        this.mView.setLeftAltKeyEnabled(enabled);
        this.mView.setRightAltKeyEnabled(enabled);
        this.mAltKeysDisabled = !enabled;
    }

    private void updateNumberKeysStates() {
        int cap = 10;
        boolean is24hours = this.is24HourFormat();
        if (this.count() == 0) {
            this.enable(is24hours ? 0 : 1, cap);
            return;
        }
        if (this.count() == 4) {
            this.enable(0, 0);
            return;
        }
        int time = this.getDigitsAsInteger();
        if (is24hours) {
            if (this.count() == 1) {
                this.enable(0, time < 2 ? cap : 6);
            } else if (this.count() == 2) {
                this.enable(0, time % 10 >= 0 && time % 10 <= 5 ? cap : 6);
            } else if (this.count() == 3) {
                if (time >= 236) {
                    this.enable(0, 0);
                } else {
                    this.enable(0, time % 10 >= 0 && time % 10 <= 5 ? cap : 0);
                }
            }
        } else if (this.count() == 1) {
            if (time == 0) {
                throw new IllegalStateException("12-hr format, zeroth digit = 0?");
            }
            this.enable(0, 6);
        } else if (this.count() == 2 || this.count() == 3) {
            if (time >= 126) {
                this.enable(0, 0);
            } else if (time >= 100 && time <= 125 && this.mAmPmState != -1) {
                this.enable(0, 0);
            } else {
                this.enable(0, time % 10 >= 0 && time % 10 <= 5 ? cap : 0);
            }
        }
    }

    private void updateFormattedInputOnDigitInserted(int newDigit) {
        this.mFormattedInput.append(String.format("%d", newDigit));
        if (this.count() == 3) {
            int digits = this.getDigitsAsInteger();
            if (digits >= 60 && digits < 100 || digits >= 160 && digits < 200) {
                this.mFormattedInput.insert(2, this.mTimeSeparator);
            } else {
                this.mFormattedInput.insert(1, this.mTimeSeparator);
                if (this.is24HourFormat()) {
                    this.mAmPmState = 2;
                }
            }
        } else if (this.count() == 4) {
            int timeSeparatorAt = this.mFormattedInput.indexOf(this.mTimeSeparator);
            if (timeSeparatorAt != -1) {
                this.mFormattedInput.deleteCharAt(timeSeparatorAt);
            }
            this.mFormattedInput.insert(2, this.mTimeSeparator);
            if (this.is24HourFormat()) {
                this.mAmPmState = 2;
            }
        }
    }

    private void updateFormattedInputOnDigitDeleted() {
        int len = this.mFormattedInput.length();
        this.mFormattedInput.delete(len - 1, len);
        if (this.count() == 3) {
            int value = this.getDigitsAsInteger();
            if (value >= 0 && value <= 55 || value >= 100 && value <= 155 || value >= 200 && value <= 235) {
                this.mFormattedInput.deleteCharAt(this.mFormattedInput.indexOf(this.mTimeSeparator));
                this.mFormattedInput.insert(1, this.mTimeSeparator);
            } else {
                this.mAmPmState = -1;
            }
        } else if (this.count() == 2) {
            this.mFormattedInput.deleteCharAt(this.mFormattedInput.indexOf(this.mTimeSeparator));
            this.mAmPmState = -1;
        }
    }
}

