/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.support.annotation.NonNull;
import com.philliphsu.bottomsheetpickers.time.numberpad.DigitwiseTimeParser;
import com.philliphsu.bottomsheetpickers.time.numberpad.INumberPadTimePicker;
import com.philliphsu.bottomsheetpickers.time.numberpad.LocaleModel;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePickerPresenter;

final class NumberPadTimePickerDialogPresenter
extends NumberPadTimePickerPresenter
implements INumberPadTimePicker.DialogPresenter {
    private final DigitwiseTimeParser mTimeParser;
    private INumberPadTimePicker.DialogView mView;

    NumberPadTimePickerDialogPresenter(@NonNull INumberPadTimePicker.DialogView view, @NonNull LocaleModel localeModel, boolean is24HourMode) {
        super(view, localeModel, is24HourMode);
        this.mTimeParser = new DigitwiseTimeParser(this.mTimeModel);
        this.mView = view;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.mView = null;
    }

    @Override
    public void onCancelClick() {
        this.mView.cancel();
    }

    @Override
    public void onOkButtonClick() {
        this.mView.setResult(this.mTimeParser.getHour(this.mAmPmState), this.mTimeParser.getMinute(this.mAmPmState));
        this.mView.cancel();
    }

    @Override
    public void onDialogShow() {
        this.mView.showOkButton();
    }

    @Override
    void updateViewEnabledStates() {
        super.updateViewEnabledStates();
        this.updateOkButtonState();
    }

    private void updateOkButtonState() {
        this.mView.setOkButtonEnabled(this.mTimeParser.checkTimeValid(this.mAmPmState));
    }
}

