/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleableRes;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.GridLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.time.numberpad.BottomSheetNumberPadTimePickerThemer;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePicker;

final class NumberPadTimePickerBottomSheetComponent
extends NumberPadTimePicker.NumberPadTimePickerComponent
implements BottomSheetNumberPadTimePickerThemer {
    private static final int[] ATTRS_FAB_COLORS = new int[]{R.attr.colorButtonNormal, R.attr.colorAccent};
    private static final int[][] STATES_FAB_COLORS = new int[][]{{-16842910}, new int[0]};
    private static final int FAB_ANIM_DURATION = 120;
    private final FloatingActionButton mOkButton;
    private ValueAnimator mFabBackgroundColorAnimator;
    private ValueAnimator mFabElevationAnimator;
    private ValueAnimator mFabIconTintAnimator;
    private int mBackspaceLocation;
    private int mShowFabPolicy;
    private boolean mAnimateFabIn;
    private boolean mAnimateFabBackgroundColor;
    private boolean mAnimatingToEnabled;
    private final FloatingActionButton.OnVisibilityChangedListener mFabHideListener = new FloatingActionButton.OnVisibilityChangedListener(){

        public void onHidden(FloatingActionButton fab) {
            fab.setVisibility(4);
        }
    };
    private final Runnable mApplyBackspaceLocationRunnable = new Runnable(){

        @Override
        public void run() {
            switch (NumberPadTimePickerBottomSheetComponent.this.mBackspaceLocation) {
                case 0: {
                    break;
                }
                case 1: {
                    ((ViewGroup)NumberPadTimePickerBottomSheetComponent.this.mHeader).removeView((View)NumberPadTimePickerBottomSheetComponent.this.mBackspace);
                    GridLayout.Spec rowSpec = GridLayout.spec((int)(NumberPadTimePickerBottomSheetComponent.this.mNumberPad.getRowCount() - 1), (GridLayout.Alignment)GridLayout.FILL);
                    GridLayout.Spec columnSpec = GridLayout.spec((int)(NumberPadTimePickerBottomSheetComponent.this.mNumberPad.getColumnCount() - 1), (GridLayout.Alignment)GridLayout.FILL);
                    NumberPadTimePickerBottomSheetComponent.this.mNumberPad.addView((View)NumberPadTimePickerBottomSheetComponent.this.mBackspace, (ViewGroup.LayoutParams)new GridLayout.LayoutParams(rowSpec, columnSpec));
                }
            }
        }
    };

    NumberPadTimePickerBottomSheetComponent(NumberPadTimePicker timePicker, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(timePicker, context, attrs, defStyleAttr, defStyleRes);
        int fabRippleColor;
        this.mOkButton = (FloatingActionButton)timePicker.findViewById(R.id.bsp_ok_button);
        TypedArray timePickerAttrs = context.obtainStyledAttributes(attrs, R.styleable.BSP_NumberPadTimePicker, defStyleAttr, defStyleRes);
        ColorStateList fabBackgroundColor = NumberPadTimePickerBottomSheetComponent.retrieveFabBackgroundColor(timePickerAttrs, context);
        if (fabBackgroundColor != null) {
            boolean animateFabBackgroundColor = timePickerAttrs.getBoolean(R.styleable.BSP_NumberPadTimePicker_bsp_animateFabBackgroundColor, true);
            this.setAnimateFabBackgroundColor(animateFabBackgroundColor, fabBackgroundColor, context);
            this.mOkButton.setBackgroundTintList(fabBackgroundColor);
        }
        if ((fabRippleColor = timePickerAttrs.getColor(R.styleable.BSP_NumberPadTimePicker_bsp_fabRippleColor, 0)) != 0) {
            this.setFabRippleColor(fabRippleColor);
        }
        this.mAnimateFabIn = timePickerAttrs.getBoolean(R.styleable.BSP_NumberPadTimePicker_bsp_animateFabIn, false);
        this.mShowFabPolicy = NumberPadTimePickerBottomSheetComponent.retrieveShowFab(timePickerAttrs);
        this.setInitialFabVisibility(this.mAnimateFabIn, this.mShowFabPolicy);
        this.mBackspaceLocation = NumberPadTimePickerBottomSheetComponent.retrieveBackspaceLocation(timePickerAttrs);
        this.applyBackspaceLocation();
        ColorStateList fabIconTint = timePickerAttrs.getColorStateList(R.styleable.BSP_NumberPadTimePicker_bsp_fabIconTint);
        if (fabIconTint != null) {
            this.setFabIconTint(fabIconTint);
        }
        timePickerAttrs.recycle();
    }

    @Override
    public BottomSheetNumberPadTimePickerThemer setFabBackgroundColor(ColorStateList fabBackgroundColor) {
        if (this.mAnimateFabBackgroundColor) {
            this.mFabBackgroundColorAnimator.setIntValues(NumberPadTimePickerBottomSheetComponent.extractColors(fabBackgroundColor, STATES_FAB_COLORS));
        }
        this.mOkButton.setBackgroundTintList(fabBackgroundColor);
        return this;
    }

    @Override
    public BottomSheetNumberPadTimePickerThemer setFabRippleColor(@ColorInt int color2) {
        this.mOkButton.setRippleColor(color2);
        return this;
    }

    @Override
    public BottomSheetNumberPadTimePickerThemer setFabIconTint(ColorStateList tint) {
        if (tint != null) {
            int[] colors = NumberPadTimePickerBottomSheetComponent.extractColors(tint, STATES_FAB_COLORS);
            if (this.mFabIconTintAnimator != null) {
                this.mFabIconTintAnimator.setIntValues(colors);
            } else {
                this.mFabIconTintAnimator = this.createFabIconTintAnimator(colors);
            }
        }
        DrawableCompat.setTintList((Drawable)this.mOkButton.getDrawable(), (ColorStateList)tint);
        return this;
    }

    @Override
    public BottomSheetNumberPadTimePickerThemer setAnimateFabBackgroundColor(boolean animate) {
        this.setAnimateFabBackgroundColor(animate, this.mOkButton.getBackgroundTintList(), this.mOkButton.getContext());
        return this;
    }

    @Override
    public BottomSheetNumberPadTimePickerThemer setShowFabPolicy(int policy) {
        if (policy != this.mShowFabPolicy) {
            this.setInitialFabVisibility(this.mAnimateFabIn, policy);
            this.mShowFabPolicy = policy;
        }
        return this;
    }

    @Override
    public BottomSheetNumberPadTimePickerThemer setBackspaceLocation(int location) {
        if (location != this.mBackspaceLocation) {
            this.mBackspaceLocation = location;
            this.applyBackspaceLocation();
        }
        return this;
    }

    @Override
    public BottomSheetNumberPadTimePickerThemer setAnimateFabIn(boolean animateIn) {
        if (animateIn != this.mAnimateFabIn) {
            this.setInitialFabVisibility(animateIn, this.mShowFabPolicy);
            this.mAnimateFabIn = animateIn;
        }
        return this;
    }

    @Override
    View inflate(Context context, NumberPadTimePicker root) {
        return View.inflate((Context)context, (int)R.layout.bsp_bottomsheet_numberpad_time_picker, (ViewGroup)root);
    }

    FloatingActionButton getOkButton() {
        return this.mOkButton;
    }

    boolean isAnimateFabIn() {
        return this.mAnimateFabIn;
    }

    int getShowFabPolicy() {
        return this.mShowFabPolicy;
    }

    boolean isAnimateFabBackgroundColor() {
        return this.mAnimateFabBackgroundColor;
    }

    void setOkButtonEnabled(boolean enabled) {
        boolean enabledDiff;
        boolean bl = enabledDiff = this.mOkButton.isEnabled() != enabled;
        if (this.mShowFabPolicy == 1) {
            if (enabled) {
                this.mOkButton.show();
            } else {
                this.mOkButton.hide(this.mFabHideListener);
            }
        } else if (this.mAnimateFabBackgroundColor) {
            if (enabledDiff) {
                if (!this.mFabBackgroundColorAnimator.isStarted() && !this.mFabElevationAnimator.isStarted()) {
                    if (enabled) {
                        this.mFabBackgroundColorAnimator.start();
                        this.mFabElevationAnimator.start();
                    } else {
                        this.mFabBackgroundColorAnimator.reverse();
                        this.mFabElevationAnimator.reverse();
                    }
                    this.mAnimatingToEnabled = enabled;
                } else {
                    this.mFabBackgroundColorAnimator.end();
                    this.mFabElevationAnimator.end();
                    this.mOkButton.setEnabled(enabled);
                }
            }
        } else {
            this.mOkButton.setEnabled(enabled);
        }
        if (this.mShowFabPolicy == 0 && enabledDiff && this.mFabIconTintAnimator != null) {
            if (!this.mFabIconTintAnimator.isStarted()) {
                if (enabled) {
                    this.mFabIconTintAnimator.start();
                } else {
                    this.mFabIconTintAnimator.reverse();
                }
            } else {
                this.mFabIconTintAnimator.end();
            }
        }
    }

    void showOkButton() {
        if (this.mShowFabPolicy == 0 && this.mAnimateFabIn) {
            this.mOkButton.postDelayed(new Runnable(){

                @Override
                public void run() {
                    NumberPadTimePickerBottomSheetComponent.this.mOkButton.show();
                }
            }, 300L);
        }
    }

    private void setInitialFabVisibility(boolean animateFabIn, int showFabPolicy) {
        this.mOkButton.setVisibility(animateFabIn || showFabPolicy == 1 ? 4 : 0);
    }

    private void setAnimateFabBackgroundColor(boolean animate, ColorStateList fabBackgroundColor, Context context) {
        if (animate != this.mAnimateFabBackgroundColor) {
            if (animate) {
                if (this.mFabBackgroundColorAnimator == null) {
                    this.mFabBackgroundColorAnimator = this.createFabBackgroundColorAnimator(NumberPadTimePickerBottomSheetComponent.extractColors(fabBackgroundColor, STATES_FAB_COLORS));
                }
                if (this.mFabElevationAnimator == null) {
                    this.mFabElevationAnimator = this.createFabElevationAnimator(context);
                }
            } else {
                this.mFabBackgroundColorAnimator = null;
                this.mFabElevationAnimator = null;
            }
            this.mAnimateFabBackgroundColor = animate;
        }
    }

    private void applyBackspaceLocation() {
        this.mNumberPad.removeCallbacks(this.mApplyBackspaceLocationRunnable);
        this.mNumberPad.post(this.mApplyBackspaceLocationRunnable);
    }

    @NonNull
    private ValueAnimator createFabBackgroundColorAnimator(int[] colors) {
        ValueAnimator fabBackgroundColorAnimator = NumberPadTimePickerBottomSheetComponent.newArgbValueAnimator(colors);
        fabBackgroundColorAnimator.setDuration(120L);
        fabBackgroundColorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                NumberPadTimePickerBottomSheetComponent.this.mOkButton.setBackgroundTintList(ColorStateList.valueOf((int)((Integer)animation.getAnimatedValue())));
            }
        });
        fabBackgroundColorAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                NumberPadTimePickerBottomSheetComponent.this.mOkButton.setEnabled(NumberPadTimePickerBottomSheetComponent.this.mAnimatingToEnabled);
            }
        });
        return fabBackgroundColorAnimator;
    }

    @NonNull
    private ValueAnimator createFabIconTintAnimator(int[] colors) {
        ValueAnimator anim2 = NumberPadTimePickerBottomSheetComponent.newArgbValueAnimator(colors);
        anim2.setDuration(120L);
        anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                DrawableCompat.setTintList((Drawable)NumberPadTimePickerBottomSheetComponent.this.mOkButton.getDrawable(), (ColorStateList)ColorStateList.valueOf((int)((Integer)animation.getAnimatedValue())));
            }
        });
        return anim2;
    }

    @NonNull
    private ValueAnimator createFabElevationAnimator(Context context) {
        float elevation = context.getResources().getDimension(R.dimen.bsp_bottom_sheet_grid_picker_fab_elevation);
        String elevationProperty = Build.VERSION.SDK_INT >= 21 ? "elevation" : "compatElevation";
        return ObjectAnimator.ofFloat((Object)this.mOkButton, (String)elevationProperty, (float[])new float[]{elevation}).setDuration(120L);
    }

    @Nullable
    private static ColorStateList retrieveFabBackgroundColor(TypedArray timePickerAttrs, Context context) {
        int[] colors;
        ColorStateList fabBackgroundColor = timePickerAttrs.getColorStateList(R.styleable.BSP_NumberPadTimePicker_bsp_fabBackgroundColor);
        if (fabBackgroundColor == null && NumberPadTimePickerBottomSheetComponent.isAllNonzero(colors = NumberPadTimePickerBottomSheetComponent.resolveColorAttributesFromTheme(context, ATTRS_FAB_COLORS))) {
            fabBackgroundColor = new ColorStateList(STATES_FAB_COLORS, colors);
        }
        return fabBackgroundColor;
    }

    @NonNull
    private static int[] resolveColorAttributesFromTheme(Context context, @StyleableRes int[] attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs);
        int[] colors = new int[attrs.length];
        for (int idxAttr = 0; idxAttr < colors.length; ++idxAttr) {
            colors[idxAttr] = ta.getColor(idxAttr, 0);
        }
        ta.recycle();
        return colors;
    }

    private static int retrieveShowFab(TypedArray timePickerAttrs) {
        int policy = timePickerAttrs.getInt(R.styleable.BSP_NumberPadTimePicker_bsp_showFab, 0);
        switch (policy) {
            case 0: 
            case 1: {
                return policy;
            }
        }
        return 0;
    }

    private static int retrieveBackspaceLocation(TypedArray timePickerAttrs) {
        int location = timePickerAttrs.getInt(R.styleable.BSP_NumberPadTimePicker_bsp_backspaceLocation, 0);
        switch (location) {
            case 0: 
            case 1: {
                return location;
            }
        }
        return 0;
    }

    private static boolean isAllNonzero(int[] a) {
        for (int elem : a) {
            if (elem != 0) continue;
            return false;
        }
        return true;
    }

    @NonNull
    private static int[] extractColors(ColorStateList colorStateList, int[][] states) {
        int[] colors = new int[states.length];
        int idx = 0;
        for (int[] stateSet : states) {
            colors[idx++] = stateSet.length == 0 ? colorStateList.getDefaultColor() : colorStateList.getColorForState(stateSet, 0);
        }
        return colors;
    }

    @NonNull
    private static ValueAnimator newArgbValueAnimator(int[] colors) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])colors);
        animator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        return animator;
    }
}

