/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.time.numberpad.INumberPadTimePicker;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePickerAlertComponent;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePickerBottomSheetComponent;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePickerThemer;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadView;

class NumberPadTimePicker
extends LinearLayout
implements INumberPadTimePicker.View {
    static final int LAYOUT_ALERT = 1;
    static final int LAYOUT_BOTTOM_SHEET = 2;
    private NumberPadTimePickerComponent mTimePickerComponent;
    private LinearLayout mInputTimeContainer;
    private int mLayout;

    public NumberPadTimePicker(Context context) {
        this(context, null);
    }

    public NumberPadTimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.bsp_numberPadTimePickerStyle);
    }

    public NumberPadTimePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public NumberPadTimePicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.setOrientation(1);
        TypedArray timePickerAttrs = context.obtainStyledAttributes(attrs, R.styleable.BSP_NumberPadTimePicker, defStyleAttr, defStyleRes);
        this.mLayout = NumberPadTimePicker.retrieveLayout(timePickerAttrs);
        timePickerAttrs.recycle();
        switch (this.mLayout) {
            case 2: {
                this.mTimePickerComponent = new NumberPadTimePickerBottomSheetComponent(this, context, attrs, defStyleAttr, defStyleRes);
                break;
            }
            default: {
                this.mTimePickerComponent = new NumberPadTimePickerAlertComponent(this, context, attrs, defStyleAttr, defStyleRes);
            }
        }
        this.mInputTimeContainer = (LinearLayout)this.findViewById(R.id.bsp_input_time_container);
    }

    @Override
    public void setNumberKeysEnabled(int start, int end) {
        this.mTimePickerComponent.mNumberPad.setNumberKeysEnabled(start, end);
    }

    @Override
    public void setBackspaceEnabled(boolean enabled) {
        this.mTimePickerComponent.mBackspace.setEnabled(enabled);
    }

    @Override
    public void updateTimeDisplay(CharSequence time) {
        this.mTimePickerComponent.mTimeDisplay.setText(time);
    }

    @Override
    public void updateAmPmDisplay(CharSequence ampm) {
        this.mTimePickerComponent.mAmPmDisplay.setText(ampm);
    }

    @Override
    public void setAmPmDisplayVisible(boolean visible) {
        this.mTimePickerComponent.mAmPmDisplay.setVisibility(visible ? 0 : 8);
    }

    @Override
    public void setAmPmDisplayIndex(int index) {
        if (index != 0 && index != 1) {
            throw new IllegalArgumentException("Index of AM/PM display must be 0 or 1. index == " + index);
        }
        if (index == 1) {
            return;
        }
        this.mInputTimeContainer.removeViewAt(1);
        this.mInputTimeContainer.addView((View)this.mTimePickerComponent.mAmPmDisplay, 0);
    }

    @Override
    public void setLeftAltKeyText(CharSequence text) {
        this.mTimePickerComponent.mNumberPad.setLeftAltKeyText(text);
    }

    @Override
    public void setRightAltKeyText(CharSequence text) {
        this.mTimePickerComponent.mNumberPad.setRightAltKeyText(text);
    }

    @Override
    public void setLeftAltKeyEnabled(boolean enabled) {
        this.mTimePickerComponent.mNumberPad.setLeftAltKeyEnabled(enabled);
    }

    @Override
    public void setRightAltKeyEnabled(boolean enabled) {
        this.mTimePickerComponent.mNumberPad.setRightAltKeyEnabled(enabled);
    }

    @Override
    @Deprecated
    public void setHeaderDisplayFocused(boolean focused) {
    }

    int getLayout() {
        return this.mLayout;
    }

    void setOnBackspaceClickListener(View.OnClickListener l) {
        this.mTimePickerComponent.mBackspace.setOnClickListener(l);
    }

    void setOnBackspaceLongClickListener(View.OnLongClickListener l) {
        this.mTimePickerComponent.mBackspace.setOnLongClickListener(l);
    }

    void setOnNumberKeyClickListener(View.OnClickListener l) {
        this.mTimePickerComponent.mNumberPad.setOnNumberKeyClickListener(l);
    }

    void setOnAltKeyClickListener(View.OnClickListener l) {
        this.mTimePickerComponent.mNumberPad.setOnAltKeyClickListener(l);
    }

    NumberPadTimePickerComponent getComponent() {
        return this.mTimePickerComponent;
    }

    private static int retrieveLayout(TypedArray timePickerAttrs) {
        int layout2 = timePickerAttrs.getInt(R.styleable.BSP_NumberPadTimePicker_bsp_numberPadTimePickerLayout, 1);
        switch (layout2) {
            case 1: 
            case 2: {
                return layout2;
            }
        }
        return 1;
    }

    static abstract class NumberPadTimePickerComponent
    implements NumberPadTimePickerThemer {
        final NumberPadView mNumberPad;
        final TextView mTimeDisplay;
        final TextView mAmPmDisplay;
        final ImageButton mBackspace;
        final ImageView mDivider;
        final View mHeader;

        NumberPadTimePickerComponent(NumberPadTimePicker timePicker, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            View root = this.inflate(context, timePicker);
            this.mNumberPad = (NumberPadView)root.findViewById(R.id.bsp_numberpad_time_picker_view);
            this.mTimeDisplay = (TextView)root.findViewById(R.id.bsp_input_time);
            this.mAmPmDisplay = (TextView)root.findViewById(R.id.bsp_input_ampm);
            this.mBackspace = (ImageButton)root.findViewById(R.id.bsp_backspace);
            this.mDivider = (ImageView)root.findViewById(R.id.bsp_divider);
            this.mHeader = root.findViewById(R.id.bsp_header);
            TypedArray timePickerAttrs = context.obtainStyledAttributes(attrs, R.styleable.BSP_NumberPadTimePicker, defStyleAttr, defStyleRes);
            int inputTimeTextColor = timePickerAttrs.getColor(R.styleable.BSP_NumberPadTimePicker_bsp_inputTimeTextColor, 0);
            int inputAmPmTextColor = timePickerAttrs.getColor(R.styleable.BSP_NumberPadTimePicker_bsp_inputAmPmTextColor, 0);
            ColorStateList backspaceTint = timePickerAttrs.getColorStateList(R.styleable.BSP_NumberPadTimePicker_bsp_backspaceTint);
            ColorStateList numberKeysTextColor = timePickerAttrs.getColorStateList(R.styleable.BSP_NumberPadTimePicker_bsp_numberKeysTextColor);
            ColorStateList altKeysTextColor = timePickerAttrs.getColorStateList(R.styleable.BSP_NumberPadTimePicker_bsp_altKeysTextColor);
            Drawable headerBackground = timePickerAttrs.getDrawable(R.styleable.BSP_NumberPadTimePicker_bsp_headerBackground);
            Drawable divider = timePickerAttrs.getDrawable(R.styleable.BSP_NumberPadTimePicker_bsp_divider);
            Drawable numberPadBackground = timePickerAttrs.getDrawable(R.styleable.BSP_NumberPadTimePicker_bsp_numberPadBackground);
            timePickerAttrs.recycle();
            if (inputTimeTextColor != 0) {
                this.setInputTimeTextColor(inputTimeTextColor);
            }
            if (inputAmPmTextColor != 0) {
                this.setInputAmPmTextColor(inputAmPmTextColor);
            }
            if (backspaceTint != null) {
                this.setBackspaceTint(backspaceTint);
            }
            if (numberKeysTextColor != null) {
                this.setNumberKeysTextColor(numberKeysTextColor);
            }
            if (altKeysTextColor != null) {
                this.setAltKeysTextColor(altKeysTextColor);
            }
            if (headerBackground != null) {
                this.setHeaderBackground(headerBackground);
            }
            if (divider != null) {
                this.setDivider(divider);
            }
            if (numberPadBackground != null) {
                this.setNumberPadBackground(numberPadBackground);
            }
        }

        @Override
        public final NumberPadTimePickerThemer setInputTimeTextColor(@ColorInt int color2) {
            this.mTimeDisplay.setTextColor(color2);
            return this;
        }

        @Override
        public final NumberPadTimePickerThemer setInputAmPmTextColor(@ColorInt int color2) {
            this.mAmPmDisplay.setTextColor(color2);
            return this;
        }

        @Override
        public final NumberPadTimePickerThemer setBackspaceTint(ColorStateList colors) {
            DrawableCompat.setTintList((Drawable)this.mBackspace.getDrawable(), (ColorStateList)colors);
            return this;
        }

        @Override
        public final NumberPadTimePickerThemer setNumberKeysTextColor(ColorStateList colors) {
            this.mNumberPad.setNumberKeysTextColor(colors);
            return this;
        }

        @Override
        public final NumberPadTimePickerThemer setAltKeysTextColor(ColorStateList colors) {
            this.mNumberPad.setAltKeysTextColor(colors);
            return this;
        }

        @Override
        public final NumberPadTimePickerThemer setHeaderBackground(Drawable background) {
            NumberPadTimePickerComponent.setBackground(this.mHeader, background);
            return this;
        }

        @Override
        public final NumberPadTimePickerThemer setNumberPadBackground(Drawable background) {
            NumberPadTimePickerComponent.setBackground((View)this.mNumberPad, background);
            return this;
        }

        @Override
        public final NumberPadTimePickerThemer setDivider(Drawable divider) {
            this.mDivider.setImageDrawable(divider);
            if (Build.VERSION.SDK_INT >= 21) {
                this.mDivider.setImageTintList(null);
            }
            return this;
        }

        abstract View inflate(Context var1, NumberPadTimePicker var2);

        private static void setBackground(View view, Drawable background) {
            if (Build.VERSION.SDK_INT < 16) {
                view.setBackgroundDrawable(background);
            } else {
                view.setBackground(background);
            }
        }
    }
}

