/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.support.annotation.Nullable;
import java.util.Arrays;

final class DigitwiseTimeModel {
    private static final int UNMODIFIED = -1;
    static final int MAX_DIGITS = 4;
    private final int[] mDigits = new int[4];
    @Nullable
    private final OnInputChangeListener mListener;
    private int mCount;

    DigitwiseTimeModel(OnInputChangeListener listener) {
        this.mListener = listener;
        Arrays.fill(this.mDigits, -1);
        this.mCount = 0;
    }

    void storeDigit(int digit) {
        if (this.mCount < 4) {
            this.mDigits[this.mCount] = digit;
            ++this.mCount;
            if (this.mListener != null) {
                this.mListener.onDigitStored(digit);
            }
        }
    }

    int getDigit(int at) {
        return this.mDigits[at];
    }

    int[] getDigits() {
        return Arrays.copyOf(this.mDigits, this.mDigits.length);
    }

    void removeDigit() {
        if (this.mCount > 0) {
            --this.mCount;
            int digit = this.mDigits[this.mCount];
            this.mDigits[this.mCount] = -1;
            if (this.mListener != null) {
                this.mListener.onDigitRemoved(digit);
            }
        }
    }

    boolean clearDigits() {
        Arrays.fill(this.mDigits, -1);
        this.mCount = 0;
        if (this.mListener != null) {
            this.mListener.onDigitsCleared();
        }
        return true;
    }

    int count() {
        return this.mCount;
    }

    int getDigitsAsInteger() {
        if (this.mCount <= 0) {
            return -1;
        }
        int result = 0;
        for (int i = 0; i < this.mCount; ++i) {
            result = result * 10 + this.mDigits[i];
        }
        return result;
    }

    void storeDigits(int ... digits) {
        if (digits == null) {
            return;
        }
        for (int d : digits) {
            if (d == -1) continue;
            if (d < 0 || d > 9) {
                throw new IllegalArgumentException("Not a digit " + d);
            }
            if (this.mCount == 4) break;
            this.storeDigit(d);
        }
    }

    static interface OnInputChangeListener {
        public void onDigitStored(int var1);

        public void onDigitRemoved(int var1);

        public void onDigitsCleared();
    }
}

