/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import java.util.Locale;

final class DateTimeFormatUtils {
    static String getTimeSeparator(@NonNull Context context, boolean is24Hour) {
        if (Build.VERSION.SDK_INT >= 18) {
            String bestDateTimePattern = DateFormat.getBestDateTimePattern((Locale)DateTimeFormatUtils.getPrimaryLocale(context), (String)(is24Hour ? "Hm" : "hm"));
            char[] hourFormats = new char[]{'H', 'h', 'K', 'k'};
            int hIndex = DateTimeFormatUtils.lastIndexOfAny(bestDateTimePattern, hourFormats);
            String separatorText = hIndex == -1 ? ":" : Character.toString(bestDateTimePattern.charAt(hIndex + 1));
            return separatorText;
        }
        String formatted24HourTime = DateUtils.formatDateTime((Context)context, (long)System.currentTimeMillis(), (int)129);
        for (int i = 0; i < formatted24HourTime.length(); ++i) {
            char c = formatted24HourTime.charAt(i);
            if (Character.isDigit(c)) continue;
            return Character.toString(c);
        }
        return "";
    }

    static boolean isAmPmWrittenBeforeTime(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 18) {
            String dateTimePattern = DateFormat.getBestDateTimePattern((Locale)DateTimeFormatUtils.getPrimaryLocale(context), (String)"hm");
            return dateTimePattern.startsWith("a");
        }
        String formatted12HourTime = DateUtils.formatDateTime((Context)context, (long)System.currentTimeMillis(), (int)65);
        return !Character.isDigit(formatted12HourTime.charAt(0));
    }

    private static Locale getPrimaryLocale(@NonNull Context context) {
        Configuration config = context.getResources().getConfiguration();
        if (Build.VERSION.SDK_INT >= 24) {
            return config.getLocales().get(0);
        }
        return config.locale;
    }

    private static int lastIndexOfAny(String str, char[] any) {
        int lengthAny = any.length;
        if (lengthAny > 0) {
            for (int i = str.length() - 1; i >= 0; --i) {
                char c = str.charAt(i);
                for (int j = 0; j < lengthAny; ++j) {
                    if (c != any[j]) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private DateTimeFormatUtils() {
    }
}

