/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.date.CalendarDay;
import com.philliphsu.bottomsheetpickers.date.DatePickerController;
import com.philliphsu.bottomsheetpickers.date.MonthView;
import com.philliphsu.bottomsheetpickers.date.SimpleMonthView;
import java.util.ArrayList;
import java.util.HashMap;

class PagingMonthAdapter
extends PagerAdapter
implements MonthView.OnDayClickListener {
    private static final String TAG = "SimpleMonthAdapter";
    private static final String KEY_POSITIONS = "positions";
    private static final String KEY_MONTH_YEAR_TITLES = "month_year_titles";
    private final Context mContext;
    private final boolean mThemeDark;
    private final int mAccentColor;
    private final SparseArray<String> mMonthYearTitles = new SparseArray();
    private final ArrayList<MonthView> mMonthViews = new ArrayList();
    protected final DatePickerController mController;
    private CalendarDay mSelectedDay;
    private MonthView mCurrentPrimaryItem;
    protected static int WEEK_7_OVERHANG_HEIGHT = 7;
    protected static final int MONTHS_IN_YEAR = 12;

    public PagingMonthAdapter(Context context, DatePickerController controller) {
        this(context, controller, false);
    }

    public PagingMonthAdapter(Context context, DatePickerController controller, boolean themeDark) {
        this(context, controller, themeDark, Utils.getThemeAccentColor(context));
    }

    public PagingMonthAdapter(Context context, DatePickerController controller, boolean themeDark, int accentColor) {
        this.mContext = context;
        this.mController = controller;
        this.mThemeDark = themeDark;
        this.mAccentColor = accentColor;
        this.init();
        this.setSelectedDay(this.mController.getSelectedDay());
    }

    public void setSelectedDay(CalendarDay day) {
        this.mSelectedDay = day;
        this.notifyDataSetChanged();
        for (MonthView mv : this.mMonthViews) {
            mv.setSelectedDay(mv == this.mCurrentPrimaryItem ? day.day : -1);
            mv.invalidate();
        }
    }

    public CalendarDay getSelectedDay() {
        return this.mSelectedDay;
    }

    protected void init() {
        this.mSelectedDay = new CalendarDay(System.currentTimeMillis());
    }

    public int getCount() {
        return (this.mController.getMaxYear() - this.mController.getMinYear() + 1) * 12;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        HashMap<String, Integer> drawingParams = null;
        MonthView v = this.createMonthView(this.mContext, this.mThemeDark, this.mAccentColor);
        v.setClickable(true);
        v.setOnDayClickListener(this);
        if (drawingParams == null) {
            drawingParams = new HashMap<String, Integer>();
        }
        drawingParams.clear();
        int month = this.getMonth(position);
        int year = this.getYear(position);
        int selectedDay = -1;
        if (this.isSelectedDayInMonth(year, month)) {
            selectedDay = this.mSelectedDay.day;
        }
        v.reuse();
        drawingParams.put("selected_day", selectedDay);
        drawingParams.put("year", year);
        drawingParams.put("month", month);
        drawingParams.put("week_start", this.mController.getFirstDayOfWeek());
        v.setMonthParams(drawingParams);
        v.invalidate();
        container.addView((View)v, new ViewGroup.LayoutParams(-1, -1));
        this.mMonthYearTitles.append(position, (Object)v.getMonthAndYearString());
        this.mMonthViews.add(v);
        return v;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
        this.mMonthYearTitles.delete(position);
        this.mMonthViews.remove(object);
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        this.mCurrentPrimaryItem = (MonthView)((Object)object);
    }

    public CharSequence getPageTitle(int position) {
        return (CharSequence)this.mMonthYearTitles.get(position);
    }

    public Parcelable saveState() {
        Bundle state = null;
        int size = this.mMonthYearTitles.size();
        if (size > 0) {
            state = new Bundle();
            String[] titles = new String[size];
            int[] positions = new int[size];
            for (int i = 0; i < size; ++i) {
                titles[i] = (String)this.mMonthYearTitles.valueAt(i);
                positions[i] = this.mMonthYearTitles.keyAt(i);
            }
            state.putStringArray(KEY_MONTH_YEAR_TITLES, titles);
            state.putIntArray(KEY_POSITIONS, positions);
        }
        return state;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        if (state != null) {
            Bundle bundle = (Bundle)state;
            bundle.setClassLoader(loader);
            String[] titles = bundle.getStringArray(KEY_MONTH_YEAR_TITLES);
            int[] positions = bundle.getIntArray(KEY_POSITIONS);
            this.mMonthYearTitles.clear();
            if (titles != null && positions != null) {
                for (int i = 0; i < titles.length; ++i) {
                    this.mMonthYearTitles.append(positions[i], (Object)titles[i]);
                }
            }
        }
    }

    public MonthView createMonthView(Context context) {
        return this.createMonthView(context, false);
    }

    public MonthView createMonthView(Context context, boolean themeDark) {
        return this.createMonthView(context, themeDark, this.mAccentColor);
    }

    public MonthView createMonthView(Context context, boolean themeDark, int accentColor) {
        SimpleMonthView monthView = new SimpleMonthView(context);
        monthView.setDatePickerController(this.mController);
        monthView.setTheme(context, themeDark);
        monthView.setTodayNumberColor(accentColor);
        monthView.setSelectedCirclePaintColor(accentColor);
        return monthView;
    }

    private boolean isSelectedDayInMonth(int year, int month) {
        return this.mSelectedDay.year == year && this.mSelectedDay.month == month;
    }

    @Override
    public void onDayClick(MonthView view, CalendarDay day) {
        if (day != null) {
            this.onDayTapped(day);
        }
    }

    protected void onDayTapped(CalendarDay day) {
        this.mController.tryVibrate();
        this.mController.onDayOfMonthSelected(day.year, day.month, day.day);
        this.setSelectedDay(day);
    }

    final int getMonth(int position) {
        return position % 12;
    }

    final int getYear(int position) {
        return position / 12 + this.mController.getMinYear();
    }

    final int getPosition(CalendarDay day) {
        int positionOfYear = 12 * (day.year - this.mController.getMinYear());
        return positionOfYear + day.month;
    }
}

