/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import android.text.format.Time;
import java.util.Calendar;
import java.util.Date;

final class CalendarDay {
    private Calendar calendar;
    private Time time;
    int year;
    int month;
    int day;

    CalendarDay() {
        this.setTime(System.currentTimeMillis());
    }

    CalendarDay(long timeInMillis) {
        this.setTime(timeInMillis);
    }

    CalendarDay(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.day = calendar.get(5);
    }

    CalendarDay(int year, int month, int day) {
        this.setDay(year, month, day);
    }

    void set(CalendarDay date) {
        this.year = date.year;
        this.month = date.month;
        this.day = date.day;
    }

    void setDay(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    Date getDate() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.set(1, this.year);
        this.calendar.set(2, this.month);
        this.calendar.set(5, this.day);
        return this.calendar.getTime();
    }

    synchronized void setJulianDay(int julianDay) {
        if (this.time == null) {
            this.time = new Time();
        }
        this.time.setJulianDay(julianDay);
        this.setTime(this.time.toMillis(false));
    }

    private void setTime(long timeInMillis) {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTimeInMillis(timeInMillis);
        this.month = this.calendar.get(2);
        this.year = this.calendar.get(1);
        this.day = this.calendar.get(5);
    }
}

