/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.ViewUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

public class TimePickerPadLayout
extends ViewGroup {
    private int mRowCount;
    private int mColumnCount;

    public TimePickerPadLayout(Context context) {
        this(context, null);
    }

    public TimePickerPadLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TimePickerPadLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, new int[]{16843637, 16843639}, defStyle, 0);
        this.mRowCount = a.getInt(0, 1);
        this.mColumnCount = a.getInt(1, 1);
        a.recycle();
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        boolean isRTL = ViewUtils.isLayoutRtl((View)this);
        int columnWidth = Math.round(right - left - paddingLeft - paddingRight) / this.mColumnCount;
        int rowHeight = Math.round(bottom - top - paddingTop - paddingBottom) / this.mRowCount;
        int rowIndex = 0;
        int columnIndex = 0;
        for (int childIndex = 0; childIndex < this.getChildCount(); ++childIndex) {
            View childView = this.getChildAt(childIndex);
            if (childView.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)childView.getLayoutParams();
            int childTop = paddingTop + lp.topMargin + rowIndex * rowHeight;
            int childBottom = childTop - lp.topMargin - lp.bottomMargin + rowHeight;
            int childLeft = paddingLeft + lp.leftMargin + (isRTL ? this.mColumnCount - 1 - columnIndex : columnIndex) * columnWidth;
            int childRight = childLeft - lp.leftMargin - lp.rightMargin + columnWidth;
            int childWidth = childRight - childLeft;
            int childHeight = childBottom - childTop;
            if (childWidth != childView.getMeasuredWidth() || childHeight != childView.getMeasuredHeight()) {
                childView.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000));
            }
            childView.layout(childLeft, childTop, childRight, childBottom);
            rowIndex = (rowIndex + (columnIndex + 1) / this.mColumnCount) % this.mRowCount;
            columnIndex = (columnIndex + 1) % this.mColumnCount;
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams;
    }
}

