/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.StringRes;
import android.support.design.widget.FloatingActionButton;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.time.BottomSheetTimePickerDialog;
import com.philliphsu.bottomsheetpickers.time.TimeTextUtils;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePicker;

public class NumberPadTimePickerDialog
extends BottomSheetTimePickerDialog
implements NumberPadTimePicker.OnInputChangeListener {
    private static final String TAG = "NumberPadTimePickerDialog";
    private static final String KEY_IS_24_HOUR_VIEW = "is_24_hour_view";
    private static final String KEY_DIGITS_INPUTTED = "digits_inputted";
    private static final String KEY_AMPM_STATE = "ampm_state";
    private static final String KEY_IS_24_HOUR_MODE_SET_AT_RUNTIME = "is_24_hour_mode_set_at_runtime";
    private static final String KEY_HEADER_TEXT_COLOR = "header_text_color";
    private boolean mIs24HourMode;
    private boolean mIs24HourModeSetAtRuntime;
    private int[] mInputtedDigits;
    private int mAmPmState = -1;
    private String mHint;
    private int mTextSize;
    private int mHintResId;
    private int mHeaderTextColor;
    private TextView mInputField;
    private NumberPadTimePicker mNumpad;

    public static NumberPadTimePickerDialog newInstance(BottomSheetTimePickerDialog.OnTimeSetListener callback) {
        NumberPadTimePickerDialog ret = new NumberPadTimePickerDialog();
        ret.initialize(callback, false, false);
        return ret;
    }

    public static NumberPadTimePickerDialog newInstance(BottomSheetTimePickerDialog.OnTimeSetListener callback, boolean is24HourMode) {
        NumberPadTimePickerDialog ret = new NumberPadTimePickerDialog();
        ret.initialize(callback, true, is24HourMode);
        return ret;
    }

    private void initialize(BottomSheetTimePickerDialog.OnTimeSetListener callback, boolean set24HourModeAtRuntime, boolean is24HourMode) {
        this.setOnTimeSetListener(callback);
        this.mThemeDark = false;
        this.mThemeSetAtRuntime = false;
        this.mIs24HourModeSetAtRuntime = set24HourModeAtRuntime;
        if (set24HourModeAtRuntime) {
            this.mIs24HourMode = is24HourMode;
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mInputtedDigits = savedInstanceState.getIntArray(KEY_DIGITS_INPUTTED);
            this.mIs24HourMode = savedInstanceState.getBoolean(KEY_IS_24_HOUR_VIEW);
            this.mAmPmState = savedInstanceState.getInt(KEY_AMPM_STATE);
            this.mIs24HourModeSetAtRuntime = savedInstanceState.getBoolean(KEY_IS_24_HOUR_MODE_SET_AT_RUNTIME);
            this.mHeaderTextColor = savedInstanceState.getInt(KEY_HEADER_TEXT_COLOR);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        this.mInputField = (TextView)view.findViewById(R.id.bsp_input_time);
        this.mNumpad = (NumberPadTimePicker)view.findViewById(R.id.bsp_number_grid);
        FloatingActionButton fab = (FloatingActionButton)this.mNumpad.findViewById(R.id.bsp_fab);
        fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!NumberPadTimePickerDialog.this.mNumpad.checkTimeValid()) {
                    return;
                }
                NumberPadTimePickerDialog.this.onTimeSet((ViewGroup)NumberPadTimePickerDialog.this.mNumpad, NumberPadTimePickerDialog.this.mNumpad.getHour(), NumberPadTimePickerDialog.this.mNumpad.getMinute());
            }
        });
        if (this.mIs24HourModeSetAtRuntime) {
            this.mNumpad.setIs24HourMode(this.mIs24HourMode);
        }
        this.mNumpad.setOnInputChangeListener(this);
        this.mNumpad.insertDigits(this.mInputtedDigits);
        this.mNumpad.setAmPmState(this.mAmPmState);
        view.findViewById(R.id.bsp_input_time_container).setBackgroundColor(this.mHeaderColor);
        if (this.mHint != null || this.mHintResId != 0) {
            if (this.mHint != null) {
                this.mInputField.setHint((CharSequence)this.mHint);
            } else {
                this.mInputField.setHint(this.mHintResId);
            }
        }
        if (this.mTextSize != 0) {
            this.mInputField.setTextSize(0, (float)this.mTextSize);
        }
        this.mInputField.setTextColor(this.mHeaderTextColor != 0 ? this.mHeaderTextColor : this.getDefaultHeaderTextColor());
        this.mNumpad.setAccentColor(this.mAccentColor);
        this.mNumpad.setTheme(this.getContext(), this.mThemeDark);
        return view;
    }

    @Override
    protected int contentLayout() {
        return R.layout.bsp_dialog_time_picker_numpad;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mNumpad != null) {
            outState.putIntArray(KEY_DIGITS_INPUTTED, this.mNumpad.getDigits());
            outState.putBoolean(KEY_IS_24_HOUR_VIEW, this.mIs24HourMode);
            outState.putInt(KEY_AMPM_STATE, this.mNumpad.getAmPmState());
            outState.putBoolean(KEY_IS_24_HOUR_MODE_SET_AT_RUNTIME, this.mIs24HourModeSetAtRuntime);
            outState.putInt(KEY_HEADER_TEXT_COLOR, this.mHeaderTextColor);
        }
    }

    public void setHint(String hint) {
        if (this.mInputField != null) {
            this.mInputField.setHint((CharSequence)this.mHint);
        }
        this.mHint = hint;
        this.mHintResId = 0;
    }

    public void setHint(@StringRes int resid) {
        if (this.mInputField != null) {
            this.mInputField.setHint(resid);
        }
        this.mHintResId = resid;
        this.mHint = null;
    }

    public void setInputTextSize(int textSize) {
        if (this.mInputField != null) {
            this.mInputField.setTextSize(0, (float)textSize);
        }
        this.mTextSize = textSize;
    }

    public TextView getInputTextView() {
        return this.mInputField;
    }

    public final void setHeaderTextColor(@ColorInt int color2) {
        this.mHeaderTextColor = color2;
    }

    @Override
    public void onDigitInserted(String newStr) {
        this.updateInputText(newStr);
    }

    @Override
    public void onDigitDeleted(String newStr) {
        this.updateInputText(newStr);
    }

    @Override
    public void onDigitsCleared() {
        this.updateInputText("");
    }

    @Override
    public void onInputDisabled() {
    }

    private void updateInputText(String inputText) {
        TimeTextUtils.setText(inputText, this.mInputField);
    }

    @ColorInt
    private int getDefaultHeaderTextColor() {
        return this.getDefaultHeaderTextColorSelected();
    }

    public static final class Builder
    extends BottomSheetTimePickerDialog.Builder {
        private final boolean mSet24HourMode;
        private int mHeaderTextColor;

        public Builder(BottomSheetTimePickerDialog.OnTimeSetListener listener) {
            super(listener);
            this.mSet24HourMode = false;
        }

        public Builder(BottomSheetTimePickerDialog.OnTimeSetListener listener, boolean is24HourMode) {
            super(listener, is24HourMode);
            this.mSet24HourMode = true;
        }

        public Builder setHeaderTextColor(@ColorInt int color2) {
            this.mHeaderTextColor = color2;
            return this;
        }

        @Override
        public Builder setAccentColor(int accentColor) {
            return (Builder)super.setAccentColor(accentColor);
        }

        @Override
        public Builder setBackgroundColor(int backgroundColor) {
            return (Builder)super.setBackgroundColor(backgroundColor);
        }

        @Override
        public Builder setHeaderColor(int headerColor) {
            return (Builder)super.setHeaderColor(headerColor);
        }

        @Override
        public Builder setHeaderTextDark(boolean headerTextDark) {
            return (Builder)super.setHeaderTextDark(headerTextDark);
        }

        @Override
        public Builder setThemeDark(boolean themeDark) {
            return (Builder)super.setThemeDark(themeDark);
        }

        @Override
        public NumberPadTimePickerDialog build() {
            NumberPadTimePickerDialog dialog = this.mSet24HourMode ? NumberPadTimePickerDialog.newInstance(this.mListener, this.mIs24HourMode) : NumberPadTimePickerDialog.newInstance(this.mListener);
            this.super_build(dialog);
            dialog.setHeaderTextColor(this.mHeaderTextColor);
            return dialog;
        }
    }
}

