/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.content.Context;
import android.content.res.ColorStateList;
import android.support.annotation.CallSuper;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import java.util.Arrays;

abstract class GridLayoutNumberPad
extends GridLayout
implements View.OnClickListener {
    protected static final int UNMODIFIED = -1;
    private static final int COLUMNS = 3;
    private int[] mInput;
    private int mCount = 0;
    private OnInputChangeListener mOnInputChangeListener;
    private ColorStateList mTextColors;
    int mAccentColor;
    private boolean mAccentColorSetAtRuntime;
    private final TextView[] mButtons = new TextView[10];

    public GridLayoutNumberPad(Context context) {
        this(context, null);
    }

    public GridLayoutNumberPad(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    void setTheme(Context context, boolean themeDark) {
        this.mTextColors = ContextCompat.getColorStateList((Context)context, (int)(themeDark ? R.color.numeric_keypad_button_text_dark : R.color.numeric_keypad_button_text));
        if (!this.mAccentColorSetAtRuntime) {
            this.mAccentColor = Utils.getThemeAccentColor(context);
        }
        for (TextView b : this.mButtons) {
            this.setTextColor(b);
            Utils.setColorControlHighlight((View)b, this.mAccentColor);
        }
    }

    void setAccentColor(@ColorInt int color2) {
        this.mAccentColor = color2;
        this.mAccentColorSetAtRuntime = true;
    }

    void setTextColor(TextView view) {
        view.setTextColor(this.mTextColors);
    }

    public abstract int capacity();

    @LayoutRes
    protected abstract int contentLayout();

    public final void setOnInputChangeListener(OnInputChangeListener onInputChangeListener) {
        this.mOnInputChangeListener = onInputChangeListener;
    }

    protected final OnInputChangeListener getOnInputChangeListener() {
        return this.mOnInputChangeListener;
    }

    @CallSuper
    protected void enable(int lowerLimitInclusive, int upperLimitExclusive) {
        if (lowerLimitInclusive < 0 || upperLimitExclusive > this.mButtons.length) {
            throw new IndexOutOfBoundsException("Upper limit out of range");
        }
        for (int i = 0; i < this.mButtons.length; ++i) {
            this.mButtons[i].setEnabled(i >= lowerLimitInclusive && i < upperLimitExclusive);
        }
    }

    protected final int valueAt(int index) {
        return this.mInput[index];
    }

    protected final int[] getDigits() {
        int[] digits = new int[this.mInput.length];
        System.arraycopy(this.mInput, 0, digits, 0, this.mInput.length);
        return digits;
    }

    public final int count() {
        return this.mCount;
    }

    protected final int getInput() {
        return Integer.parseInt(this.getInputString());
    }

    private String getInputString() {
        String currentInput = "";
        for (int i : this.mInput) {
            if (i == -1) continue;
            currentInput = currentInput + i;
        }
        return currentInput;
    }

    public void delete() {
        this.delete(this.mCount);
    }

    @Deprecated
    public void delete(int at) {
        if (at - 1 >= 0) {
            this.mInput[at - 1] = -1;
            --this.mCount;
            this.onDigitDeleted(this.getInputString());
        }
    }

    public boolean clear() {
        Arrays.fill(this.mInput, -1);
        this.mCount = 0;
        this.onDigitsCleared();
        return true;
    }

    @CallSuper
    protected void onDigitInserted(String newDigit) {
        if (this.mOnInputChangeListener != null) {
            this.mOnInputChangeListener.onDigitInserted(newDigit);
        }
    }

    @CallSuper
    protected void onDigitDeleted(String newStr) {
        if (this.mOnInputChangeListener != null) {
            this.mOnInputChangeListener.onDigitDeleted(newStr);
        }
    }

    @CallSuper
    protected void onDigitsCleared() {
        if (this.mOnInputChangeListener != null) {
            this.mOnInputChangeListener.onDigitsCleared();
        }
    }

    protected final void insertDigits(int ... digits) {
        if (digits == null) {
            return;
        }
        String newDigits = "";
        for (int d : digits) {
            if (this.mCount == this.mInput.length) break;
            if (d == -1) continue;
            this.mInput[this.mCount++] = d;
            newDigits = newDigits + d;
        }
        if (!newDigits.isEmpty()) {
            this.onDigitInserted(newDigits);
        }
    }

    public final void onClick(View view) {
        if (this.mCount < this.mInput.length) {
            String textNum = ((TextView)view).getText().toString();
            this.insertDigits(Integer.parseInt(textNum));
        }
    }

    private void init() {
        this.setAlignmentMode(0);
        this.setColumnCount(3);
        View.inflate((Context)this.getContext(), (int)this.contentLayout(), (ViewGroup)this);
        this.mButtons[0] = (TextView)this.findViewById(R.id.zero);
        this.mButtons[1] = (TextView)this.findViewById(R.id.one);
        this.mButtons[2] = (TextView)this.findViewById(R.id.two);
        this.mButtons[3] = (TextView)this.findViewById(R.id.three);
        this.mButtons[4] = (TextView)this.findViewById(R.id.four);
        this.mButtons[5] = (TextView)this.findViewById(R.id.five);
        this.mButtons[6] = (TextView)this.findViewById(R.id.six);
        this.mButtons[7] = (TextView)this.findViewById(R.id.seven);
        this.mButtons[8] = (TextView)this.findViewById(R.id.eight);
        this.mButtons[9] = (TextView)this.findViewById(R.id.nine);
        for (TextView tv : this.mButtons) {
            tv.setOnClickListener((View.OnClickListener)this);
        }
        this.mInput = new int[this.capacity()];
        Arrays.fill(this.mInput, -1);
    }

    public static interface OnInputChangeListener {
        public void onDigitInserted(String var1);

        public void onDigitDeleted(String var1);

        public void onDigitsCleared();
    }
}

