/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.grid;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.time.TimePickerPadLayout;

public abstract class NumbersGrid
extends TimePickerPadLayout
implements View.OnClickListener {
    private static final String TAG = "NumbersGrid";
    OnNumberSelectedListener mSelectionListener;
    View mLastSelectedView;
    int mSelectedTextColor;
    int mDefaultTextColor;
    private boolean mIsInitialized = false;
    private int mSelection;

    public NumbersGrid(Context context) {
        this(context, null);
    }

    public NumbersGrid(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NumbersGrid(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mDefaultTextColor = ContextCompat.getColor((Context)context, (int)R.color.text_color_primary_light);
        this.mSelectedTextColor = Utils.getThemeAccentColor(context);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.registerClickListeners();
        View defaultSelectedView = this.getChildAt(this.indexOfDefaultValue());
        this.mSelection = this.valueOf(defaultSelectedView);
        this.setIndicator(defaultSelectedView);
    }

    public void initialize(OnNumberSelectedListener listener) {
        if (this.mIsInitialized) {
            Log.e((String)TAG, (String)"This NumbersGrid may only be initialized once.");
            return;
        }
        this.mSelectionListener = listener;
        this.mIsInitialized = true;
    }

    public int getSelection() {
        return this.mSelection;
    }

    public void setSelection(int value) {
        this.mSelection = value;
    }

    public void onClick(View v) {
        this.setIndicator(v);
        this.mSelection = this.valueOf(v);
        this.mSelectionListener.onNumberSelected(this.mSelection);
    }

    protected boolean canRegisterClickListener(View view) {
        return view instanceof TextView;
    }

    protected void setIndicator(View view) {
        this.clearIndicator();
        TextView tv = (TextView)view;
        tv.setTextColor(this.mSelectedTextColor);
        tv.setTypeface(Utils.SANS_SERIF_THIN_BOLD);
        this.mLastSelectedView = view;
    }

    protected void clearIndicator() {
        if (this.mLastSelectedView != null) {
            TextView tv = (TextView)this.mLastSelectedView;
            tv.setTextColor(this.mDefaultTextColor);
            tv.setTypeface(Utils.isJellybeanOrLater() ? Utils.SANS_SERIF_LIGHT : Typeface.DEFAULT);
            this.mLastSelectedView = null;
        }
    }

    protected int indexOfDefaultValue() {
        return 0;
    }

    protected int valueOf(View button) {
        return Integer.parseInt(((TextView)button).getText().toString());
    }

    void setTheme(Context context, boolean themeDark) {
        this.mDefaultTextColor = ContextCompat.getColor((Context)context, (int)(themeDark ? R.color.text_color_primary_dark : R.color.text_color_primary_light));
        for (int i = 0; i < this.getChildCount(); ++i) {
            TextView tv;
            View v = this.getChildAt(i);
            Utils.setColorControlHighlight(v, this.mSelectedTextColor);
            if (!this.canRegisterClickListener(v) || this.mSelection == this.valueOf((View)(tv = (TextView)v))) continue;
            tv.setTextColor(this.mDefaultTextColor);
        }
    }

    void setAccentColor(@ColorInt int color2) {
        this.mSelectedTextColor = color2;
    }

    private void registerClickListeners() {
        View v;
        for (int i = 0; i < this.getChildCount() && this.canRegisterClickListener(v = this.getChildAt(i)); ++i) {
            v.setOnClickListener((View.OnClickListener)this);
        }
    }

    public static interface OnNumberSelectedListener {
        public void onNumberSelected(int var1);
    }
}

