/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.date.CalendarDay;
import com.philliphsu.bottomsheetpickers.date.DatePickerController;
import com.philliphsu.bottomsheetpickers.date.DatePickerDialog;
import com.philliphsu.bottomsheetpickers.date.DateRangeHelper;
import com.philliphsu.bottomsheetpickers.date.TextViewWithHighlightIndicator;
import com.philliphsu.bottomsheetpickers.date.TextViewWithIndicator;
import java.util.ArrayList;
import java.util.List;

public class YearPickerView
extends ListView
implements AdapterView.OnItemClickListener,
DatePickerDialog.OnDateChangedListener {
    private static final String TAG = "YearPickerView";
    private final DatePickerController mController;
    private YearAdapter mAdapter;
    private int mViewSize;
    private int mChildSize;
    private TextViewWithIndicator mSelectedView;
    private final DateRangeHelper mDateRangeHelper;
    private boolean mThemeDark;
    private int mAccentColor;

    public YearPickerView(Context context, DatePickerController controller) {
        super(context);
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        this.mDateRangeHelper = new DateRangeHelper(controller);
        ViewGroup.LayoutParams frame = new ViewGroup.LayoutParams(-1, -2);
        this.setLayoutParams(frame);
        Resources res = context.getResources();
        this.mViewSize = res.getDimensionPixelOffset(R.dimen.date_picker_view_animator_height);
        this.mChildSize = res.getDimensionPixelOffset(R.dimen.year_label_height);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        this.init(context);
        this.setOnItemClickListener(this);
        this.setSelector((Drawable)new StateListDrawable());
        this.setDividerHeight(0);
        this.onDateChanged();
    }

    private void init(Context context) {
        ArrayList<String> years = new ArrayList<String>();
        for (int year = this.mController.getMinYear(); year <= this.mController.getMaxYear(); ++year) {
            years.add(String.format("%d", year));
        }
        this.mAdapter = new YearAdapter(context, R.layout.year_label_text_view, years);
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    void setTheme(Context context, boolean themeDark) {
        this.mThemeDark = themeDark;
    }

    void setAccentColor(int color2) {
        this.mAccentColor = color2;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        TextViewWithIndicator clickedView = (TextViewWithIndicator)view;
        if (clickedView != null && clickedView.isEnabled()) {
            if (clickedView != this.mSelectedView) {
                this.mSelectedView = clickedView;
            }
            this.mController.tryVibrate();
            this.mController.onYearSelected(YearPickerView.getYearFromTextView(clickedView));
        }
    }

    private static int getYearFromTextView(TextView view) {
        return Integer.parseInt(view.getText().toString());
    }

    public void postSetSelectionCentered(int position) {
        this.postSetSelectionFromTop(position, this.mViewSize / 2 - this.mChildSize / 2);
    }

    public void postSetSelectionFromTop(final int position, final int offset) {
        this.post(new Runnable(){

            @Override
            public void run() {
                YearPickerView.this.setSelectionFromTop(position, offset);
                YearPickerView.this.requestLayout();
            }
        });
    }

    public int getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    @Override
    public void onDateChanged() {
        this.mAdapter.notifyDataSetChanged();
        this.postSetSelectionCentered(this.mController.getSelectedDay().year - this.mController.getMinYear());
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (event.getEventType() == 4096) {
            event.setFromIndex(0);
            event.setToIndex(0);
        }
    }

    private class YearAdapter
    extends ArrayAdapter<String> {
        public YearAdapter(Context context, int resource, List<String> objects) {
            super(context, resource, objects);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextViewWithIndicator v = (TextViewWithIndicator)super.getView(position, convertView, parent);
            v.setTheme(parent.getContext(), YearPickerView.this.mThemeDark);
            if (v instanceof TextViewWithHighlightIndicator && YearPickerView.this.mAccentColor != 0) {
                ((TextViewWithHighlightIndicator)v).setHighlightIndicatorColor(YearPickerView.this.mAccentColor);
            }
            v.requestLayout();
            int year = YearPickerView.getYearFromTextView(v);
            CalendarDay selectedDay = YearPickerView.this.mController.getSelectedDay();
            if (YearPickerView.this.mDateRangeHelper != null && YearPickerView.this.mDateRangeHelper.isOutOfRange(year, selectedDay.month, selectedDay.day)) {
                v.setEnabled(false);
            } else {
                v.setEnabled(true);
                boolean selected = selectedDay.year == year;
                v.drawIndicator(selected);
                if (selected) {
                    YearPickerView.this.mSelectedView = v;
                }
            }
            return v;
        }
    }
}

