/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.date.CalendarDay;
import com.philliphsu.bottomsheetpickers.date.DatePickerController;
import com.philliphsu.bottomsheetpickers.date.DateRangeHelper;
import com.philliphsu.bottomsheetpickers.date.PagingDayPickerView;
import java.text.DateFormatSymbols;
import java.util.Calendar;

final class MonthPickerView
extends View {
    private static final String TAG = "MonthPickerView";
    private static final int NUM_COLUMNS = 3;
    private static final int NUM_ROWS = 4;
    private static final int MONTH_SEPARATOR_WIDTH = 1;
    private static int MONTH_LABEL_TEXT_SIZE;
    private static int MONTH_SELECTED_CIRCLE_SIZE;
    private int mEdgePadding = 0;
    private Paint mMonthLabelPaint;
    private Paint mSelectedCirclePaint;
    private int mWidth;
    private int mRowHeight;
    private CalendarDay mSelectedDay;
    private int mYear;
    private final int mCurrentMonth;
    private final int mCurrentYear;
    private final String[] mShortMonthLabels;
    @Nullable
    private DateRangeHelper mDateRangeHelper;
    @Nullable
    private OnMonthClickListener mOnMonthClickListener;
    private int mNormalTextColor;
    private int mCurrentMonthTextColor;
    private int mDisabledMonthTextColor;
    private int mSelectedMonthTextColor;

    public MonthPickerView(Context context) {
        this(context, null);
    }

    public MonthPickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources res = context.getResources();
        this.mShortMonthLabels = new DateFormatSymbols().getShortMonths();
        this.mNormalTextColor = ContextCompat.getColor((Context)context, (int)R.color.text_color_primary_light);
        this.mSelectedMonthTextColor = ContextCompat.getColor((Context)context, (int)R.color.date_picker_view_animator);
        this.mCurrentMonthTextColor = Utils.getThemeAccentColor(context);
        this.mDisabledMonthTextColor = ContextCompat.getColor((Context)context, (int)R.color.text_color_disabled_light);
        Calendar now = Calendar.getInstance();
        this.mCurrentMonth = now.get(2);
        this.mCurrentYear = now.get(1);
        MONTH_LABEL_TEXT_SIZE = res.getDimensionPixelSize(R.dimen.month_picker_month_label_size);
        MONTH_SELECTED_CIRCLE_SIZE = res.getDimensionPixelSize(R.dimen.month_select_circle_radius);
        this.mRowHeight = (res.getDimensionPixelOffset(R.dimen.date_picker_view_animator_height) - PagingDayPickerView.MONTH_NAVIGATION_BAR_SIZE) / 4;
        this.mEdgePadding = res.getDimensionPixelSize(R.dimen.month_view_edge_padding);
        this.initView();
    }

    void setDisplayParams(CalendarDay selectedDay, int year) {
        this.mSelectedDay = selectedDay;
        this.mYear = year;
    }

    private void adjustDayInMonthIfNeeded(int month) {
        int daysInMonth = Utils.getDaysInMonth(month, this.mYear);
        if (this.mSelectedDay.day > daysInMonth) {
            this.mSelectedDay.day = daysInMonth;
        }
    }

    private int constrainDayInMonth(int month, int defaultDay) {
        int daysInMonth = Utils.getDaysInMonth(month, this.mYear);
        return Math.min(defaultDay, daysInMonth);
    }

    public void setDatePickerController(DatePickerController controller) {
        this.mDateRangeHelper = new DateRangeHelper(controller);
    }

    public void setOnMonthClickListener(@Nullable OnMonthClickListener onMonthClickListener) {
        this.mOnMonthClickListener = onMonthClickListener;
    }

    void setTheme(Context context, boolean themeDark) {
        if (themeDark) {
            this.mNormalTextColor = ContextCompat.getColor((Context)context, (int)R.color.text_color_primary_dark);
            this.mSelectedMonthTextColor = ContextCompat.getColor((Context)context, (int)R.color.dark_gray);
            this.mDisabledMonthTextColor = ContextCompat.getColor((Context)context, (int)R.color.text_color_disabled_dark);
            this.initView();
        }
    }

    void setCurrentMonthTextColor(@ColorInt int color2) {
        this.mCurrentMonthTextColor = color2;
    }

    void setSelectedCirclePaintColor(@ColorInt int color2) {
        this.mSelectedCirclePaint.setColor(color2);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                int month = this.getMonthFromLocation(event.getX(), event.getY());
                if (month < 0) break;
                this.onMonthClick(month);
            }
        }
        return true;
    }

    protected void initView() {
        this.mMonthLabelPaint = new Paint();
        this.mMonthLabelPaint.setAntiAlias(true);
        this.mMonthLabelPaint.setTextSize((float)MONTH_LABEL_TEXT_SIZE);
        this.mMonthLabelPaint.setStyle(Paint.Style.FILL);
        this.mMonthLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthLabelPaint.setFakeBoldText(false);
        this.mSelectedCirclePaint = new Paint();
        this.mSelectedCirclePaint.setFakeBoldText(true);
        this.mSelectedCirclePaint.setAntiAlias(true);
        this.mSelectedCirclePaint.setColor(this.mCurrentMonthTextColor);
        this.mSelectedCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mSelectedCirclePaint.setStyle(Paint.Style.FILL);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), this.mRowHeight * 4 + PagingDayPickerView.MONTH_NAVIGATION_BAR_SIZE);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawMonthLabels(canvas);
    }

    private void drawMonthLabels(Canvas canvas) {
        int y = (this.mRowHeight + MONTH_LABEL_TEXT_SIZE) / 2 - 1;
        float monthWidthHalf = (float)(this.mWidth - this.mEdgePadding * 2) / 6.0f;
        int col = 0;
        for (int month = 0; month <= 11; ++month) {
            int x = (int)((float)(2 * col + 1) * monthWidthHalf + (float)this.mEdgePadding);
            int constrainedDay = this.constrainDayInMonth(month, this.mSelectedDay.day);
            this.drawMonthLabel(canvas, this.mYear, month, constrainedDay, x, y);
            if (++col != 3) continue;
            col = 0;
            y += this.mRowHeight;
        }
    }

    private void drawMonthLabel(Canvas canvas, int year, int month, int day, int x, int y) {
        boolean drawCircle;
        int selectedYear = this.mSelectedDay.year;
        int selectedMonth = this.mSelectedDay.month;
        boolean bl = drawCircle = selectedYear == year && selectedMonth == month;
        if (drawCircle) {
            canvas.drawCircle((float)x, (float)(y - MONTH_LABEL_TEXT_SIZE / 3), (float)MONTH_SELECTED_CIRCLE_SIZE, this.mSelectedCirclePaint);
        }
        if (this.mDateRangeHelper != null && this.mDateRangeHelper.isOutOfRange(year, month, day)) {
            this.mMonthLabelPaint.setFakeBoldText(false);
            this.mMonthLabelPaint.setColor(this.mDisabledMonthTextColor);
        } else {
            boolean currentMonthYear = this.mCurrentYear == year && this.mCurrentMonth == month;
            this.mMonthLabelPaint.setFakeBoldText(currentMonthYear || drawCircle);
            this.mMonthLabelPaint.setColor(drawCircle ? this.mSelectedMonthTextColor : (currentMonthYear ? this.mCurrentMonthTextColor : this.mNormalTextColor));
        }
        canvas.drawText(this.mShortMonthLabels[month], (float)x, (float)y, this.mMonthLabelPaint);
    }

    public int getMonthFromLocation(float x, float y) {
        int month = this.getInternalMonthFromLocation(x, y);
        if (month < 0 || month > 11) {
            return -1;
        }
        return month;
    }

    protected int getInternalMonthFromLocation(float x, float y) {
        int column;
        int monthStart = this.mEdgePadding;
        if (x < (float)monthStart || x > (float)(this.mWidth - this.mEdgePadding)) {
            return -1;
        }
        int row = (int)(y / (float)this.mRowHeight);
        int month = column = (int)((x - (float)monthStart) * 3.0f / (float)(this.mWidth - this.mEdgePadding * 2));
        return month += row * 3;
    }

    private void onMonthClick(int month) {
        this.adjustDayInMonthIfNeeded(month);
        if (this.mDateRangeHelper != null && this.mDateRangeHelper.isOutOfRange(this.mYear, month, this.mSelectedDay.day)) {
            return;
        }
        if (this.mOnMonthClickListener != null) {
            this.mOnMonthClickListener.onMonthClick(this, month, this.mYear);
        }
    }

    static interface OnMonthClickListener {
        public void onMonthClick(MonthPickerView var1, int var2, int var3);
    }
}

