/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import android.content.Context;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ViewAnimator;
import com.philliphsu.bottomsheetpickers.R;

final class DayPickerViewAnimator
extends ViewAnimator {
    private final Animation mDayPickerInAnimation;
    private final Animation mDayPickerOutAnimation;
    private final Animation mMonthPickerInAnimation;
    private final Animation mMonthPickerOutAnimation;

    public DayPickerViewAnimator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mDayPickerInAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.day_picker_slide_up);
        this.mDayPickerOutAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.day_picker_slide_down);
        this.mMonthPickerInAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.month_picker_slide_down);
        this.mMonthPickerOutAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.month_picker_slide_up);
    }

    public void setDisplayedChild(int whichChild) {
        switch (whichChild) {
            case 0: {
                this.setInAnimation(this.mDayPickerInAnimation);
                this.setOutAnimation(this.mMonthPickerOutAnimation);
                break;
            }
            case 1: {
                this.setInAnimation(this.mMonthPickerInAnimation);
                this.setOutAnimation(this.mDayPickerOutAnimation);
            }
        }
        super.setDisplayedChild(whichChild);
    }

    final void setDisplayedChild(int whichChild, boolean animate) {
        if (animate) {
            this.setDisplayedChild(whichChild);
        } else {
            this.setInAnimation(null);
            this.setOutAnimation(null);
            super.setDisplayedChild(whichChild);
        }
    }
}

