/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.philliphsu.bottomsheetpickers.CustomWidthBottomSheetDialog;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;

public abstract class BottomSheetPickerDialog
extends BottomSheetDialogFragment {
    private static final String KEY_DARK_THEME = "dark_theme";
    private static final String KEY_THEME_SET_AT_RUNTIME = "theme_set_at_runtime";
    private static final String KEY_ACCENT_COLOR = "accent_color";
    private static final String KEY_BACKGROUND_COLOR = "background_color";
    private static final String KEY_HEADER_COLOR = "header_color";
    private static final String KEY_HEADER_TEXT_DARK = "header_text_dark";
    protected boolean mThemeDark;
    protected boolean mThemeSetAtRuntime;
    protected int mDarkGray;
    protected int mLightGray;
    protected int mWhite;
    protected int mWhiteTextDisabled;
    protected int mBlackText;
    protected int mBlackTextDisabled;
    protected int mAccentColor;
    protected int mBackgroundColor;
    protected int mHeaderColor;
    protected boolean mHeaderTextDark;

    @LayoutRes
    protected abstract int contentLayout();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mThemeDark = savedInstanceState.getBoolean(KEY_DARK_THEME);
            this.mThemeSetAtRuntime = savedInstanceState.getBoolean(KEY_THEME_SET_AT_RUNTIME);
            this.mAccentColor = savedInstanceState.getInt(KEY_ACCENT_COLOR);
            this.mBackgroundColor = savedInstanceState.getInt(KEY_BACKGROUND_COLOR);
            this.mHeaderColor = savedInstanceState.getInt(KEY_HEADER_COLOR);
            this.mHeaderTextDark = savedInstanceState.getBoolean(KEY_HEADER_TEXT_DARK);
        }
        FragmentActivity ctx = this.getActivity();
        this.mDarkGray = ContextCompat.getColor((Context)ctx, (int)R.color.dark_gray);
        this.mLightGray = ContextCompat.getColor((Context)ctx, (int)R.color.light_gray);
        this.mWhite = ContextCompat.getColor((Context)ctx, (int)17170443);
        this.mWhiteTextDisabled = ContextCompat.getColor((Context)ctx, (int)R.color.text_color_disabled_dark);
        this.mBlackText = ContextCompat.getColor((Context)ctx, (int)R.color.text_color_primary_light);
        this.mBlackTextDisabled = ContextCompat.getColor((Context)ctx, (int)R.color.text_color_disabled_light);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (!this.mThemeSetAtRuntime) {
            this.mThemeDark = Utils.isDarkTheme((Context)this.getActivity(), this.mThemeDark);
        }
        if (this.mAccentColor == 0) {
            this.mAccentColor = Utils.getThemeAccentColor((Context)this.getActivity());
        }
        if (this.mBackgroundColor == 0) {
            int n = this.mBackgroundColor = this.mThemeDark ? this.mDarkGray : this.mWhite;
        }
        if (this.mHeaderColor == 0) {
            this.mHeaderColor = this.mThemeDark ? this.mLightGray : this.mAccentColor;
        }
        View view = inflater.inflate(this.contentLayout(), container, false);
        view.setBackgroundColor(this.mBackgroundColor);
        return view;
    }

    @NonNull
    public final Dialog onCreateDialog(Bundle savedInstanceState) {
        return new CustomWidthBottomSheetDialog(this.getContext(), R.style.BottomSheetDialogTheme);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_DARK_THEME, this.mThemeDark);
        outState.putBoolean(KEY_THEME_SET_AT_RUNTIME, this.mThemeSetAtRuntime);
        outState.putInt(KEY_ACCENT_COLOR, this.mAccentColor);
        outState.putInt(KEY_BACKGROUND_COLOR, this.mBackgroundColor);
        outState.putInt(KEY_HEADER_COLOR, this.mHeaderColor);
        outState.putBoolean(KEY_HEADER_TEXT_DARK, this.mHeaderTextDark);
    }

    public void setThemeDark(boolean dark) {
        this.mThemeDark = dark;
        this.mThemeSetAtRuntime = true;
    }

    public boolean isThemeDark() {
        return this.mThemeDark;
    }

    public final void setAccentColor(@ColorInt int color2) {
        this.mAccentColor = color2;
    }

    public final void setBackgroundColor(@ColorInt int color2) {
        this.mBackgroundColor = color2;
    }

    public final void setHeaderColor(@ColorInt int color2) {
        this.mHeaderColor = color2;
    }

    public final void setHeaderTextDark(boolean dark) {
        this.mHeaderTextDark = dark;
    }

    protected final int getDefaultHeaderTextColorSelected() {
        return this.mHeaderTextDark ? this.mBlackText : this.mWhite;
    }

    protected final int getDefaultHeaderTextColorUnselected() {
        return this.mHeaderTextDark ? this.mBlackTextDisabled : this.mWhiteTextDisabled;
    }

    public static abstract class Builder {
        private int mAccentColor;
        private int mBackgroundColor;
        private int mHeaderColor;
        private boolean mHeaderTextDark;
        private boolean mThemeDark;

        public Builder setAccentColor(int accentColor) {
            this.mAccentColor = accentColor;
            return this;
        }

        public Builder setBackgroundColor(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
            return this;
        }

        public Builder setHeaderColor(int headerColor) {
            this.mHeaderColor = headerColor;
            return this;
        }

        public Builder setHeaderTextDark(boolean headerTextDark) {
            this.mHeaderTextDark = headerTextDark;
            return this;
        }

        public Builder setThemeDark(boolean themeDark) {
            this.mThemeDark = themeDark;
            return this;
        }

        protected void super_build(@NonNull BottomSheetPickerDialog dialog) {
            dialog.setAccentColor(this.mAccentColor);
            dialog.setBackgroundColor(this.mBackgroundColor);
            dialog.setHeaderColor(this.mHeaderColor);
            dialog.setHeaderTextDark(this.mHeaderTextDark);
            dialog.setThemeDark(this.mThemeDark);
        }

        public abstract BottomSheetPickerDialog build();
    }
}

