/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.content.ContextCompat;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.time.numberpad.GridLayoutNumberPad;
import java.text.DateFormatSymbols;

class NumberPadTimePicker
extends GridLayoutNumberPad {
    private static final int MAX_DIGITS = 4;
    private static final int MAX_CHARS = 8;
    private static final int BASE_10 = 10;
    static final int UNSPECIFIED = -1;
    static final int AM = 0;
    static final int PM = 1;
    static final int HRS_24 = 2;
    private int mAmPmState = -1;
    private final StringBuilder mFormattedInput = new StringBuilder(8);
    private final Button[] mAltButtons = new Button[2];
    private final FloatingActionButton mFab;
    private final ImageButton mBackspace;
    private boolean mThemeDark;
    private final int mFabDisabledColorDark;
    private final int mFabDisabledColorLight;
    @Nullable
    private final ObjectAnimator mElevationAnimator;
    private final View.OnClickListener mAltButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            TextView altBtn = (TextView)view;
            if (!NumberPadTimePicker.this.is24HourFormat()) {
                if (NumberPadTimePicker.this.count() <= 2) {
                    NumberPadTimePicker.this.insertDigits(0, 0);
                }
                String ampm = altBtn.getText().toString();
                NumberPadTimePicker.this.mFormattedInput.append(' ').append(ampm);
                String am = new DateFormatSymbols().getAmPmStrings()[0];
                NumberPadTimePicker.this.mAmPmState = ampm.equals(am) ? 0 : 1;
                NumberPadTimePicker.super.onDigitInserted(NumberPadTimePicker.this.mFormattedInput.toString());
            } else {
                CharSequence text = altBtn.getText();
                int[] digits = new int[text.length() - 1];
                for (int i = 1; i < text.length(); ++i) {
                    digits[i - 1] = Character.digit(text.charAt(i), 10);
                }
                NumberPadTimePicker.this.insertDigits(digits);
                NumberPadTimePicker.this.mAmPmState = 2;
            }
            NumberPadTimePicker.this.updateNumpadStates();
        }
    };

    public NumberPadTimePicker(Context context) {
        this(context, null);
    }

    public NumberPadTimePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mAltButtons[0] = (Button)this.findViewById(R.id.leftAlt);
        this.mAltButtons[1] = (Button)this.findViewById(R.id.rightAlt);
        this.mFab = (FloatingActionButton)this.findViewById(R.id.fab);
        this.mBackspace = (ImageButton)this.findViewById(R.id.backspace);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mElevationAnimator = ObjectAnimator.ofFloat((Object)this.mFab, (String)"elevation", (float[])new float[]{this.getResources().getDimension(R.dimen.fab_elevation)}).setDuration(200L);
            this.mElevationAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        } else {
            this.mElevationAnimator = null;
        }
        this.mFabDisabledColorDark = ContextCompat.getColor((Context)this.getContext(), (int)R.color.fab_disabled_dark);
        this.mFabDisabledColorLight = ContextCompat.getColor((Context)this.getContext(), (int)R.color.fab_disabled_light);
        if (DateFormat.is24HourFormat((Context)this.getContext())) {
            this.mAltButtons[0].setText(R.string.left_alt_24hr);
            this.mAltButtons[1].setText(R.string.right_alt_24hr);
        } else {
            String[] amPm = new DateFormatSymbols().getAmPmStrings();
            this.mAltButtons[0].setText((CharSequence)(amPm[0].length() > 2 ? "AM" : amPm[0]));
            this.mAltButtons[1].setText((CharSequence)(amPm[1].length() > 2 ? "PM" : amPm[1]));
        }
        this.updateNumpadStates();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        for (Button b : this.mAltButtons) {
            b.setOnClickListener(this.mAltButtonClickListener);
        }
        this.mBackspace.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NumberPadTimePicker.this.delete();
            }
        });
        this.mBackspace.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return NumberPadTimePicker.this.clear();
            }
        });
    }

    @Override
    void setTheme(Context context, boolean themeDark) {
        super.setTheme(context, themeDark);
        this.mThemeDark = themeDark;
        for (Button b : this.mAltButtons) {
            this.setTextColor((TextView)b);
            Utils.setColorControlHighlight((View)b, this.mAccentColor);
        }
        Utils.setColorControlHighlight((View)this.mBackspace, this.mAccentColor);
        ColorStateList colorBackspace = ContextCompat.getColorStateList((Context)context, (int)(themeDark ? R.color.icon_color_dark : R.color.icon_color));
        Utils.setTintList((ImageView)this.mBackspace, this.mBackspace.getDrawable(), colorBackspace);
        ColorStateList colorIcon = ContextCompat.getColorStateList((Context)context, (int)(themeDark ? R.color.icon_color_dark : R.color.fab_icon_color));
        Utils.setTintList((ImageView)this.mFab, this.mFab.getDrawable(), colorIcon);
        this.updateFabState();
    }

    @Override
    public int capacity() {
        return 4;
    }

    @Override
    protected int contentLayout() {
        return R.layout.content_numpad_time_picker;
    }

    @Override
    protected void enable(int lowerLimitInclusive, int upperLimitExclusive) {
        super.enable(lowerLimitInclusive, upperLimitExclusive);
        if (lowerLimitInclusive == 0 && upperLimitExclusive == 0) {
            if (!this.is24HourFormat() && (this.mAltButtons[0].isEnabled() || this.mAltButtons[1].isEnabled())) {
                return;
            }
            ((OnInputChangeListener)this.getOnInputChangeListener()).onInputDisabled();
        }
    }

    @Override
    protected void onDigitInserted(String newDigit) {
        this.updateFormattedInputOnDigitInserted(newDigit);
        super.onDigitInserted(this.mFormattedInput.toString());
        this.updateNumpadStates();
    }

    @Override
    protected void onDigitDeleted(String newStr) {
        this.updateFormattedInputOnDigitDeleted();
        super.onDigitDeleted(this.mFormattedInput.toString());
        this.updateNumpadStates();
    }

    @Override
    protected void onDigitsCleared() {
        this.mFormattedInput.delete(0, this.mFormattedInput.length());
        this.mAmPmState = -1;
        this.updateNumpadStates();
        super.onDigitsCleared();
    }

    @Override
    public void delete() {
        int len = this.mFormattedInput.length();
        if (!this.is24HourFormat() && this.mAmPmState != -1) {
            this.mAmPmState = -1;
            this.mFormattedInput.delete(this.mFormattedInput.indexOf(" "), len);
            super.onDigitDeleted(this.mFormattedInput.toString());
            this.updateNumpadStates();
        } else {
            super.delete();
        }
    }

    public int getHour() {
        int hours;
        if (!this.checkTimeValid()) {
            throw new IllegalStateException("Cannot call hourOfDay() until legal time inputted");
        }
        int n = hours = this.count() < 4 ? this.valueAt(0) : this.valueAt(0) * 10 + this.valueAt(1);
        if (hours == 12) {
            switch (this.mAmPmState) {
                case 0: {
                    return 0;
                }
                case 1: 
                case 2: {
                    return 12;
                }
            }
        }
        return hours + (this.mAmPmState == 1 ? 12 : 0);
    }

    public int getMinute() {
        if (!this.checkTimeValid()) {
            throw new IllegalStateException("Cannot call minute() until legal time inputted");
        }
        return this.count() < 4 ? this.valueAt(1) * 10 + this.valueAt(2) : this.valueAt(2) * 10 + this.valueAt(3);
    }

    public boolean checkTimeValid() {
        return this.mAmPmState != -1 && (this.mAmPmState != 2 || this.count() >= 3);
    }

    public void setTime(int hours, int minutes) {
        int amPmState;
        if (hours < 0 || hours > 23) {
            throw new IllegalArgumentException("Illegal hours: " + hours);
        }
        if (minutes < 0 || minutes > 59) {
            throw new IllegalArgumentException("Illegal minutes: " + minutes);
        }
        if (!this.is24HourFormat()) {
            if (hours == 0) {
                hours = 12;
                amPmState = 0;
            } else if (hours == 12) {
                amPmState = 1;
            } else if (hours > 12) {
                hours -= 12;
                amPmState = 1;
            } else {
                amPmState = 0;
            }
        } else {
            amPmState = 2;
        }
        if (this.is24HourFormat() || hours > 9) {
            this.insertDigits(hours / 10, hours % 10, minutes / 10, minutes % 10);
        } else {
            this.insertDigits(hours, minutes / 10, minutes % 10);
        }
        this.mAmPmState = amPmState;
        if (this.mAmPmState != 2) {
            this.mAltButtonClickListener.onClick((View)(this.mAmPmState == 0 ? this.mAltButtons[0] : this.mAltButtons[1]));
        }
    }

    public String getTime() {
        return this.mFormattedInput.toString();
    }

    int getAmPmState() {
        return this.mAmPmState;
    }

    void setAmPmState(int amPmState) {
        switch (amPmState) {
            case 0: 
            case 1: {
                this.mAltButtonClickListener.onClick((View)this.mAltButtons[amPmState]);
                break;
            }
            case 2: {
                break;
            }
            case -1: {
                this.mAmPmState = amPmState;
            }
        }
    }

    private boolean is24HourFormat() {
        return DateFormat.is24HourFormat((Context)this.getContext());
    }

    private void updateFormattedInputOnDigitInserted(String newDigits) {
        this.mFormattedInput.append(newDigits);
        if (this.count() == 3) {
            int digits = this.getInput();
            if (digits >= 60 && digits < 100 || digits >= 160 && digits < 200) {
                this.mFormattedInput.insert(2, ':');
            } else {
                this.mFormattedInput.insert(1, ':');
                if (this.is24HourFormat()) {
                    this.mAmPmState = 2;
                }
            }
        } else if (this.count() == 4) {
            int colonAt = this.mFormattedInput.indexOf(":");
            if (colonAt != -1) {
                this.mFormattedInput.deleteCharAt(colonAt);
            }
            this.mFormattedInput.insert(2, ':');
            if (this.is24HourFormat()) {
                this.mAmPmState = 2;
            }
        }
    }

    private void updateFormattedInputOnDigitDeleted() {
        int len = this.mFormattedInput.length();
        this.mFormattedInput.delete(len - 1, len);
        if (this.count() == 3) {
            int value = this.getInput();
            if (value <= 155 || value >= 200 && value <= 235) {
                this.mFormattedInput.deleteCharAt(this.mFormattedInput.indexOf(":"));
                this.mFormattedInput.insert(1, ":");
            } else {
                this.mAmPmState = -1;
            }
        } else if (this.count() == 2) {
            this.mFormattedInput.deleteCharAt(this.mFormattedInput.indexOf(":"));
            this.mAmPmState = -1;
        }
    }

    private void updateNumpadStates() {
        this.updateAltButtonStates();
        this.updateBackspaceState();
        this.updateNumberKeysStates();
        this.updateFabState();
    }

    private void updateFabState() {
        int color2;
        boolean lastEnabled = this.mFab.isEnabled();
        this.mFab.setEnabled(this.checkTimeValid());
        if (this.mFab.isEnabled()) {
            color2 = this.mAccentColor;
            if (this.mElevationAnimator != null && !lastEnabled) {
                this.mElevationAnimator.start();
            }
        } else {
            int n = color2 = this.mThemeDark ? this.mFabDisabledColorDark : this.mFabDisabledColorLight;
            if (lastEnabled && Build.VERSION.SDK_INT >= 21) {
                if (this.mElevationAnimator != null && this.mElevationAnimator.isRunning()) {
                    this.mElevationAnimator.end();
                }
                this.mFab.setElevation(0.0f);
            }
        }
        this.mFab.setBackgroundTintList(ColorStateList.valueOf((int)color2));
    }

    private void updateBackspaceState() {
        this.mBackspace.setEnabled(this.count() > 0);
    }

    private void updateAltButtonStates() {
        if (this.count() == 0) {
            this.mAltButtons[0].setEnabled(false);
            this.mAltButtons[1].setEnabled(false);
        } else if (this.count() == 1) {
            this.mAltButtons[0].setEnabled(true);
            this.mAltButtons[1].setEnabled(true);
        } else if (this.count() == 2) {
            int time = this.getInput();
            boolean validTwoDigitHour = this.is24HourFormat() ? time <= 23 : time >= 10 && time <= 12;
            this.mAltButtons[0].setEnabled(validTwoDigitHour);
            this.mAltButtons[1].setEnabled(validTwoDigitHour);
        } else if (this.count() == 3) {
            if (this.is24HourFormat()) {
                this.mAltButtons[0].setEnabled(false);
                this.mAltButtons[1].setEnabled(false);
            } else {
                boolean enabled = this.mAmPmState == -1;
                this.mAltButtons[0].setEnabled(enabled);
                this.mAltButtons[1].setEnabled(enabled);
            }
        } else if (this.count() == 4) {
            boolean enabled = !this.is24HourFormat() && this.mAmPmState == -1;
            this.mAltButtons[0].setEnabled(enabled);
            this.mAltButtons[1].setEnabled(enabled);
        }
    }

    private void updateNumberKeysStates() {
        int cap = 10;
        boolean is24hours = this.is24HourFormat();
        if (this.count() == 0) {
            this.enable(is24hours ? 0 : 1, cap);
            return;
        }
        if (this.count() == 4) {
            this.enable(0, 0);
            return;
        }
        int time = this.getInput();
        if (is24hours) {
            if (this.count() == 1) {
                this.enable(0, time < 2 ? cap : 6);
            } else if (this.count() == 2) {
                this.enable(0, time % 10 >= 0 && time % 10 <= 5 ? cap : 6);
            } else if (this.count() == 3) {
                if (time >= 236) {
                    this.enable(0, 0);
                } else {
                    this.enable(0, time % 10 >= 0 && time % 10 <= 5 ? cap : 0);
                }
            }
        } else if (this.count() == 1) {
            if (time == 0) {
                throw new IllegalStateException("12-hr format, zeroth digit = 0?");
            }
            this.enable(0, 6);
        } else if (this.count() == 2 || this.count() == 3) {
            if (time >= 126) {
                this.enable(0, 0);
            } else if (time >= 100 && time <= 125 && this.mAmPmState != -1) {
                this.enable(0, 0);
            } else {
                this.enable(0, time % 10 >= 0 && time % 10 <= 5 ? cap : 0);
            }
        }
    }

    public static interface OnInputChangeListener
    extends GridLayoutNumberPad.OnInputChangeListener {
        public void onInputDisabled();
    }
}

