/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.grid;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.R;

public class TwentyFourHourGridItem
extends LinearLayout {
    private final TextView mPrimaryText;
    private final TextView mSecondaryText;

    public TwentyFourHourGridItem(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TwentyFourHourGridItem(Context context, AttributeSet attrs) {
        super(context, attrs);
        int orientation = context.getResources().getConfiguration().orientation;
        this.setOrientation(orientation == 1 ? 1 : 0);
        this.setGravity(17);
        TwentyFourHourGridItem.inflate((Context)this.getContext(), (int)R.layout.content_24h_grid_item, (ViewGroup)this);
        this.mPrimaryText = (TextView)this.findViewById(R.id.primary);
        this.mSecondaryText = (TextView)this.findViewById(R.id.secondary);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TwentyFourHourGridItem, 0, 0);
        try {
            this.setPrimaryText(a.getString(R.styleable.TwentyFourHourGridItem_primaryText));
            this.setSecondaryText(a.getString(R.styleable.TwentyFourHourGridItem_secondaryText));
        }
        finally {
            a.recycle();
        }
    }

    public CharSequence getPrimaryText() {
        return this.mPrimaryText.getText();
    }

    public void setPrimaryText(CharSequence text) {
        this.mPrimaryText.setText(text);
    }

    public CharSequence getSecondaryText() {
        return this.mSecondaryText.getText();
    }

    public void setSecondaryText(CharSequence text) {
        this.mSecondaryText.setText(text);
    }

    public void swapTexts() {
        CharSequence primary = this.mPrimaryText.getText();
        this.setPrimaryText(this.mSecondaryText.getText());
        this.setSecondaryText(primary);
    }

    public TextView getPrimaryTextView() {
        return (TextView)this.getChildAt(0);
    }

    public TextView getSecondaryTextView() {
        return (TextView)this.getChildAt(1);
    }
}

