/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.graphics.drawable.AnimatedVectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.date.CalendarDay;
import com.philliphsu.bottomsheetpickers.date.DatePickerController;
import com.philliphsu.bottomsheetpickers.date.DatePickerDialog;
import com.philliphsu.bottomsheetpickers.date.DayPickerViewAnimator;
import com.philliphsu.bottomsheetpickers.date.MonthPickerView;
import com.philliphsu.bottomsheetpickers.date.MonthView;
import com.philliphsu.bottomsheetpickers.date.PagingMonthAdapter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

class PagingDayPickerView
extends LinearLayout
implements DatePickerDialog.OnDateChangedListener,
ViewPager.OnPageChangeListener,
MonthPickerView.OnMonthClickListener {
    private static final String TAG = "MonthFragment";
    static final int DAY_PICKER_INDEX = 0;
    static final int MONTH_PICKER_INDEX = 1;
    static int MONTH_NAVIGATION_BAR_SIZE;
    private static final SimpleDateFormat YEAR_FORMAT;
    protected Handler mHandler;
    protected CalendarDay mSelectedDay = new CalendarDay();
    protected PagingMonthAdapter mAdapter;
    private DayPickerViewAnimator mMonthAnimator;
    private ViewPager mViewPager;
    private MonthPickerView mMonthPickerView;
    private TextView mMonthYearTitleView;
    private ImageButton mPreviousButton;
    private ImageButton mNextButton;
    private View mTitleContainer;
    private AnimatedVectorDrawableCompat mArrowDownDrawable;
    private AnimatedVectorDrawableCompat mArrowUpDrawable;
    protected CalendarDay mTempDay = new CalendarDay();
    protected int mCurrentMonthDisplayed;
    private int mCurrentView = 0;
    private int mCurrentYearDisplayed;
    private DatePickerController mController;
    private boolean mThemeDark;

    public PagingDayPickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public PagingDayPickerView(Context context, DatePickerController controller) {
        this(context, controller, false);
    }

    public PagingDayPickerView(Context context, DatePickerController controller, boolean themeDark) {
        super(context);
        this.mThemeDark = themeDark;
        this.init(context);
        this.setController(controller);
    }

    public void setController(DatePickerController controller) {
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        this.refreshAdapter();
        this.onDateChanged();
        this.mMonthPickerView.setDatePickerController(this.mController);
    }

    private void init(Context context) {
        this.mHandler = new Handler();
        this.setOrientation(1);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        Resources res = this.getResources();
        MONTH_NAVIGATION_BAR_SIZE = res.getDimensionPixelOffset(R.dimen.month_navigation_bar_height) + res.getDimensionPixelOffset(R.dimen.month_view_top_padding);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.day_picker_content, (ViewGroup)this, true);
        this.mMonthAnimator = (DayPickerViewAnimator)this.findViewById(R.id.month_animator);
        this.mMonthPickerView = (MonthPickerView)this.findViewById(R.id.month_picker);
        this.mMonthPickerView.setOnMonthClickListener(this);
        this.mViewPager = (ViewPager)this.findViewById(R.id.viewpager);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mMonthYearTitleView = (TextView)view.findViewById(R.id.month_year_title);
        this.mTitleContainer = view.findViewById(R.id.month_year_title_container);
        this.mTitleContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int newIndex = PagingDayPickerView.this.mCurrentView == 0 ? 1 : 0;
                PagingDayPickerView.this.setupCurrentView(newIndex, true);
            }
        });
        this.mPreviousButton = (ImageButton)view.findViewById(R.id.prev);
        this.mPreviousButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int previousItem = PagingDayPickerView.this.mViewPager.getCurrentItem() - 1;
                if (previousItem >= 0) {
                    PagingDayPickerView.this.mViewPager.setCurrentItem(previousItem, true);
                }
            }
        });
        this.mNextButton = (ImageButton)view.findViewById(R.id.next);
        this.mNextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int nextItem = PagingDayPickerView.this.mViewPager.getCurrentItem() + 1;
                if (nextItem < PagingDayPickerView.this.mAdapter.getCount()) {
                    PagingDayPickerView.this.mViewPager.setCurrentItem(nextItem, true);
                }
            }
        });
        this.mArrowDownDrawable = AnimatedVectorDrawableCompat.create((Context)context, (int)R.drawable.animated_arrow_drop_down);
        this.mArrowUpDrawable = AnimatedVectorDrawableCompat.create((Context)context, (int)R.drawable.animated_arrow_drop_up);
        this.setArrowDrawableOnTitle((Drawable)this.mArrowDownDrawable);
        if (this.mThemeDark) {
            int selectableItemBg = ContextCompat.getColor((Context)context, (int)R.color.selectable_item_background_dark);
            Utils.setColorControlHighlight((View)this.mPreviousButton, selectableItemBg);
            Utils.setColorControlHighlight((View)this.mNextButton, selectableItemBg);
            Utils.setColorControlHighlight(this.mTitleContainer, selectableItemBg);
            int cursor = ContextCompat.getColor((Context)context, (int)R.color.text_color_secondary_dark);
            Utils.applyTint((ImageView)this.mPreviousButton, cursor);
            Utils.applyTint((ImageView)this.mNextButton, cursor);
        }
        int monthYearTitleColor = ContextCompat.getColor((Context)context, (int)(this.mThemeDark ? R.color.text_color_primary_dark : R.color.text_color_primary_light));
        int dropdownArrowColor = ContextCompat.getColor((Context)context, (int)(this.mThemeDark ? R.color.icon_color_active_dark : R.color.icon_color_active_light));
        this.mMonthYearTitleView.setTextColor(monthYearTitleColor);
        this.mArrowDownDrawable.setTint(dropdownArrowColor);
        this.mArrowUpDrawable.setTint(dropdownArrowColor);
        this.mMonthPickerView.setTheme(context, this.mThemeDark);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
    }

    void setTheme(Context context, boolean themeDark) {
        this.mThemeDark = themeDark;
    }

    public void onChange() {
        this.refreshAdapter();
        this.refreshMonthPicker();
    }

    void setupCurrentView(int currentView, boolean animate) {
        if (currentView == 0 || currentView == 1) {
            boolean isDayPicker = currentView == 0;
            this.setCurrentView(currentView, animate);
            if (isDayPicker) {
                this.setTitle(this.mAdapter.getPageTitle(this.mViewPager.getCurrentItem()));
                this.toggleArrowsVisibility(this.getPagerPosition());
            } else {
                this.setTitle(String.valueOf(this.mCurrentYearDisplayed));
                this.toggleArrowsVisibility(false, false);
            }
        } else {
            Log.e((String)TAG, (String)"Error restoring current view");
        }
    }

    protected void refreshAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = this.createMonthAdapter(this.getContext(), this.mController, this.mThemeDark);
        } else {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        this.mViewPager.setAdapter((PagerAdapter)this.mAdapter);
    }

    private void refreshMonthPicker() {
        this.prepareMonthPickerForDisplay(this.mSelectedDay.year);
        this.mMonthPickerView.invalidate();
    }

    public PagingMonthAdapter createMonthAdapter(Context context, DatePickerController controller) {
        return new PagingMonthAdapter(context, controller);
    }

    public PagingMonthAdapter createMonthAdapter(Context context, DatePickerController controller, boolean themeDark) {
        return new PagingMonthAdapter(context, controller, themeDark);
    }

    public boolean goTo(CalendarDay day, boolean animate, boolean setSelected, boolean forceScroll) {
        int selectedPosition = this.getPosition(this.mSelectedDay);
        if (setSelected) {
            this.mSelectedDay.set(day);
        }
        this.mTempDay.set(day);
        int position = this.getPosition(day);
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("GoTo position " + position));
        }
        if (position != selectedPosition || forceScroll) {
            this.setMonthAndYearDisplayed(this.mTempDay);
            if (animate) {
                this.mViewPager.setCurrentItem(position, true);
                if (setSelected) {
                    this.setSelectedDay(this.mSelectedDay);
                }
                return true;
            }
            this.postSetSelection(position, setSelected);
        } else if (setSelected) {
            this.setMonthAndYearDisplayed(this.mSelectedDay);
            this.setSelectedDay(this.mSelectedDay);
        }
        return false;
    }

    private int getPosition(CalendarDay day) {
        return this.mAdapter.getPosition(day);
    }

    public void postSetSelection(final int position, final boolean setSelected) {
        this.clearFocus();
        this.post(new Runnable(){

            @Override
            public void run() {
                PagingDayPickerView.this.mViewPager.setCurrentItem(position, false);
                if (setSelected) {
                    PagingDayPickerView.this.setSelectedDay(PagingDayPickerView.this.mSelectedDay);
                }
            }
        });
    }

    void postSetupCurrentView(final int currentView, final boolean animate) {
        this.post(new Runnable(){

            @Override
            public void run() {
                PagingDayPickerView.this.setupCurrentView(currentView, animate);
            }
        });
    }

    protected void setMonthAndYearDisplayed(CalendarDay date) {
        this.mCurrentMonthDisplayed = date.month;
        this.mCurrentYearDisplayed = date.year;
    }

    private void setSelectedDay(CalendarDay day) {
        this.mAdapter.setSelectedDay(day);
    }

    @Override
    public void onDateChanged() {
        if (this.mCurrentView != 0) {
            this.setCurrentView(0, false);
            this.onPageSelected(this.mViewPager.getCurrentItem());
        }
        this.goTo(this.mController.getSelectedDay(), false, true, true);
    }

    private CalendarDay findAccessibilityFocus() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            CalendarDay focus;
            View child = this.getChildAt(i);
            if (!(child instanceof MonthView) || (focus = ((MonthView)child).getAccessibilityFocus()) == null) continue;
            if (Build.VERSION.SDK_INT == 17) {
                ((MonthView)child).clearAccessibilityFocus();
            }
            return focus;
        }
        return null;
    }

    private boolean restoreAccessibilityFocus(CalendarDay day) {
        if (day == null) {
            return false;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof MonthView) || !((MonthView)child).restoreAccessibilityFocus(day)) continue;
            return true;
        }
        return false;
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setItemCount(-1);
    }

    private static String getMonthAndYearString(CalendarDay day) {
        Calendar cal = Calendar.getInstance();
        cal.set(day.year, day.month, day.day);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(cal.getDisplayName(2, 2, Locale.getDefault()));
        sbuf.append(" ");
        sbuf.append(YEAR_FORMAT.format(cal.getTime()));
        return sbuf.toString();
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.addAction(4096);
        info.addAction(8192);
    }

    @SuppressLint(value={"NewApi"})
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        View firstVisibleView;
        if (action != 4096 && action != 8192) {
            return super.performAccessibilityAction(action, arguments);
        }
        int firstVisiblePosition = this.getPagerPosition();
        int month = firstVisiblePosition % 12;
        int year = firstVisiblePosition / 12 + this.mController.getMinYear();
        CalendarDay day = new CalendarDay(year, month, 1);
        if (action == 4096) {
            ++day.month;
            if (day.month == 12) {
                day.month = 0;
                ++day.year;
            }
        } else if (action == 8192 && (firstVisibleView = this.getChildAt(0)) != null && firstVisibleView.getTop() >= -1) {
            --day.month;
            if (day.month == -1) {
                day.month = 11;
                --day.year;
            }
        }
        Utils.tryAccessibilityAnnounce((View)this, PagingDayPickerView.getMonthAndYearString(day));
        this.goTo(day, true, false, true);
        return true;
    }

    int getPagerPosition() {
        return this.mViewPager.getCurrentItem();
    }

    int getCurrentView() {
        return this.mCurrentView;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        if (this.mCurrentView == 0) {
            this.setTitle(this.mAdapter.getPageTitle(position));
            this.toggleArrowsVisibility(position);
            int month = this.mAdapter.getMonth(position);
            int year = this.mAdapter.getYear(position);
            if (this.mCurrentYearDisplayed != year) {
                this.mCurrentYearDisplayed = year;
            }
            if (this.mCurrentMonthDisplayed != month) {
                this.mCurrentMonthDisplayed = month;
            }
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    private void setTitle(CharSequence title) {
        this.mMonthYearTitleView.setText(title);
    }

    private void toggleArrowsVisibility(int position) {
        this.toggleArrowsVisibility(position > 0, position + 1 < this.mAdapter.getCount());
    }

    private void toggleArrowsVisibility(boolean leftVisible, boolean rightVisible) {
        this.mPreviousButton.setVisibility(leftVisible ? 0 : 4);
        this.mNextButton.setVisibility(rightVisible ? 0 : 4);
    }

    private void setArrowDrawableOnTitle(@NonNull Drawable arrow) {
        if (Utils.checkApiLevel(17)) {
            this.mMonthYearTitleView.setCompoundDrawablesRelativeWithIntrinsicBounds(null, null, arrow, null);
        } else {
            this.mMonthYearTitleView.setCompoundDrawablesWithIntrinsicBounds(null, null, arrow, null);
        }
    }

    private void animateArrow(AnimatedVectorDrawableCompat arrow) {
        this.setArrowDrawableOnTitle((Drawable)arrow);
        arrow.start();
    }

    private void setCurrentView(int viewIndex, boolean animate) {
        switch (viewIndex) {
            case 0: {
                if (this.mCurrentView == viewIndex) break;
                this.mMonthAnimator.setDisplayedChild(0, animate);
                this.animateArrow(this.mArrowUpDrawable);
                this.mCurrentView = viewIndex;
                break;
            }
            case 1: {
                if (this.mCurrentView == viewIndex) break;
                this.prepareMonthPickerForDisplay(this.mCurrentYearDisplayed);
                this.mMonthAnimator.setDisplayedChild(1, animate);
                this.animateArrow(this.mArrowDownDrawable);
                this.mCurrentView = viewIndex;
            }
        }
    }

    private void prepareMonthPickerForDisplay(int currentYear) {
        this.mMonthPickerView.setDisplayParams(this.mSelectedDay, currentYear);
    }

    @Override
    public void onMonthClick(MonthPickerView view, int month, int year) {
        this.setCurrentView(0, true);
        if (month == this.mCurrentMonthDisplayed) {
            this.onPageSelected(this.mViewPager.getCurrentItem());
        }
        this.mController.tryVibrate();
        this.mController.onMonthYearSelected(month, year);
    }

    static {
        YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    }
}

