/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import com.philliphsu.bottomsheetpickers.date.DatePickerController;
import java.util.Calendar;

final class DateRangeHelper {
    private final DatePickerController mController;

    DateRangeHelper(DatePickerController controller) {
        this.mController = controller;
    }

    boolean isOutOfRange(int year, int month, int day) {
        if (this.isBeforeMin(year, month, day)) {
            return true;
        }
        return this.isAfterMax(year, month, day);
    }

    private boolean isBeforeMin(int year, int month, int day) {
        if (this.mController == null) {
            return false;
        }
        Calendar minDate = this.mController.getMinDate();
        if (minDate == null) {
            return false;
        }
        if (year < minDate.get(1)) {
            return true;
        }
        if (year > minDate.get(1)) {
            return false;
        }
        if (month < minDate.get(2)) {
            return true;
        }
        if (month > minDate.get(2)) {
            return false;
        }
        return day < minDate.get(5);
    }

    private boolean isAfterMax(int year, int month, int day) {
        if (this.mController == null) {
            return false;
        }
        Calendar maxDate = this.mController.getMaxDate();
        if (maxDate == null) {
            return false;
        }
        if (year > maxDate.get(1)) {
            return true;
        }
        if (year < maxDate.get(1)) {
            return false;
        }
        if (month > maxDate.get(2)) {
            return true;
        }
        if (month < maxDate.get(2)) {
            return false;
        }
        return day > maxDate.get(5);
    }
}

