/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.AbsListView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.HapticFeedbackController;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.date.AccessibleDateAnimator;
import com.philliphsu.bottomsheetpickers.date.CalendarDay;
import com.philliphsu.bottomsheetpickers.date.DateFormatHelper;
import com.philliphsu.bottomsheetpickers.date.DatePickerController;
import com.philliphsu.bottomsheetpickers.date.DatePickerDialog;
import com.philliphsu.bottomsheetpickers.date.PagingDayPickerView;
import com.philliphsu.bottomsheetpickers.date.YearPickerView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class BottomSheetDatePickerDialog
extends DatePickerDialog
implements View.OnClickListener,
DatePickerController,
View.OnTouchListener,
AbsListView.OnScrollListener {
    private static final String TAG = "DatePickerDialog";
    private static final int UNINITIALIZED = -1;
    private static final int MONTH_AND_DAY_VIEW = 0;
    private static final int YEAR_VIEW = 1;
    private static final String KEY_SELECTED_YEAR = "year";
    private static final String KEY_SELECTED_MONTH = "month";
    private static final String KEY_SELECTED_DAY = "day";
    private static final String KEY_LIST_POSITION = "list_position";
    private static final String KEY_WEEK_START = "week_start";
    private static final String KEY_YEAR_START = "year_start";
    private static final String KEY_YEAR_END = "year_end";
    private static final String KEY_CURRENT_VIEW = "current_view";
    private static final String KEY_LIST_POSITION_OFFSET = "list_position_offset";
    private static final String KEY_DAY_PICKER_CURRENT_INDEX = "day_picker_current_index";
    private static final String KEY_MIN_DATE_MILLIS = "min_date_millis";
    private static final String KEY_MAX_DATE_MILLIS = "max_date_millis";
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int ANIMATION_DURATION = 300;
    private static final int ANIMATION_DELAY = 500;
    private static SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    private static SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("dd", Locale.getDefault());
    private final Calendar mCalendar = Calendar.getInstance();
    private DatePickerDialog.OnDateSetListener mCallBack;
    private HashSet<DatePickerDialog.OnDateChangedListener> mListeners = new HashSet();
    private AccessibleDateAnimator mAnimator;
    private TextView mDayOfWeekView;
    private LinearLayout mMonthDayYearView;
    private TextView mFirstTextView;
    private TextView mSecondTextView;
    private PagingDayPickerView mDayPickerView;
    private YearPickerView mYearPickerView;
    private Button mDoneButton;
    private Button mCancelButton;
    private int mCurrentView = -1;
    private int mWeekStart = this.mCalendar.getFirstDayOfWeek();
    private int mMinYear = 1900;
    private int mMaxYear = 2100;
    @Nullable
    private Calendar mMinDate;
    @Nullable
    private Calendar mMaxDate;
    private HapticFeedbackController mHapticFeedbackController;
    private CalendarDay mSelectedDay;
    private boolean mDelayAnimation = true;
    private String mDayPickerDescription;
    private String mSelectDay;
    private String mYearPickerDescription;
    private String mSelectYear;
    private int mLocaleMonthDayIndex;
    private int mLocaleYearIndex;

    public static BottomSheetDatePickerDialog newInstance(DatePickerDialog.OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        BottomSheetDatePickerDialog ret = new BottomSheetDatePickerDialog();
        ret.initialize(callBack, year, monthOfYear, dayOfMonth);
        return ret;
    }

    public void initialize(DatePickerDialog.OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        this.mCallBack = callBack;
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, monthOfYear);
        this.mCalendar.set(5, dayOfMonth);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FragmentActivity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        if (savedInstanceState != null) {
            this.mCalendar.set(1, savedInstanceState.getInt(KEY_SELECTED_YEAR));
            this.mCalendar.set(2, savedInstanceState.getInt(KEY_SELECTED_MONTH));
            this.mCalendar.set(5, savedInstanceState.getInt(KEY_SELECTED_DAY));
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_SELECTED_YEAR, this.mCalendar.get(1));
        outState.putInt(KEY_SELECTED_MONTH, this.mCalendar.get(2));
        outState.putInt(KEY_SELECTED_DAY, this.mCalendar.get(5));
        outState.putInt(KEY_WEEK_START, this.mWeekStart);
        outState.putInt(KEY_YEAR_START, this.mMinYear);
        outState.putInt(KEY_YEAR_END, this.mMaxYear);
        outState.putInt(KEY_CURRENT_VIEW, this.mCurrentView);
        int listPosition = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getPagerPosition();
            outState.putInt(KEY_DAY_PICKER_CURRENT_INDEX, this.mDayPickerView.getCurrentView());
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            outState.putInt(KEY_LIST_POSITION_OFFSET, this.mYearPickerView.getFirstPositionOffset());
        }
        outState.putInt(KEY_LIST_POSITION, listPosition);
        if (this.mMinDate != null) {
            outState.putLong(KEY_MIN_DATE_MILLIS, this.mMinDate.getTimeInMillis());
        }
        if (this.mMaxDate != null) {
            outState.putLong(KEY_MAX_DATE_MILLIS, this.mMaxDate.getTimeInMillis());
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        this.mDayOfWeekView = (TextView)view.findViewById(R.id.date_picker_header);
        this.mDayOfWeekView.setTypeface(Utils.SANS_SERIF_LIGHT_BOLD);
        this.mMonthDayYearView = (LinearLayout)view.findViewById(R.id.date_picker_month_day_year);
        this.mFirstTextView = (TextView)view.findViewById(R.id.date_picker_first_textview);
        this.mFirstTextView.setOnClickListener((View.OnClickListener)this);
        this.mFirstTextView.setTypeface(Utils.SANS_SERIF_LIGHT_BOLD);
        this.mSecondTextView = (TextView)view.findViewById(R.id.date_picker_second_textview);
        this.mSecondTextView.setOnClickListener((View.OnClickListener)this);
        this.mSecondTextView.setTypeface(Utils.SANS_SERIF_LIGHT_BOLD);
        int listPosition = -1;
        int listPositionOffset = 0;
        int currentView = 0;
        int dayPickerCurrentView = 0;
        if (savedInstanceState != null) {
            this.mWeekStart = savedInstanceState.getInt(KEY_WEEK_START);
            this.mMinYear = savedInstanceState.getInt(KEY_YEAR_START);
            this.mMaxYear = savedInstanceState.getInt(KEY_YEAR_END);
            currentView = savedInstanceState.getInt(KEY_CURRENT_VIEW);
            listPosition = savedInstanceState.getInt(KEY_LIST_POSITION);
            listPositionOffset = savedInstanceState.getInt(KEY_LIST_POSITION_OFFSET);
            dayPickerCurrentView = savedInstanceState.getInt(KEY_DAY_PICKER_CURRENT_INDEX);
            if (savedInstanceState.containsKey(KEY_MIN_DATE_MILLIS)) {
                this.mMinDate = Calendar.getInstance();
                this.mMinDate.setTimeInMillis(savedInstanceState.getLong(KEY_MIN_DATE_MILLIS));
            }
            if (savedInstanceState.containsKey(KEY_MAX_DATE_MILLIS)) {
                this.mMaxDate = Calendar.getInstance();
                this.mMaxDate.setTimeInMillis(savedInstanceState.getLong(KEY_MAX_DATE_MILLIS));
            }
        }
        FragmentActivity activity = this.getActivity();
        this.mDayPickerView = new PagingDayPickerView((Context)activity, this, this.mThemeDark);
        this.mYearPickerView = new YearPickerView((Context)activity, this);
        this.mYearPickerView.setTheme((Context)activity, this.mThemeDark);
        view.setOnTouchListener((View.OnTouchListener)this);
        this.mYearPickerView.setOnTouchListener(this);
        this.mYearPickerView.setOnScrollListener(this);
        Resources res = this.getResources();
        this.mDayPickerDescription = res.getString(R.string.day_picker_description);
        this.mSelectDay = res.getString(R.string.select_day);
        this.mYearPickerDescription = res.getString(R.string.year_picker_description);
        this.mSelectYear = res.getString(R.string.select_year);
        this.mAnimator = (AccessibleDateAnimator)view.findViewById(R.id.animator);
        this.mAnimator.addView((View)this.mDayPickerView);
        this.mAnimator.addView((View)this.mYearPickerView);
        this.mAnimator.setDateMillis(this.mCalendar.getTimeInMillis());
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)animation);
        AlphaAnimation animation2 = new AlphaAnimation(1.0f, 0.0f);
        animation2.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)animation2);
        this.mDoneButton = (Button)view.findViewById(R.id.done);
        this.mDoneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BottomSheetDatePickerDialog.this.tryVibrate();
                if (BottomSheetDatePickerDialog.this.mCallBack != null) {
                    BottomSheetDatePickerDialog.this.mCallBack.onDateSet(BottomSheetDatePickerDialog.this, BottomSheetDatePickerDialog.this.mCalendar.get(1), BottomSheetDatePickerDialog.this.mCalendar.get(2), BottomSheetDatePickerDialog.this.mCalendar.get(5));
                }
                BottomSheetDatePickerDialog.this.dismiss();
            }
        });
        this.mCancelButton = (Button)view.findViewById(R.id.cancel);
        this.mCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BottomSheetDatePickerDialog.this.dismiss();
            }
        });
        this.mCancelButton.setTextColor(this.mAccentColor);
        this.mDoneButton.setTextColor(this.mAccentColor);
        if (this.mThemeDark) {
            view.setBackgroundColor(this.mDarkGray);
            this.mAnimator.setBackgroundColor(this.mDarkGray);
            int selectableItemBg = ContextCompat.getColor((Context)activity, (int)R.color.selectable_item_background_dark);
            Utils.setColorControlHighlight((View)this.mCancelButton, selectableItemBg);
            Utils.setColorControlHighlight((View)this.mDoneButton, selectableItemBg);
        }
        View selectedDateLayout = view.findViewById(R.id.day_picker_selected_date_layout);
        selectedDateLayout.setBackgroundColor(this.mThemeDark ? this.mLightGray : this.mAccentColor);
        this.determineLocale_MD_Y_Indices();
        this.updateDisplay(false);
        this.setCurrentView(currentView);
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.postSetSelection(listPosition, false);
            } else if (currentView == 1) {
                this.mYearPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            }
        }
        this.mDayPickerView.postSetupCurrentView(dayPickerCurrentView, false);
        this.mHapticFeedbackController = new HapticFeedbackController((Context)activity);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.mHapticFeedbackController.start();
    }

    public void onPause() {
        super.onPause();
        this.mHapticFeedbackController.stop();
    }

    private void setCurrentView(int viewIndex) {
        long millis = this.mCalendar.getTimeInMillis();
        switch (viewIndex) {
            case 0: {
                this.mDayPickerView.onDateChanged();
                this.setCancelable(true);
                if (this.mCurrentView != viewIndex) {
                    this.updateHeaderSelectedView(0);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = viewIndex;
                }
                String dayString = DateFormatHelper.formatDate(this.mCalendar, 16);
                this.mAnimator.setContentDescription(this.mDayPickerDescription + ": " + dayString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectDay);
                break;
            }
            case 1: {
                this.mYearPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.updateHeaderSelectedView(1);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                }
                String yearString = YEAR_FORMAT.format(millis);
                this.mAnimator.setContentDescription(this.mYearPickerDescription + ": " + yearString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectYear);
            }
        }
    }

    private void updateHeaderSelectedView(int viewIndex) {
        switch (viewIndex) {
            case 0: {
                this.mFirstTextView.setSelected(this.mLocaleMonthDayIndex == 0);
                this.mSecondTextView.setSelected(this.mLocaleMonthDayIndex != 0);
                break;
            }
            case 1: {
                this.mFirstTextView.setSelected(this.mLocaleYearIndex == 0);
                this.mSecondTextView.setSelected(this.mLocaleYearIndex != 0);
            }
        }
    }

    private void determineLocale_MD_Y_Indices() {
        String formattedDate = BottomSheetDatePickerDialog.formatMonthDayYear(this.mCalendar);
        String monthAndDay = BottomSheetDatePickerDialog.formatMonthAndDay(this.mCalendar);
        String year = this.extractYearFromFormattedDate(formattedDate, monthAndDay);
        if (formattedDate.indexOf(monthAndDay) < formattedDate.indexOf(year)) {
            this.mLocaleMonthDayIndex = 0;
            this.mLocaleYearIndex = 1;
        } else {
            this.mLocaleYearIndex = 0;
            this.mLocaleMonthDayIndex = 1;
        }
    }

    private static String formatMonthDayYear(Calendar calendar) {
        int flags = 65556;
        return DateFormatHelper.formatDate(calendar, flags);
    }

    private static String formatMonthAndDay(Calendar calendar) {
        int flags = 65560;
        return DateFormatHelper.formatDate(calendar, flags);
    }

    private String extractYearFromFormattedDate(String formattedDate, String monthAndDay) {
        String[] parts;
        for (String part : parts = formattedDate.split(monthAndDay)) {
            if (part.isEmpty()) continue;
            return part;
        }
        return YEAR_FORMAT.format(this.mCalendar.getTime());
    }

    private void updateDisplay(boolean announce) {
        if (this.mDayOfWeekView != null) {
            this.mDayOfWeekView.setText((CharSequence)this.mCalendar.getDisplayName(7, 2, Locale.getDefault()));
        }
        String fullDate = BottomSheetDatePickerDialog.formatMonthDayYear(this.mCalendar);
        String monthAndDay = BottomSheetDatePickerDialog.formatMonthAndDay(this.mCalendar);
        String year = YEAR_FORMAT.format(this.mCalendar.getTime());
        int yearStart = fullDate.indexOf(year);
        int yearEnd = yearStart + year.length();
        int monthDayStart = fullDate.indexOf(monthAndDay);
        int monthDayEnd = monthDayStart + monthAndDay.length();
        boolean processed = false;
        if (monthDayStart != -1 && yearStart != -1) {
            if (this.mLocaleMonthDayIndex < this.mLocaleYearIndex) {
                if (yearStart - monthDayEnd <= 2) {
                    monthAndDay = fullDate.substring(monthDayStart, yearStart);
                    year = fullDate.substring(yearStart, fullDate.length());
                    processed = true;
                }
            } else if (monthDayStart - yearEnd <= 2) {
                year = fullDate.substring(yearStart, monthDayStart);
                monthAndDay = fullDate.substring(monthDayStart, fullDate.length());
                processed = true;
            }
        } else {
            if (yearStart > 0) {
                monthAndDay = fullDate.substring(0, yearStart);
                year = fullDate.substring(yearStart, fullDate.length());
                this.mLocaleMonthDayIndex = 0;
                this.mLocaleYearIndex = 1;
            } else {
                year = fullDate.substring(0, yearEnd);
                monthAndDay = fullDate.substring(yearEnd, fullDate.length());
                this.mLocaleYearIndex = 0;
                this.mLocaleMonthDayIndex = 1;
            }
            processed = true;
        }
        if (!processed) {
            year = this.extractYearFromFormattedDate(fullDate, monthAndDay);
        }
        this.mFirstTextView.setText((CharSequence)(this.mLocaleMonthDayIndex == 0 ? monthAndDay : year));
        this.mSecondTextView.setText((CharSequence)(this.mLocaleMonthDayIndex == 0 ? year : monthAndDay));
        long millis = this.mCalendar.getTimeInMillis();
        this.mAnimator.setDateMillis(millis);
        int flags = 24;
        String monthAndDayText = DateFormatHelper.formatDate(millis, flags);
        this.mMonthDayYearView.setContentDescription((CharSequence)monthAndDayText);
        if (announce) {
            flags = 20;
            String fullDateText = DateFormatHelper.formatDate(millis, flags);
            Utils.tryAccessibilityAnnounce((View)this.mAnimator, fullDateText);
        }
    }

    public void setFirstDayOfWeek(int startOfWeek) {
        if (startOfWeek < 1 || startOfWeek > 7) {
            throw new IllegalArgumentException("Value must be between Calendar.SUNDAY and Calendar.SATURDAY");
        }
        this.mWeekStart = startOfWeek;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setYearRange(int startYear, int endYear) {
        if (endYear <= startYear) {
            throw new IllegalArgumentException("Year end must be larger than year start");
        }
        this.mMinYear = startYear;
        this.mMaxYear = endYear;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setMinDate(Calendar calendar) {
        this.mMinDate = calendar;
        this.setYearRange(calendar.get(1), this.mMaxYear);
    }

    @Override
    @Nullable
    public Calendar getMinDate() {
        return this.mMinDate;
    }

    public void setMaxDate(Calendar calendar) {
        this.mMaxDate = calendar;
        this.setYearRange(this.mMinYear, calendar.get(1));
    }

    @Override
    @Nullable
    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    public void setOnDateSetListener(DatePickerDialog.OnDateSetListener listener) {
        this.mCallBack = listener;
    }

    private void adjustDayInMonthIfNeeded(int month, int year) {
        int daysInMonth;
        int day = this.mCalendar.get(5);
        if (day > (daysInMonth = Utils.getDaysInMonth(month, year))) {
            this.mCalendar.set(5, daysInMonth);
        }
    }

    public void onClick(View v) {
        this.tryVibrate();
        if (v.getId() == R.id.date_picker_second_textview) {
            this.setCurrentView(this.mLocaleMonthDayIndex == 0 ? 1 : 0);
        } else if (v.getId() == R.id.date_picker_first_textview) {
            this.setCurrentView(this.mLocaleMonthDayIndex == 0 ? 0 : 1);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mCurrentView == 1 && v == this.mYearPickerView && event.getY() >= (float)this.mYearPickerView.getTop() && event.getY() <= (float)this.mYearPickerView.getBottom()) {
            this.setCancelable(false);
            return this.mYearPickerView.onTouchEvent(event);
        }
        this.setCancelable(true);
        return false;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.setCancelable(scrollState == 0);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
    }

    @Override
    public void onYearSelected(int year) {
        this.adjustDayInMonthIfNeeded(this.mCalendar.get(2), year);
        this.mCalendar.set(1, year);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    @Override
    public void onDayOfMonthSelected(int year, int month, int day) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.updatePickers();
        this.updateDisplay(true);
    }

    @Override
    public void onMonthYearSelected(int month, int year) {
        this.adjustDayInMonthIfNeeded(month, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(1, year);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    private void updatePickers() {
        Iterator<DatePickerDialog.OnDateChangedListener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onDateChanged();
        }
    }

    @Override
    public CalendarDay getSelectedDay() {
        if (this.mSelectedDay == null) {
            this.mSelectedDay = new CalendarDay(this.mCalendar);
        } else {
            this.mSelectedDay.setDay(this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5));
        }
        return this.mSelectedDay;
    }

    @Override
    public int getMinYear() {
        return this.mMinYear;
    }

    @Override
    public int getMaxYear() {
        return this.mMaxYear;
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.mWeekStart;
    }

    @Override
    public void registerOnDateChangedListener(DatePickerDialog.OnDateChangedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void unregisterOnDateChangedListener(DatePickerDialog.OnDateChangedListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void tryVibrate() {
        this.mHapticFeedbackController.tryVibrate();
    }

    @Override
    protected int contentLayout() {
        return R.layout.date_picker_dialog;
    }
}

