/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.philliphsu.bottomsheetpickers.CustomWidthBottomSheetDialog;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;

public abstract class BottomSheetPickerDialog
extends BottomSheetDialogFragment {
    protected static final String KEY_DARK_THEME = "dark_theme";
    protected static final String KEY_THEME_SET_AT_RUNTIME = "theme_set_at_runtime";
    protected boolean mThemeDark;
    protected boolean mThemeSetAtRuntime;
    protected int mDarkGray;
    protected int mLightGray;
    protected int mAccentColor;

    @LayoutRes
    protected abstract int contentLayout();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mThemeDark = savedInstanceState.getBoolean(KEY_DARK_THEME);
            this.mThemeSetAtRuntime = savedInstanceState.getBoolean(KEY_THEME_SET_AT_RUNTIME);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (!this.mThemeSetAtRuntime) {
            this.mThemeDark = Utils.isDarkTheme((Context)this.getActivity(), this.mThemeDark);
        }
        FragmentActivity ctx = this.getActivity();
        this.mDarkGray = ContextCompat.getColor((Context)ctx, (int)R.color.dark_gray);
        this.mLightGray = ContextCompat.getColor((Context)ctx, (int)R.color.light_gray);
        this.mAccentColor = Utils.getThemeAccentColor((Context)this.getActivity());
        return inflater.inflate(this.contentLayout(), container, false);
    }

    @NonNull
    public final Dialog onCreateDialog(Bundle savedInstanceState) {
        return new CustomWidthBottomSheetDialog(this.getContext(), R.style.BottomSheetDialogTheme);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_DARK_THEME, this.mThemeDark);
        outState.putBoolean(KEY_THEME_SET_AT_RUNTIME, this.mThemeSetAtRuntime);
    }

    public void setThemeDark(boolean dark) {
        this.mThemeDark = dark;
        this.mThemeSetAtRuntime = true;
    }

    public boolean isThemeDark() {
        return this.mThemeDark;
    }
}

