/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.grid;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.time.BottomSheetTimePickerDialog;
import com.philliphsu.bottomsheetpickers.time.grid.GridPickerLayout;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;

public class GridTimePickerDialog
extends BottomSheetTimePickerDialog
implements GridPickerLayout.OnValueSelectedListener {
    private static final String TAG = "TimePickerDialog";
    private static final String KEY_HOUR_OF_DAY = "hour_of_day";
    private static final String KEY_MINUTE = "minute";
    private static final String KEY_IS_24_HOUR_VIEW = "is_24_hour_view";
    private static final String KEY_CURRENT_ITEM_SHOWING = "current_item_showing";
    private static final String KEY_IN_KB_MODE = "in_kb_mode";
    private static final String KEY_TYPED_TIMES = "typed_times";
    private static final String KEY_DARK_THEME = "dark_theme";
    private static final String KEY_THEME_SET_AT_RUNTIME = "theme_set_at_runtime";
    public static final int HOUR_INDEX = 0;
    public static final int MINUTE_INDEX = 1;
    public static final int HALF_DAY_INDEX = 2;
    public static final int ENABLE_PICKER_INDEX = 3;
    public static final int HALF_DAY_1 = 0;
    public static final int HALF_DAY_2 = 1;
    private TextView mHourView;
    private TextView mHourSpaceView;
    private TextView mMinuteView;
    private TextView mMinuteSpaceView;
    private TextView mAmPmTextView;
    private View mAmPmHitspace;
    private GridPickerLayout mTimePicker;
    private int mSelectedColor;
    private int mUnselectedColor;
    private String mAmText;
    private String mPmText;
    private boolean mAllowAutoAdvance;
    private int mInitialHourOfDay;
    private int mInitialMinute;
    private boolean mIs24HourMode;
    private boolean mThemeDark;
    private boolean mThemeSetAtRuntime;
    private char mPlaceholderText;
    private String mDoublePlaceholderText;
    private String mDeletedKeyFormat;
    private boolean mInKbMode;
    private ArrayList<Integer> mTypedTimes;
    private Node mLegalTimesTree;
    private int mAmKeyCode;
    private int mPmKeyCode;
    private String mHourPickerDescription;
    private String mSelectHours;
    private String mMinutePickerDescription;
    private String mSelectMinutes;
    private int mHalfDayToggleSelectedColor;
    private int mHalfDayToggleUnselectedColor;
    private FloatingActionButton mDoneButton;
    private Button mFirstHalfDayToggle;
    private Button mSecondHalfDayToggle;

    @Override
    protected int contentLayout() {
        return R.layout.dialog_time_picker_grid;
    }

    public static GridTimePickerDialog newInstance(BottomSheetTimePickerDialog.OnTimeSetListener callback, int hourOfDay, int minute, boolean is24HourMode) {
        GridTimePickerDialog ret = new GridTimePickerDialog();
        ret.initialize(callback, hourOfDay, minute, is24HourMode);
        return ret;
    }

    public void initialize(BottomSheetTimePickerDialog.OnTimeSetListener callback, int hourOfDay, int minute, boolean is24HourMode) {
        this.setOnTimeSetListener(callback);
        this.mInitialHourOfDay = hourOfDay;
        this.mInitialMinute = minute;
        this.mIs24HourMode = is24HourMode;
        this.mInKbMode = false;
        this.mThemeDark = false;
        this.mThemeSetAtRuntime = false;
    }

    @Override
    public void setThemeDark(boolean dark) {
        this.mThemeDark = dark;
        this.mThemeSetAtRuntime = true;
    }

    @Override
    public boolean isThemeDark() {
        return this.mThemeDark;
    }

    public void setStartTime(int hourOfDay, int minute) {
        this.mInitialHourOfDay = hourOfDay;
        this.mInitialMinute = minute;
        this.mInKbMode = false;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null && savedInstanceState.containsKey(KEY_HOUR_OF_DAY) && savedInstanceState.containsKey(KEY_MINUTE) && savedInstanceState.containsKey(KEY_IS_24_HOUR_VIEW)) {
            this.mInitialHourOfDay = savedInstanceState.getInt(KEY_HOUR_OF_DAY);
            this.mInitialMinute = savedInstanceState.getInt(KEY_MINUTE);
            this.mIs24HourMode = savedInstanceState.getBoolean(KEY_IS_24_HOUR_VIEW);
            this.mInKbMode = savedInstanceState.getBoolean(KEY_IN_KB_MODE);
            this.mThemeDark = savedInstanceState.getBoolean(KEY_DARK_THEME);
            this.mThemeSetAtRuntime = savedInstanceState.getBoolean(KEY_THEME_SET_AT_RUNTIME);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        KeyboardListener keyboardListener = new KeyboardListener();
        view.findViewById(R.id.time_picker_dialog).setOnKeyListener((View.OnKeyListener)keyboardListener);
        if (!this.mThemeSetAtRuntime) {
            this.mThemeDark = Utils.isDarkTheme((Context)this.getActivity(), this.mThemeDark);
        }
        Resources res = this.getResources();
        FragmentActivity ctx = this.getActivity();
        this.mHourPickerDescription = res.getString(R.string.hour_picker_description);
        this.mSelectHours = res.getString(R.string.select_hours);
        this.mMinutePickerDescription = res.getString(R.string.minute_picker_description);
        this.mSelectMinutes = res.getString(R.string.select_minutes);
        this.mSelectedColor = ContextCompat.getColor((Context)ctx, (int)17170443);
        this.mUnselectedColor = ContextCompat.getColor((Context)ctx, (int)R.color.unselected_color);
        this.mHourView = (TextView)view.findViewById(R.id.hours);
        this.mHourView.setOnKeyListener((View.OnKeyListener)keyboardListener);
        this.mHourSpaceView = (TextView)view.findViewById(R.id.hour_space);
        this.mMinuteSpaceView = (TextView)view.findViewById(R.id.minutes_space);
        this.mMinuteView = (TextView)view.findViewById(R.id.minutes);
        this.mMinuteView.setOnKeyListener((View.OnKeyListener)keyboardListener);
        this.mAmPmTextView = (TextView)view.findViewById(R.id.ampm_label);
        this.mAmPmTextView.setOnKeyListener((View.OnKeyListener)keyboardListener);
        String[] amPmTexts = new DateFormatSymbols().getAmPmStrings();
        this.mAmText = amPmTexts[0];
        this.mPmText = amPmTexts[1];
        this.mTimePicker = (GridPickerLayout)view.findViewById(R.id.time_picker);
        this.mTimePicker.setOnValueSelectedListener(this);
        this.mTimePicker.setOnKeyListener(keyboardListener);
        this.mTimePicker.initialize((Context)this.getActivity(), this.mInitialHourOfDay, this.mInitialMinute, this.mIs24HourMode);
        int currentItemShowing = 0;
        if (savedInstanceState != null && savedInstanceState.containsKey(KEY_CURRENT_ITEM_SHOWING)) {
            currentItemShowing = savedInstanceState.getInt(KEY_CURRENT_ITEM_SHOWING);
        }
        this.setCurrentItemShowing(currentItemShowing, false, true, true);
        this.mTimePicker.invalidate();
        this.mHourView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GridTimePickerDialog.this.setCurrentItemShowing(0, true, false, true);
                GridTimePickerDialog.this.tryVibrate();
            }
        });
        this.mMinuteView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GridTimePickerDialog.this.setCurrentItemShowing(1, true, false, true);
                GridTimePickerDialog.this.tryVibrate();
            }
        });
        this.mDoneButton = (FloatingActionButton)view.findViewById(R.id.fab);
        this.mDoneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GridTimePickerDialog.this.mInKbMode && GridTimePickerDialog.this.isTypedTimeFullyLegal()) {
                    GridTimePickerDialog.this.finishKbMode(false);
                } else {
                    GridTimePickerDialog.this.tryVibrate();
                }
                GridTimePickerDialog.this.onTimeSet((ViewGroup)GridTimePickerDialog.this.mTimePicker, GridTimePickerDialog.this.mTimePicker.getHours(), GridTimePickerDialog.this.mTimePicker.getMinutes());
            }
        });
        this.mDoneButton.setOnKeyListener((View.OnKeyListener)keyboardListener);
        this.mFirstHalfDayToggle = (Button)view.findViewById(R.id.half_day_toggle_1);
        this.mFirstHalfDayToggle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GridTimePickerDialog.this.tryToggleHalfDay(0);
            }
        });
        this.mSecondHalfDayToggle = (Button)view.findViewById(R.id.half_day_toggle_2);
        this.mSecondHalfDayToggle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GridTimePickerDialog.this.tryToggleHalfDay(1);
            }
        });
        this.mAmPmHitspace = view.findViewById(R.id.ampm_hitspace);
        if (this.mIs24HourMode) {
            this.mAmPmTextView.setVisibility(8);
            RelativeLayout.LayoutParams paramsSeparator = new RelativeLayout.LayoutParams(-2, -2);
            paramsSeparator.addRule(13);
            TextView separatorView = (TextView)view.findViewById(R.id.separator);
            separatorView.setLayoutParams((ViewGroup.LayoutParams)paramsSeparator);
            this.mFirstHalfDayToggle.setText(R.string.hours_00_11);
            this.mSecondHalfDayToggle.setText(R.string.hours_12_23);
            int iconRes1 = this.mThemeDark ? R.drawable.ic_half_day_1_dark_24dp : R.drawable.ic_half_day_1_24dp;
            int iconRes2 = this.mThemeDark ? R.drawable.ic_half_day_2_dark_24dp : R.drawable.ic_half_day_2_24dp;
            VectorDrawableCompat icon1 = VectorDrawableCompat.create((Resources)res, (int)iconRes1, (Resources.Theme)ctx.getTheme());
            VectorDrawableCompat icon2 = VectorDrawableCompat.create((Resources)res, (int)iconRes2, (Resources.Theme)ctx.getTheme());
            if (Utils.checkApiLevel(17)) {
                this.mFirstHalfDayToggle.setCompoundDrawablesRelativeWithIntrinsicBounds(null, (Drawable)icon1, null, null);
                this.mSecondHalfDayToggle.setCompoundDrawablesRelativeWithIntrinsicBounds(null, (Drawable)icon2, null, null);
            } else {
                this.mFirstHalfDayToggle.setCompoundDrawablesWithIntrinsicBounds(null, (Drawable)icon1, null, null);
                this.mSecondHalfDayToggle.setCompoundDrawablesWithIntrinsicBounds(null, (Drawable)icon2, null, null);
            }
            if (res.getConfiguration().smallestScreenWidthDp >= 600) {
                this.mFirstHalfDayToggle.setTextSize(0.5f * this.mFirstHalfDayToggle.getTextSize());
                this.mSecondHalfDayToggle.setTextSize(0.5f * this.mSecondHalfDayToggle.getTextSize());
            }
        } else {
            this.mAmPmTextView.setVisibility(0);
            this.mAmPmHitspace.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GridTimePickerDialog.this.tryVibrate();
                    int amOrPm = GridTimePickerDialog.this.mTimePicker.getIsCurrentlyAmOrPm();
                    if (amOrPm == 0) {
                        amOrPm = 1;
                    } else if (amOrPm == 1) {
                        amOrPm = 0;
                    }
                    GridTimePickerDialog.this.updateHalfDay(amOrPm);
                    GridTimePickerDialog.this.mTimePicker.setHalfDay(amOrPm);
                }
            });
            this.mFirstHalfDayToggle.setText((CharSequence)this.mAmText);
            this.mSecondHalfDayToggle.setText((CharSequence)this.mPmText);
        }
        this.mAllowAutoAdvance = true;
        this.setHour(this.mInitialHourOfDay, true);
        this.setMinute(this.mInitialMinute);
        this.mDoublePlaceholderText = res.getString(R.string.time_placeholder);
        this.mDeletedKeyFormat = res.getString(R.string.deleted_key);
        this.mPlaceholderText = this.mDoublePlaceholderText.charAt(0);
        this.mPmKeyCode = -1;
        this.mAmKeyCode = -1;
        this.generateLegalTimesTree();
        if (this.mInKbMode) {
            this.mTypedTimes = savedInstanceState.getIntegerArrayList(KEY_TYPED_TIMES);
            this.tryStartingKbMode(-1);
            this.mHourView.invalidate();
        } else if (this.mTypedTimes == null) {
            this.mTypedTimes = new ArrayList();
        }
        this.mTimePicker.setTheme(this.getActivity().getApplicationContext(), this.mThemeDark);
        int white = ContextCompat.getColor((Context)ctx, (int)17170443);
        int darkGray = ContextCompat.getColor((Context)ctx, (int)R.color.dark_gray);
        int lightGray = ContextCompat.getColor((Context)ctx, (int)R.color.light_gray);
        int accentColor = Utils.getThemeAccentColor((Context)this.getActivity());
        int sidebarDark = ContextCompat.getColor((Context)ctx, (int)R.color.sidebar_color_dark);
        int sidebarLight = ContextCompat.getColor((Context)ctx, (int)R.color.sidebar_color_light);
        view.setBackgroundColor(this.mThemeDark ? darkGray : white);
        view.findViewById(R.id.time_display_background).setBackgroundColor(this.mThemeDark ? lightGray : accentColor);
        view.findViewById(R.id.time_display).setBackgroundColor(this.mThemeDark ? lightGray : accentColor);
        ((TextView)view.findViewById(R.id.separator)).setTextColor(this.mUnselectedColor);
        ((TextView)view.findViewById(R.id.ampm_label)).setTextColor(this.mUnselectedColor);
        view.findViewById(R.id.sidebar).setBackgroundColor(this.mThemeDark ? sidebarDark : sidebarLight);
        this.mDoneButton.setBackgroundTintList(ColorStateList.valueOf((int)accentColor));
        this.mHalfDayToggleSelectedColor = accentColor;
        this.mHalfDayToggleUnselectedColor = ContextCompat.getColor((Context)ctx, (int)(this.mThemeDark ? R.color.text_color_primary_dark : R.color.text_color_primary_light));
        Utils.setColorControlHighlight((View)this.mFirstHalfDayToggle, accentColor);
        Utils.setColorControlHighlight((View)this.mSecondHalfDayToggle, accentColor);
        this.updateHalfDay(this.mInitialHourOfDay < 12 ? 0 : 1);
        return view;
    }

    public void onResume() {
        super.onResume();
    }

    public void onPause() {
        super.onPause();
    }

    public void tryVibrate() {
    }

    private void tryToggleHalfDay(int halfDay) {
        if (halfDay != this.mTimePicker.getIsCurrentlyAmOrPm()) {
            this.updateHalfDay(halfDay);
            this.mTimePicker.setHalfDay(halfDay);
        }
    }

    private void updateHalfDay(int halfDay) {
        this.updateAmPmDisplay(halfDay);
        this.updateHalfDayTogglesState(halfDay);
    }

    private void updateAmPmDisplay(int amOrPm) {
        if (amOrPm == 0) {
            this.mAmPmTextView.setText((CharSequence)this.mAmText);
            Utils.tryAccessibilityAnnounce((View)this.mTimePicker, this.mAmText);
            this.mAmPmHitspace.setContentDescription((CharSequence)this.mAmText);
        } else if (amOrPm == 1) {
            this.mAmPmTextView.setText((CharSequence)this.mPmText);
            Utils.tryAccessibilityAnnounce((View)this.mTimePicker, this.mPmText);
            this.mAmPmHitspace.setContentDescription((CharSequence)this.mPmText);
        } else {
            this.mAmPmTextView.setText((CharSequence)this.mDoublePlaceholderText);
        }
    }

    private void updateHalfDayTogglesState(int halfDay) {
        switch (halfDay) {
            case 0: {
                this.mFirstHalfDayToggle.setTextColor(this.mHalfDayToggleSelectedColor);
                this.mFirstHalfDayToggle.setTypeface(Utils.SANS_SERIF_LIGHT_BOLD);
                this.mSecondHalfDayToggle.setTextColor(this.mHalfDayToggleUnselectedColor);
                this.mSecondHalfDayToggle.setTypeface(Typeface.DEFAULT);
                break;
            }
            case 1: {
                this.mSecondHalfDayToggle.setTextColor(this.mHalfDayToggleSelectedColor);
                this.mSecondHalfDayToggle.setTypeface(Utils.SANS_SERIF_LIGHT_BOLD);
                this.mFirstHalfDayToggle.setTextColor(this.mHalfDayToggleUnselectedColor);
                this.mFirstHalfDayToggle.setTypeface(Typeface.DEFAULT);
            }
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        if (this.mTimePicker != null) {
            outState.putInt(KEY_HOUR_OF_DAY, this.mTimePicker.getHours());
            outState.putInt(KEY_MINUTE, this.mTimePicker.getMinutes());
            outState.putBoolean(KEY_IS_24_HOUR_VIEW, this.mIs24HourMode);
            outState.putInt(KEY_CURRENT_ITEM_SHOWING, this.mTimePicker.getCurrentItemShowing());
            outState.putBoolean(KEY_IN_KB_MODE, this.mInKbMode);
            if (this.mInKbMode) {
                outState.putIntegerArrayList(KEY_TYPED_TIMES, this.mTypedTimes);
            }
            outState.putBoolean(KEY_DARK_THEME, this.mThemeDark);
            outState.putBoolean(KEY_THEME_SET_AT_RUNTIME, this.mThemeSetAtRuntime);
        }
    }

    @Override
    public void onValueSelected(int pickerIndex, int newValue, boolean autoAdvance) {
        if (pickerIndex == 0) {
            this.setHour(newValue, false);
            String announcement = String.format("%d", newValue);
            if (this.mAllowAutoAdvance && autoAdvance) {
                this.setCurrentItemShowing(1, true, true, false);
                announcement = announcement + ". " + this.mSelectMinutes;
            } else {
                this.mTimePicker.setContentDescription(this.mHourPickerDescription + ": " + newValue);
            }
            Utils.tryAccessibilityAnnounce((View)this.mTimePicker, announcement);
        } else if (pickerIndex == 1) {
            this.setMinute(newValue);
            this.mTimePicker.setContentDescription(this.mMinutePickerDescription + ": " + newValue);
        } else if (pickerIndex == 2) {
            this.updateHalfDay(newValue);
        } else if (pickerIndex == 3) {
            if (!this.isTypedTimeFullyLegal()) {
                this.mTypedTimes.clear();
            }
            this.finishKbMode(true);
        }
    }

    private void setHour(int value, boolean announce) {
        String format;
        if (this.mIs24HourMode) {
            format = "%02d";
        } else {
            format = "%d";
            if ((value %= 12) == 0) {
                value = 12;
            }
        }
        String text = String.format(format, value);
        this.mHourView.setText((CharSequence)text);
        this.mHourSpaceView.setText((CharSequence)text);
        if (announce) {
            Utils.tryAccessibilityAnnounce((View)this.mTimePicker, text);
        }
    }

    private void setMinute(int value) {
        if (value == 60) {
            value = 0;
        }
        String text = String.format(Locale.getDefault(), "%02d", value);
        Utils.tryAccessibilityAnnounce((View)this.mTimePicker, text);
        this.mMinuteView.setText((CharSequence)text);
        this.mMinuteSpaceView.setText((CharSequence)text);
    }

    private void setCurrentItemShowing(int index, boolean animateCircle, boolean delayLabelAnimate, boolean announce) {
        this.mTimePicker.setCurrentItemShowing(index, animateCircle);
        if (index == 0) {
            int hours = this.mTimePicker.getHours();
            if (!this.mIs24HourMode) {
                hours %= 12;
            }
            this.mTimePicker.setContentDescription(this.mHourPickerDescription + ": " + hours);
            if (announce) {
                Utils.tryAccessibilityAnnounce((View)this.mTimePicker, this.mSelectHours);
            }
        } else {
            int minutes = this.mTimePicker.getMinutes();
            this.mTimePicker.setContentDescription(this.mMinutePickerDescription + ": " + minutes);
            if (announce) {
                Utils.tryAccessibilityAnnounce((View)this.mTimePicker, this.mSelectMinutes);
            }
        }
        int hourColor = index == 0 ? this.mSelectedColor : this.mUnselectedColor;
        int minuteColor = index == 1 ? this.mSelectedColor : this.mUnselectedColor;
        this.mHourView.setTextColor(hourColor);
        this.mMinuteView.setTextColor(minuteColor);
    }

    private boolean processKeyUp(int keyCode) {
        if (keyCode == 111 || keyCode == 4) {
            this.dismiss();
            return true;
        }
        if (keyCode == 61) {
            if (this.mInKbMode) {
                if (this.isTypedTimeFullyLegal()) {
                    this.finishKbMode(true);
                }
                return true;
            }
        } else {
            if (keyCode == 66) {
                if (this.mInKbMode) {
                    if (!this.isTypedTimeFullyLegal()) {
                        return true;
                    }
                    this.finishKbMode(false);
                }
                this.onTimeSet((ViewGroup)this.mTimePicker, this.mTimePicker.getHours(), this.mTimePicker.getMinutes());
                return true;
            }
            if (keyCode == 67) {
                if (this.mInKbMode && !this.mTypedTimes.isEmpty()) {
                    int deleted = this.deleteLastTypedKey();
                    String deletedKeyStr = deleted == this.getAmOrPmKeyCode(0) ? this.mAmText : (deleted == this.getAmOrPmKeyCode(1) ? this.mPmText : String.format("%d", GridTimePickerDialog.getValFromKeyCode(deleted)));
                    Utils.tryAccessibilityAnnounce((View)this.mTimePicker, String.format(this.mDeletedKeyFormat, deletedKeyStr));
                    this.updateDisplay(true);
                }
            } else if (keyCode == 7 || keyCode == 8 || keyCode == 9 || keyCode == 10 || keyCode == 11 || keyCode == 12 || keyCode == 13 || keyCode == 14 || keyCode == 15 || keyCode == 16 || !this.mIs24HourMode && (keyCode == this.getAmOrPmKeyCode(0) || keyCode == this.getAmOrPmKeyCode(1))) {
                if (!this.mInKbMode) {
                    if (this.mTimePicker == null) {
                        Log.e((String)TAG, (String)"Unable to initiate keyboard mode, TimePicker was null.");
                        return true;
                    }
                    this.mTypedTimes.clear();
                    this.tryStartingKbMode(keyCode);
                    return true;
                }
                if (this.addKeyIfLegal(keyCode)) {
                    this.updateDisplay(false);
                }
                return true;
            }
        }
        return false;
    }

    private void tryStartingKbMode(int keyCode) {
        if (keyCode == -1 || this.addKeyIfLegal(keyCode)) {
            this.mInKbMode = true;
            this.mDoneButton.setEnabled(false);
            this.updateDisplay(false);
        }
    }

    private boolean addKeyIfLegal(int keyCode) {
        if (this.mIs24HourMode && this.mTypedTimes.size() == 4 || !this.mIs24HourMode && this.isTypedTimeFullyLegal()) {
            return false;
        }
        this.mTypedTimes.add(keyCode);
        if (!this.isTypedTimeLegalSoFar()) {
            this.deleteLastTypedKey();
            return false;
        }
        int val = GridTimePickerDialog.getValFromKeyCode(keyCode);
        Utils.tryAccessibilityAnnounce((View)this.mTimePicker, String.format("%d", val));
        if (this.isTypedTimeFullyLegal()) {
            if (!this.mIs24HourMode && this.mTypedTimes.size() <= 3) {
                this.mTypedTimes.add(this.mTypedTimes.size() - 1, 7);
                this.mTypedTimes.add(this.mTypedTimes.size() - 1, 7);
            }
            this.mDoneButton.setEnabled(true);
        }
        return true;
    }

    private boolean isTypedTimeLegalSoFar() {
        Node node = this.mLegalTimesTree;
        for (int keyCode : this.mTypedTimes) {
            if ((node = node.canReach(keyCode)) != null) continue;
            return false;
        }
        return true;
    }

    private boolean isTypedTimeFullyLegal() {
        if (this.mIs24HourMode) {
            int[] values = this.getEnteredTime(null);
            return values[0] >= 0 && values[1] >= 0 && values[1] < 60;
        }
        return this.mTypedTimes.contains(this.getAmOrPmKeyCode(0)) || this.mTypedTimes.contains(this.getAmOrPmKeyCode(1));
    }

    private int deleteLastTypedKey() {
        int deleted = this.mTypedTimes.remove(this.mTypedTimes.size() - 1);
        if (!this.isTypedTimeFullyLegal()) {
            this.mDoneButton.setEnabled(false);
        }
        return deleted;
    }

    private void finishKbMode(boolean updateDisplays) {
        this.mInKbMode = false;
        if (!this.mTypedTimes.isEmpty()) {
            int[] values = this.getEnteredTime(null);
            this.mTimePicker.setTime(values[0], values[1]);
            if (!this.mIs24HourMode) {
                this.mTimePicker.setHalfDay(values[2]);
            }
            this.mTypedTimes.clear();
        }
        if (updateDisplays) {
            this.updateDisplay(false);
        }
    }

    private void updateDisplay(boolean allowEmptyDisplay) {
        if (!allowEmptyDisplay && this.mTypedTimes.isEmpty()) {
            int hour = this.mTimePicker.getHours();
            int minute = this.mTimePicker.getMinutes();
            this.setHour(hour, true);
            this.setMinute(minute);
            if (!this.mIs24HourMode) {
                this.updateAmPmDisplay(hour < 12 ? 0 : 1);
            }
            this.setCurrentItemShowing(this.mTimePicker.getCurrentItemShowing(), true, true, true);
            this.mDoneButton.setEnabled(true);
        } else {
            Boolean[] enteredZeros = new Boolean[]{false, false};
            int[] values = this.getEnteredTime(enteredZeros);
            String hourFormat = enteredZeros[0] != false ? "%02d" : "%2d";
            String minuteFormat = enteredZeros[1] != false ? "%02d" : "%2d";
            String hourStr = values[0] == -1 ? this.mDoublePlaceholderText : String.format(hourFormat, values[0]).replace(' ', this.mPlaceholderText);
            String minuteStr = values[1] == -1 ? this.mDoublePlaceholderText : String.format(minuteFormat, values[1]).replace(' ', this.mPlaceholderText);
            this.mHourView.setText((CharSequence)hourStr);
            this.mHourSpaceView.setText((CharSequence)hourStr);
            this.mHourView.setTextColor(this.mUnselectedColor);
            this.mMinuteView.setText((CharSequence)minuteStr);
            this.mMinuteSpaceView.setText((CharSequence)minuteStr);
            this.mMinuteView.setTextColor(this.mUnselectedColor);
            if (!this.mIs24HourMode) {
                this.updateAmPmDisplay(values[2]);
            }
        }
    }

    private static int getValFromKeyCode(int keyCode) {
        switch (keyCode) {
            case 7: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 5;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 7;
            }
            case 15: {
                return 8;
            }
            case 16: {
                return 9;
            }
        }
        return -1;
    }

    private int[] getEnteredTime(Boolean[] enteredZeros) {
        int amOrPm = -1;
        int startIndex = 1;
        if (!this.mIs24HourMode && this.isTypedTimeFullyLegal()) {
            int keyCode = this.mTypedTimes.get(this.mTypedTimes.size() - 1);
            if (keyCode == this.getAmOrPmKeyCode(0)) {
                amOrPm = 0;
            } else if (keyCode == this.getAmOrPmKeyCode(1)) {
                amOrPm = 1;
            }
            startIndex = 2;
        }
        int minute = -1;
        int hour = -1;
        for (int i = startIndex; i <= this.mTypedTimes.size(); ++i) {
            int val = GridTimePickerDialog.getValFromKeyCode(this.mTypedTimes.get(this.mTypedTimes.size() - i));
            if (i == startIndex) {
                minute = val;
                continue;
            }
            if (i == startIndex + 1) {
                minute += 10 * val;
                if (enteredZeros == null || val != 0) continue;
                enteredZeros[1] = true;
                continue;
            }
            if (i == startIndex + 2) {
                hour = val;
                continue;
            }
            if (i != startIndex + 3) continue;
            hour += 10 * val;
            if (enteredZeros == null || val != 0) continue;
            enteredZeros[0] = true;
        }
        int[] ret = new int[]{hour, minute, amOrPm};
        return ret;
    }

    private int getAmOrPmKeyCode(int amOrPm) {
        if (this.mAmKeyCode == -1 || this.mPmKeyCode == -1) {
            KeyCharacterMap kcm = KeyCharacterMap.load((int)-1);
            for (int i = 0; i < Math.max(this.mAmText.length(), this.mPmText.length()); ++i) {
                char pmChar;
                char amChar = this.mAmText.toLowerCase(Locale.getDefault()).charAt(i);
                if (amChar == (pmChar = this.mPmText.toLowerCase(Locale.getDefault()).charAt(i))) continue;
                KeyEvent[] events = kcm.getEvents(new char[]{amChar, pmChar});
                if (events != null && events.length == 4) {
                    this.mAmKeyCode = events[0].getKeyCode();
                    this.mPmKeyCode = events[2].getKeyCode();
                    break;
                }
                Log.e((String)TAG, (String)"Unable to find keycodes for AM and PM.");
                break;
            }
        }
        if (amOrPm == 0) {
            return this.mAmKeyCode;
        }
        if (amOrPm == 1) {
            return this.mPmKeyCode;
        }
        return -1;
    }

    private void generateLegalTimesTree() {
        int k0 = 7;
        int k1 = 8;
        int k2 = 9;
        int k3 = 10;
        int k4 = 11;
        int k5 = 12;
        int k6 = 13;
        int k7 = 14;
        int k8 = 15;
        int k9 = 16;
        this.mLegalTimesTree = new Node(new int[0]);
        if (this.mIs24HourMode) {
            Node minuteFirstDigit = new Node(k0, k1, k2, k3, k4, k5);
            Node minuteSecondDigit = new Node(k0, k1, k2, k3, k4, k5, k6, k7, k8, k9);
            minuteFirstDigit.addChild(minuteSecondDigit);
            Node firstDigit = new Node(k0, k1);
            this.mLegalTimesTree.addChild(firstDigit);
            Node secondDigit = new Node(k0, k1, k2, k3, k4, k5);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            Node thirdDigit = new Node(k6, k7, k8, k9);
            secondDigit.addChild(thirdDigit);
            secondDigit = new Node(k6, k7, k8, k9);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            firstDigit = new Node(k2);
            this.mLegalTimesTree.addChild(firstDigit);
            secondDigit = new Node(k0, k1, k2, k3);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            secondDigit = new Node(k4, k5);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteSecondDigit);
            firstDigit = new Node(k3, k4, k5, k6, k7, k8, k9);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(minuteFirstDigit);
        } else {
            Node ampm = new Node(this.getAmOrPmKeyCode(0), this.getAmOrPmKeyCode(1));
            Node firstDigit = new Node(k1);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            Node secondDigit = new Node(k0, k1, k2);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(ampm);
            Node thirdDigit = new Node(k0, k1, k2, k3, k4, k5);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            Node fourthDigit = new Node(k0, k1, k2, k3, k4, k5, k6, k7, k8, k9);
            thirdDigit.addChild(fourthDigit);
            fourthDigit.addChild(ampm);
            thirdDigit = new Node(k6, k7, k8, k9);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            secondDigit = new Node(k3, k4, k5);
            firstDigit.addChild(secondDigit);
            thirdDigit = new Node(k0, k1, k2, k3, k4, k5, k6, k7, k8, k9);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            firstDigit = new Node(k2, k3, k4, k5, k6, k7, k8, k9);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            secondDigit = new Node(k0, k1, k2, k3, k4, k5);
            firstDigit.addChild(secondDigit);
            thirdDigit = new Node(k0, k1, k2, k3, k4, k5, k6, k7, k8, k9);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
        }
    }

    private class KeyboardListener
    implements View.OnKeyListener {
        private KeyboardListener() {
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (event.getAction() == 1) {
                return GridTimePickerDialog.this.processKeyUp(keyCode);
            }
            return false;
        }
    }

    private class Node {
        private int[] mLegalKeys;
        private ArrayList<Node> mChildren;

        public Node(int ... legalKeys) {
            this.mLegalKeys = legalKeys;
            this.mChildren = new ArrayList();
        }

        public void addChild(Node child) {
            this.mChildren.add(child);
        }

        public boolean containsKey(int key) {
            for (int i = 0; i < this.mLegalKeys.length; ++i) {
                if (this.mLegalKeys[i] != key) continue;
                return true;
            }
            return false;
        }

        public Node canReach(int key) {
            if (this.mChildren == null) {
                return null;
            }
            for (Node child : this.mChildren) {
                if (!child.containsKey(key)) continue;
                return child;
            }
            return null;
        }
    }
}

