/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.date.TextViewWithIndicator;

public class TextViewWithHighlightIndicator
extends TextViewWithIndicator {
    private final int mHighlightColor;
    private final String mItemIsSelectedText;
    private final float mDefaultTextSize;
    private final float mSelectedTextSize;
    private boolean mDrawHighlight;
    private int mDisabledTextColor;

    public TextViewWithHighlightIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources res = context.getResources();
        this.mHighlightColor = Utils.getThemeAccentColor(context);
        this.mItemIsSelectedText = context.getResources().getString(R.string.item_is_selected);
        this.mDefaultTextSize = this.getTextSize();
        this.mSelectedTextSize = res.getDimension(R.dimen.year_label_selected_text_size);
        this.mDisabledTextColor = ContextCompat.getColor((Context)context, (int)R.color.text_color_disabled_light);
    }

    @Override
    public void drawIndicator(boolean drawHighlight) {
        this.mDrawHighlight = drawHighlight;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.setTextColor(this.isEnabled() ? (this.mDrawHighlight ? this.mHighlightColor : this.mDefaultTextColor) : this.mDisabledTextColor);
        boolean drawHighlight = this.isEnabled() && this.mDrawHighlight;
        this.setTextSize(0, drawHighlight ? this.mSelectedTextSize : this.mDefaultTextSize);
        this.setTypeface(drawHighlight ? Utils.SANS_SERIF_LIGHT_BOLD : Typeface.DEFAULT);
    }

    public CharSequence getContentDescription() {
        CharSequence itemText = this.getText();
        if (this.mDrawHighlight) {
            return String.format(this.mItemIsSelectedText, itemText);
        }
        return itemText;
    }

    @Override
    void setTheme(Context context, boolean themeDark) {
        super.setTheme(context, themeDark);
        this.mDisabledTextColor = ContextCompat.getColor((Context)context, (int)(themeDark ? R.color.text_color_disabled_dark : R.color.text_color_disabled_light));
    }
}

