/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.util.AttributeSet;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.date.TextViewWithIndicator;

public class TextViewWithHighlightIndicator
extends TextViewWithIndicator {
    private final int mHighlightColor;
    private final String mItemIsSelectedText;
    private final float mDefaultTextSize;
    private final float mSelectedTextSize;
    private boolean mDrawHighlight;

    public TextViewWithHighlightIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources res = context.getResources();
        this.mHighlightColor = Utils.getThemeAccentColor(context);
        this.mItemIsSelectedText = context.getResources().getString(R.string.item_is_selected);
        this.mDefaultTextSize = this.getTextSize();
        this.mSelectedTextSize = res.getDimension(R.dimen.year_label_selected_text_size);
    }

    @Override
    public void drawIndicator(boolean drawHighlight) {
        this.mDrawHighlight = drawHighlight;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.setTextColor(this.mDrawHighlight ? this.mHighlightColor : this.mDefaultTextColor);
        this.setTextSize(0, this.mDrawHighlight ? this.mSelectedTextSize : this.mDefaultTextSize);
        this.setTypeface(this.mDrawHighlight ? Utils.HIGHLIGHT_TYPEFACE : Typeface.DEFAULT);
    }

    public CharSequence getContentDescription() {
        CharSequence itemText = this.getText();
        if (this.mDrawHighlight) {
            return String.format(this.mItemIsSelectedText, itemText);
        }
        return itemText;
    }
}

