/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.date;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.HapticFeedbackController;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.date.AccessibleDateAnimator;
import com.philliphsu.bottomsheetpickers.date.DatePickerController;
import com.philliphsu.bottomsheetpickers.date.DatePickerDialog;
import com.philliphsu.bottomsheetpickers.date.DayPickerView;
import com.philliphsu.bottomsheetpickers.date.MonthAdapter;
import com.philliphsu.bottomsheetpickers.date.SimpleDayPickerView;
import com.philliphsu.bottomsheetpickers.date.YearPickerView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class BottomSheetDatePickerDialog
extends DatePickerDialog
implements View.OnClickListener,
DatePickerController {
    private static final String TAG = "BottomSheetDatePickerDialog";
    private static final int UNINITIALIZED = -1;
    private static final int MONTH_AND_DAY_VIEW = 0;
    private static final int YEAR_VIEW = 1;
    private static final String KEY_SELECTED_YEAR = "year";
    private static final String KEY_SELECTED_MONTH = "month";
    private static final String KEY_SELECTED_DAY = "day";
    private static final String KEY_LIST_POSITION = "list_position";
    private static final String KEY_WEEK_START = "week_start";
    private static final String KEY_YEAR_START = "year_start";
    private static final String KEY_YEAR_END = "year_end";
    private static final String KEY_CURRENT_VIEW = "current_view";
    private static final String KEY_LIST_POSITION_OFFSET = "list_position_offset";
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int ANIMATION_DURATION = 300;
    private static final int ANIMATION_DELAY = 500;
    private static SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    private static SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("dd", Locale.getDefault());
    private final Calendar mCalendar = Calendar.getInstance();
    private DatePickerDialog.OnDateSetListener mCallBack;
    private HashSet<DatePickerDialog.OnDateChangedListener> mListeners = new HashSet();
    private AccessibleDateAnimator mAnimator;
    private TextView mDayOfWeekView;
    private LinearLayout mMonthDayYearView;
    private TextView mFirstTextView;
    private TextView mSecondTextView;
    private DayPickerView mDayPickerView;
    private YearPickerView mYearPickerView;
    private FloatingActionButton mDoneButton;
    private int mCurrentView = -1;
    private int mWeekStart = this.mCalendar.getFirstDayOfWeek();
    private int mMinYear = 1900;
    private int mMaxYear = 2100;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private HapticFeedbackController mHapticFeedbackController;
    private boolean mDelayAnimation = true;
    private String mDayPickerDescription;
    private String mSelectDay;
    private String mYearPickerDescription;
    private String mSelectYear;
    private int mLocaleMonthDayIndex;
    private int mLocaleYearIndex;

    public static BottomSheetDatePickerDialog newInstance(DatePickerDialog.OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        BottomSheetDatePickerDialog ret = new BottomSheetDatePickerDialog();
        ret.initialize(callBack, year, monthOfYear, dayOfMonth);
        return ret;
    }

    public void initialize(DatePickerDialog.OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        this.mCallBack = callBack;
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, monthOfYear);
        this.mCalendar.set(5, dayOfMonth);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FragmentActivity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        this.setCancelable(false);
        if (savedInstanceState != null) {
            this.mCalendar.set(1, savedInstanceState.getInt(KEY_SELECTED_YEAR));
            this.mCalendar.set(2, savedInstanceState.getInt(KEY_SELECTED_MONTH));
            this.mCalendar.set(5, savedInstanceState.getInt(KEY_SELECTED_DAY));
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_SELECTED_YEAR, this.mCalendar.get(1));
        outState.putInt(KEY_SELECTED_MONTH, this.mCalendar.get(2));
        outState.putInt(KEY_SELECTED_DAY, this.mCalendar.get(5));
        outState.putInt(KEY_WEEK_START, this.mWeekStart);
        outState.putInt(KEY_YEAR_START, this.mMinYear);
        outState.putInt(KEY_YEAR_END, this.mMaxYear);
        outState.putInt(KEY_CURRENT_VIEW, this.mCurrentView);
        int listPosition = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            outState.putInt(KEY_LIST_POSITION_OFFSET, this.mYearPickerView.getFirstPositionOffset());
        }
        outState.putInt(KEY_LIST_POSITION, listPosition);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        this.mDayOfWeekView = (TextView)view.findViewById(R.id.date_picker_header);
        this.mMonthDayYearView = (LinearLayout)view.findViewById(R.id.date_picker_month_day_year);
        this.mFirstTextView = (TextView)view.findViewById(R.id.date_picker_first_textview);
        this.mFirstTextView.setOnClickListener((View.OnClickListener)this);
        this.mSecondTextView = (TextView)view.findViewById(R.id.date_picker_second_textview);
        this.mSecondTextView.setOnClickListener((View.OnClickListener)this);
        int listPosition = -1;
        int listPositionOffset = 0;
        int currentView = 0;
        if (savedInstanceState != null) {
            this.mWeekStart = savedInstanceState.getInt(KEY_WEEK_START);
            this.mMinYear = savedInstanceState.getInt(KEY_YEAR_START);
            this.mMaxYear = savedInstanceState.getInt(KEY_YEAR_END);
            currentView = savedInstanceState.getInt(KEY_CURRENT_VIEW);
            listPosition = savedInstanceState.getInt(KEY_LIST_POSITION);
            listPositionOffset = savedInstanceState.getInt(KEY_LIST_POSITION_OFFSET);
        }
        FragmentActivity activity = this.getActivity();
        this.mDayPickerView = new SimpleDayPickerView((Context)activity, this, this.mThemeDark);
        this.mYearPickerView = new YearPickerView((Context)activity, this);
        this.mYearPickerView.setTheme((Context)activity, this.mThemeDark);
        Resources res = this.getResources();
        this.mDayPickerDescription = res.getString(R.string.day_picker_description);
        this.mSelectDay = res.getString(R.string.select_day);
        this.mYearPickerDescription = res.getString(R.string.year_picker_description);
        this.mSelectYear = res.getString(R.string.select_year);
        this.mAnimator = (AccessibleDateAnimator)view.findViewById(R.id.animator);
        this.mAnimator.addView((View)this.mDayPickerView);
        this.mAnimator.addView((View)this.mYearPickerView);
        this.mAnimator.setDateMillis(this.mCalendar.getTimeInMillis());
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)animation);
        AlphaAnimation animation2 = new AlphaAnimation(1.0f, 0.0f);
        animation2.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)animation2);
        this.mDoneButton = (FloatingActionButton)view.findViewById(R.id.done);
        this.mDoneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BottomSheetDatePickerDialog.this.tryVibrate();
                if (BottomSheetDatePickerDialog.this.mCallBack != null) {
                    BottomSheetDatePickerDialog.this.mCallBack.onDateSet(BottomSheetDatePickerDialog.this, BottomSheetDatePickerDialog.this.mCalendar.get(1), BottomSheetDatePickerDialog.this.mCalendar.get(2), BottomSheetDatePickerDialog.this.mCalendar.get(5));
                }
                BottomSheetDatePickerDialog.this.dismiss();
            }
        });
        if (this.mThemeDark) {
            view.setBackgroundColor(this.mDarkGray);
            this.mAnimator.setBackgroundColor(this.mDarkGray);
        } else {
            Drawable fabIcon = this.mDoneButton.getDrawable();
            Utils.setTint(fabIcon, this.mAccentColor);
            this.mDoneButton.setImageDrawable(fabIcon);
        }
        View selectedDateLayout = view.findViewById(R.id.day_picker_selected_date_layout);
        selectedDateLayout.setBackgroundColor(this.mThemeDark ? this.mLightGray : this.mAccentColor);
        int white = ContextCompat.getColor((Context)this.getActivity(), (int)17170443);
        this.mDoneButton.setBackgroundTintList(ColorStateList.valueOf((int)(this.mThemeDark ? this.mAccentColor : white)));
        this.determineLocale_MD_Y_Indices();
        this.updateDisplay(false);
        this.setCurrentView(currentView);
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.postSetSelection(listPosition);
            } else if (currentView == 1) {
                this.mYearPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            }
        }
        this.mHapticFeedbackController = new HapticFeedbackController((Context)activity);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.mHapticFeedbackController.start();
    }

    public void onPause() {
        super.onPause();
        this.mHapticFeedbackController.stop();
    }

    private void setCurrentView(int viewIndex) {
        long millis = this.mCalendar.getTimeInMillis();
        switch (viewIndex) {
            case 0: {
                this.mDayPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.updateHeaderSelectedView(0);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = viewIndex;
                }
                int flags = 16;
                String dayString = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
                this.mAnimator.setContentDescription(this.mDayPickerDescription + ": " + dayString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectDay);
                break;
            }
            case 1: {
                this.mYearPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.updateHeaderSelectedView(1);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                }
                String yearString = YEAR_FORMAT.format(millis);
                this.mAnimator.setContentDescription(this.mYearPickerDescription + ": " + yearString);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectYear);
            }
        }
    }

    private void updateHeaderSelectedView(int viewIndex) {
        switch (viewIndex) {
            case 0: {
                this.mFirstTextView.setSelected(this.mLocaleMonthDayIndex == 0);
                this.mSecondTextView.setSelected(this.mLocaleMonthDayIndex != 0);
                break;
            }
            case 1: {
                this.mFirstTextView.setSelected(this.mLocaleYearIndex == 0);
                this.mSecondTextView.setSelected(this.mLocaleYearIndex != 0);
            }
        }
    }

    private void determineLocale_MD_Y_Indices() {
        String formattedDate = BottomSheetDatePickerDialog.formatMonthDayYear(this.mCalendar);
        String monthAndDay = BottomSheetDatePickerDialog.formatMonthAndDay(this.mCalendar);
        String year = this.extractYearFromFormattedDate(formattedDate, monthAndDay);
        if (formattedDate.indexOf(monthAndDay) < formattedDate.indexOf(year)) {
            this.mLocaleMonthDayIndex = 0;
            this.mLocaleYearIndex = 1;
        } else {
            this.mLocaleYearIndex = 0;
            this.mLocaleMonthDayIndex = 1;
        }
    }

    private static String formatMonthDayYear(Calendar calendar) {
        int flags = 65556;
        return BottomSheetDatePickerDialog.formatDateTime(calendar, flags);
    }

    private static String formatMonthAndDay(Calendar calendar) {
        int flags = 65560;
        return BottomSheetDatePickerDialog.formatDateTime(calendar, flags);
    }

    private String extractYearFromFormattedDate(String formattedDate, String monthAndDay) {
        String[] parts;
        for (String part : parts = formattedDate.split(monthAndDay)) {
            if (part.isEmpty()) continue;
            return part;
        }
        return YEAR_FORMAT.format(this.mCalendar.getTime());
    }

    private void updateDisplay(boolean announce) {
        if (this.mDayOfWeekView != null) {
            this.mDayOfWeekView.setText((CharSequence)this.mCalendar.getDisplayName(7, 2, Locale.getDefault()));
        }
        String monthAndDay = BottomSheetDatePickerDialog.formatMonthAndDay(this.mCalendar);
        String year = this.extractYearFromFormattedDate(BottomSheetDatePickerDialog.formatMonthDayYear(this.mCalendar), monthAndDay);
        this.mFirstTextView.setText((CharSequence)(this.mLocaleMonthDayIndex == 0 ? monthAndDay : year));
        this.mSecondTextView.setText((CharSequence)(this.mLocaleMonthDayIndex == 0 ? year : monthAndDay));
        long millis = this.mCalendar.getTimeInMillis();
        this.mAnimator.setDateMillis(millis);
        int flags = 24;
        String monthAndDayText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
        this.mMonthDayYearView.setContentDescription((CharSequence)monthAndDayText);
        if (announce) {
            flags = 20;
            String fullDateText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
            Utils.tryAccessibilityAnnounce((View)this.mAnimator, fullDateText);
        }
    }

    private static String formatDateTime(Calendar calendar, int flags) {
        return DateUtils.formatDateTime(null, (long)calendar.getTimeInMillis(), (int)flags);
    }

    public void setFirstDayOfWeek(int startOfWeek) {
        if (startOfWeek < 1 || startOfWeek > 7) {
            throw new IllegalArgumentException("Value must be between Calendar.SUNDAY and Calendar.SATURDAY");
        }
        this.mWeekStart = startOfWeek;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setYearRange(int startYear, int endYear) {
        if (endYear <= startYear) {
            throw new IllegalArgumentException("Year end must be larger than year start");
        }
        this.mMinYear = startYear;
        this.mMaxYear = endYear;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setMinDate(Calendar calendar) {
        this.mMinDate = calendar;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    @Override
    public Calendar getMinDate() {
        return this.mMinDate;
    }

    public void setMaxDate(Calendar calendar) {
        this.mMaxDate = calendar;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    @Override
    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    public void setOnDateSetListener(DatePickerDialog.OnDateSetListener listener) {
        this.mCallBack = listener;
    }

    private void adjustDayInMonthIfNeeded(int month, int year) {
        int daysInMonth;
        int day = this.mCalendar.get(5);
        if (day > (daysInMonth = Utils.getDaysInMonth(month, year))) {
            this.mCalendar.set(5, daysInMonth);
        }
    }

    public void onClick(View v) {
        this.tryVibrate();
        if (v.getId() == R.id.date_picker_second_textview) {
            this.setCurrentView(this.mLocaleMonthDayIndex == 0 ? 1 : 0);
        } else if (v.getId() == R.id.date_picker_first_textview) {
            this.setCurrentView(this.mLocaleMonthDayIndex == 0 ? 0 : 1);
        }
    }

    @Override
    public void onYearSelected(int year) {
        this.adjustDayInMonthIfNeeded(this.mCalendar.get(2), year);
        this.mCalendar.set(1, year);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    @Override
    public void onDayOfMonthSelected(int year, int month, int day) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.updatePickers();
        this.updateDisplay(true);
    }

    private void updatePickers() {
        Iterator<DatePickerDialog.OnDateChangedListener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onDateChanged();
        }
    }

    @Override
    public MonthAdapter.CalendarDay getSelectedDay() {
        return new MonthAdapter.CalendarDay(this.mCalendar);
    }

    @Override
    public int getMinYear() {
        return this.mMinYear;
    }

    @Override
    public int getMaxYear() {
        return this.mMaxYear;
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.mWeekStart;
    }

    @Override
    public void registerOnDateChangedListener(DatePickerDialog.OnDateChangedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void unregisterOnDateChangedListener(DatePickerDialog.OnDateChangedListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void tryVibrate() {
        this.mHapticFeedbackController.tryVibrate();
    }

    @Override
    protected int contentLayout() {
        return R.layout.date_picker_dialog;
    }
}

