/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers;

import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.view.View;
import android.widget.ImageView;
import com.philliphsu.bottomsheetpickers.R;

public class Utils {
    public static final int MONDAY_BEFORE_JULIAN_EPOCH = 2440585;
    public static final int PULSE_ANIMATOR_DURATION = 544;
    public static final int SELECTED_ALPHA = 255;
    public static final int SELECTED_ALPHA_THEME_DARK = 255;
    public static final int FULL_ALPHA = 255;
    static final String SHARED_PREFS_NAME = "com.android.calendar_preferences";
    @Nullable
    @RequiresApi(value=16)
    public static final Typeface SANS_SERIF_LIGHT = Utils.isJellybeanOrLater() ? Typeface.create((String)"sans-serif-light", (int)0) : null;
    public static final Typeface HIGHLIGHT_TYPEFACE;
    public static final Typeface SELECTED_TYPEFACE;

    public static boolean isJellybeanOrLater() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static boolean isLollipopOrLater() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @SuppressLint(value={"NewApi"})
    public static void tryAccessibilityAnnounce(View view, CharSequence text) {
        if (Utils.isJellybeanOrLater() && view != null && text != null) {
            view.announceForAccessibility(text);
        }
    }

    public static int getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return year % 4 == 0 ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    public static int getJulianMondayFromWeeksSinceEpoch(int week) {
        return 2440585 + week * 7;
    }

    public static int getWeeksSinceEpochFromJulianDay(int julianDay, int firstDayOfWeek) {
        int diff = 4 - firstDayOfWeek;
        if (diff < 0) {
            diff += 7;
        }
        int refDay = 2440588 - diff;
        return (julianDay - refDay) / 7;
    }

    public static ObjectAnimator getPulseAnimator(View labelToAnimate, float decreaseRatio, float increaseRatio) {
        Keyframe k0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        Keyframe k1 = Keyframe.ofFloat((float)0.275f, (float)decreaseRatio);
        Keyframe k2 = Keyframe.ofFloat((float)0.69f, (float)increaseRatio);
        Keyframe k3 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofKeyframe((String)"scaleX", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofKeyframe((String)"scaleY", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
        ObjectAnimator pulseAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)labelToAnimate, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY});
        pulseAnimator.setDuration(544L);
        return pulseAnimator;
    }

    public static int getThemeAccentColor(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Utils.getColorFromThemeAttr(context, 16843829);
        }
        return Utils.getColorFromThemeAttr(context, R.attr.colorAccent);
    }

    public static int getThemePrimaryColor(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Utils.getColorFromThemeAttr(context, 16843827);
        }
        return Utils.getColorFromThemeAttr(context, R.attr.colorPrimary);
    }

    public static int getColorFromThemeAttr(Context context, int resid) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{resid});
        int color2 = a.getColor(0, 0);
        a.recycle();
        return color2;
    }

    public static void setTintList(ImageView target, Drawable drawable2, ColorStateList tintList) {
        drawable2 = DrawableCompat.wrap((Drawable)drawable2.mutate());
        DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)tintList);
        target.setImageDrawable(drawable2);
    }

    public static void setTint(Drawable drawable2, @ColorInt int color2) {
        drawable2 = DrawableCompat.wrap((Drawable)drawable2.mutate());
        DrawableCompat.setTint((Drawable)drawable2, (int)color2);
    }

    public static void setColorControlHighlight(@NonNull View view, @ColorInt int color2) {
        Drawable selectableItemBackground = view.getBackground();
        if (Build.VERSION.SDK_INT >= 21 && selectableItemBackground instanceof RippleDrawable) {
            ((RippleDrawable)selectableItemBackground).setColor(ColorStateList.valueOf((int)color2));
            if (Build.VERSION.SDK_INT >= 23 && Utils.isTv(view.getContext())) {
                ((RippleDrawable)selectableItemBackground).setRadius(72);
            }
        } else {
            selectableItemBackground.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        }
    }

    public static boolean isTv(Context context) {
        UiModeManager uiModeManager = (UiModeManager)context.getSystemService("uimode");
        return uiModeManager.getCurrentModeType() == 4;
    }

    public static boolean isDarkTheme(Context context, boolean current) {
        return Utils.resolveBoolean(context, R.attr.themeDark, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean resolveBoolean(Context context, @AttrRes int attr2, boolean fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            boolean bl = a.getBoolean(0, fallback);
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    static {
        if (Utils.isLollipopOrLater()) {
            HIGHLIGHT_TYPEFACE = Typeface.create((Typeface)SANS_SERIF_LIGHT, (int)1);
            SELECTED_TYPEFACE = Typeface.create((String)"sans-serif-thin", (int)1);
        } else {
            SELECTED_TYPEFACE = SANS_SERIF_LIGHT != null ? SANS_SERIF_LIGHT : Typeface.DEFAULT;
            HIGHLIGHT_TYPEFACE = Typeface.DEFAULT;
        }
    }
}

