/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.grid;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ViewAnimator;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.time.grid.HoursGrid;
import com.philliphsu.bottomsheetpickers.time.grid.MinutesGrid;
import com.philliphsu.bottomsheetpickers.time.grid.NumbersGrid;
import com.philliphsu.bottomsheetpickers.time.grid.TwentyFourHoursGrid;

public class GridPickerLayout
extends ViewAnimator
implements NumbersGrid.OnNumberSelectedListener {
    private static final String TAG = "GridSelectorLayout";
    private static final int ANIMATION_DURATION = 300;
    private static final int HOUR_INDEX = 0;
    private static final int MINUTE_INDEX = 1;
    private static final int HALF_DAY_INDEX = 2;
    private static final int HALF_DAY_1 = 0;
    private static final int HALF_DAY_2 = 1;
    private OnValueSelectedListener mListener;
    private boolean mTimeInitialized;
    private int mCurrentHoursOfDay;
    private int mCurrentMinutes;
    private boolean mIs24HourMode;
    private int mCurrentItemShowing;
    private HoursGrid mHoursGrid;
    private TwentyFourHoursGrid m24HoursGrid;
    private MinutesGrid mMinutesGrid;
    private final Animation mInAnimation = new AlphaAnimation(0.0f, 1.0f);
    private final Animation mOutAnimation;

    public GridPickerLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mInAnimation.setDuration(300L);
        this.mOutAnimation = new AlphaAnimation(1.0f, 0.0f);
        this.mOutAnimation.setDuration(300L);
    }

    public void initialize(Context context, int initialHoursOfDay, int initialMinutes, boolean is24HourMode) {
        if (this.mTimeInitialized) {
            Log.e((String)TAG, (String)"Time has already been initialized.");
            return;
        }
        this.mIs24HourMode = is24HourMode;
        if (is24HourMode) {
            this.m24HoursGrid = (TwentyFourHoursGrid)GridPickerLayout.inflate((Context)context, (int)R.layout.pad_24_hours, null);
            this.m24HoursGrid.initialize(this);
            if (initialHoursOfDay >= 12) {
                this.m24HoursGrid.swapTexts();
            }
            this.addView((View)this.m24HoursGrid);
        } else {
            this.mHoursGrid = (HoursGrid)GridPickerLayout.inflate((Context)context, (int)R.layout.pad_12_hours, null);
            this.mHoursGrid.initialize(this);
            this.addView((View)this.mHoursGrid);
        }
        this.mMinutesGrid = (MinutesGrid)GridPickerLayout.inflate((Context)context, (int)R.layout.pad_minutes, null);
        this.mMinutesGrid.initialize(this);
        this.addView((View)this.mMinutesGrid);
        this.setInAnimation(this.mInAnimation);
        this.setOutAnimation(this.mOutAnimation);
        this.setValueForItem(0, initialHoursOfDay);
        this.setValueForItem(1, initialMinutes);
        this.mTimeInitialized = true;
    }

    void setTheme(Context context, boolean themeDark) {
        if (this.m24HoursGrid != null) {
            this.m24HoursGrid.setTheme(context, themeDark);
        } else if (this.mHoursGrid != null) {
            this.mHoursGrid.setTheme(context, themeDark);
        }
        this.mMinutesGrid.setTheme(context, themeDark);
    }

    public void setTime(int hours, int minutes) {
        this.setValueForItem(0, hours);
        this.setValueForItem(1, minutes);
    }

    public void setOnValueSelectedListener(OnValueSelectedListener listener) {
        this.mListener = listener;
    }

    public int getCurrentItemShowing() {
        if (this.mCurrentItemShowing != 0 && this.mCurrentItemShowing != 1) {
            Log.e((String)TAG, (String)("Current item showing was unfortunately set to " + this.mCurrentItemShowing));
            return -1;
        }
        return this.mCurrentItemShowing;
    }

    public void setCurrentItemShowing(int index, boolean animate) {
        if (index != 0 && index != 1) {
            Log.e((String)TAG, (String)("TimePicker does not support view at index " + index));
            return;
        }
        if (Utils.isTv(this.getContext())) {
            if (index == 1) {
                this.findViewById(R.id.minute_0).requestFocus();
            } else if (index == 0) {
                if (this.findViewById(R.id.hour_0_12) != null) {
                    this.findViewById(R.id.hour_0_12).requestFocus();
                } else {
                    this.findViewById(R.id.hour_1).requestFocus();
                }
            }
        }
        int lastIndex = this.getCurrentItemShowing();
        this.mCurrentItemShowing = index;
        if (index != lastIndex) {
            this.setInAnimation(animate ? this.mInAnimation : null);
            this.setOutAnimation(animate ? this.mOutAnimation : null);
            this.setDisplayedChild(index);
        }
    }

    @Override
    public void onNumberSelected(int number) {
        boolean fakeHourItemShowing = false;
        if (this.getCurrentItemShowing() == 0) {
            if (!this.mIs24HourMode) {
                int amOrPm = this.getIsCurrentlyAmOrPm();
                if (amOrPm == 0 && number == 12) {
                    number = 0;
                } else if (amOrPm == 1 && number != 12) {
                    number += 12;
                }
            } else if (this.mCurrentHoursOfDay < 12 && number >= 12 || this.mCurrentHoursOfDay >= 12 && number < 12) {
                int newHalfDay = this.getIsCurrentlyAmOrPm() == 0 ? 1 : 0;
                this.mListener.onValueSelected(2, newHalfDay, false);
                this.setCurrentItemShowing(1, false);
                fakeHourItemShowing = true;
            }
        }
        int currentItemShowing = fakeHourItemShowing ? 0 : this.getCurrentItemShowing();
        this.setValueForItem(currentItemShowing, number);
        this.mListener.onValueSelected(currentItemShowing, number, true);
    }

    public int getHours() {
        return this.mCurrentHoursOfDay;
    }

    public int getMinutes() {
        return this.mCurrentMinutes;
    }

    private int getCurrentlyShowingValue() {
        int currentIndex = this.getCurrentItemShowing();
        if (currentIndex == 0) {
            return this.mCurrentHoursOfDay;
        }
        if (currentIndex == 1) {
            return this.mCurrentMinutes;
        }
        return -1;
    }

    public int getIsCurrentlyAmOrPm() {
        if (this.mCurrentHoursOfDay < 12) {
            return 0;
        }
        if (this.mCurrentHoursOfDay < 24) {
            return 1;
        }
        return -1;
    }

    public void setHalfDay(int halfDay) {
        int initialHalfDay = this.getIsCurrentlyAmOrPm();
        this.setValueForItem(2, halfDay);
        if (halfDay != initialHalfDay && this.mIs24HourMode && this.m24HoursGrid != null) {
            this.m24HoursGrid.swapTexts();
            this.mListener.onValueSelected(0, this.mCurrentHoursOfDay, false);
        }
    }

    private void setValueForItem(int index, int value) {
        if (index == 0) {
            this.mCurrentHoursOfDay = value;
            this.setHourGridSelection(value);
        } else if (index == 1) {
            this.mCurrentMinutes = value;
            this.mMinutesGrid.setSelection(value);
        } else if (index == 2) {
            if (value == 0) {
                this.mCurrentHoursOfDay %= 12;
            } else if (value == 1) {
                this.mCurrentHoursOfDay = this.mCurrentHoursOfDay % 12 + 12;
            }
            this.setHourGridSelection(this.mCurrentHoursOfDay);
        }
    }

    private void setHourGridSelection(int value) {
        if (this.mIs24HourMode) {
            this.m24HoursGrid.setSelection(value);
        } else {
            if ((value %= 12) == 0) {
                value = 12;
            }
            this.mHoursGrid.setSelection(value);
        }
    }

    public static interface OnValueSelectedListener {
        public void onValueSelected(int var1, int var2, boolean var3);
    }
}

