/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.numberpad;

import android.content.Context;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.time.BottomSheetTimePickerDialog;
import com.philliphsu.bottomsheetpickers.time.TimeTextUtils;
import com.philliphsu.bottomsheetpickers.time.numberpad.NumberPadTimePicker;

public class NumberPadTimePickerDialog
extends BottomSheetTimePickerDialog
implements NumberPadTimePicker.OnInputChangeListener {
    private static final String TAG = "NumberPadTimePickerDialog";
    private static final String KEY_IS_24_HOUR_VIEW = "is_24_hour_view";
    private static final String KEY_DIGITS_INPUTTED = "digits_inputted";
    private static final String KEY_AMPM_STATE = "ampm_state";
    private static final String KEY_THEME_DARK = "theme_dark";
    private static final String KEY_THEME_SET_AT_RUNTIME = "theme_set_at_runtime";
    private boolean mIs24HourMode;
    private int[] mInputtedDigits;
    private int mAmPmState = -1;
    private boolean mThemeDark;
    private boolean mThemeSetAtRuntime;
    private TextView mInputField;
    private NumberPadTimePicker mNumpad;

    public static NumberPadTimePickerDialog newInstance(BottomSheetTimePickerDialog.OnTimeSetListener callback) {
        NumberPadTimePickerDialog ret = new NumberPadTimePickerDialog();
        ret.setOnTimeSetListener(callback);
        ret.mThemeDark = false;
        ret.mThemeSetAtRuntime = false;
        return ret;
    }

    private static NumberPadTimePickerDialog newInstance(BottomSheetTimePickerDialog.OnTimeSetListener callback, boolean is24HourMode) {
        return null;
    }

    @Override
    public void setThemeDark(boolean dark) {
        this.mThemeDark = dark;
        this.mThemeSetAtRuntime = true;
    }

    @Override
    public boolean isThemeDark() {
        return this.mThemeDark;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mInputtedDigits = savedInstanceState.getIntArray(KEY_DIGITS_INPUTTED);
            this.mIs24HourMode = savedInstanceState.getBoolean(KEY_IS_24_HOUR_VIEW);
            this.mAmPmState = savedInstanceState.getInt(KEY_AMPM_STATE);
            this.mThemeDark = savedInstanceState.getBoolean(KEY_THEME_DARK);
            this.mThemeSetAtRuntime = savedInstanceState.getBoolean(KEY_THEME_SET_AT_RUNTIME);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        this.mInputField = (TextView)view.findViewById(R.id.input_time);
        this.mNumpad = (NumberPadTimePicker)view.findViewById(R.id.number_grid);
        FloatingActionButton fab = (FloatingActionButton)this.mNumpad.findViewById(R.id.fab);
        fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!NumberPadTimePickerDialog.this.mNumpad.checkTimeValid()) {
                    return;
                }
                NumberPadTimePickerDialog.this.onTimeSet((ViewGroup)NumberPadTimePickerDialog.this.mNumpad, NumberPadTimePickerDialog.this.mNumpad.getHour(), NumberPadTimePickerDialog.this.mNumpad.getMinute());
            }
        });
        if (!this.mThemeSetAtRuntime) {
            this.mThemeDark = Utils.isDarkTheme((Context)this.getActivity(), this.mThemeDark);
        }
        this.mNumpad.setOnInputChangeListener(this);
        this.mNumpad.insertDigits(this.mInputtedDigits);
        this.mNumpad.setAmPmState(this.mAmPmState);
        int accentColor = Utils.getThemeAccentColor(this.getContext());
        int lightGray = ContextCompat.getColor((Context)this.getContext(), (int)R.color.light_gray);
        int darkGray = ContextCompat.getColor((Context)this.getContext(), (int)R.color.dark_gray);
        int white = ContextCompat.getColor((Context)this.getContext(), (int)17170443);
        view.setBackgroundColor(this.mThemeDark ? darkGray : white);
        TextView inputTime = (TextView)view.findViewById(R.id.input_time);
        inputTime.setBackgroundColor(this.mThemeDark ? lightGray : accentColor);
        inputTime.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        this.mNumpad.setTheme(this.getContext(), this.mThemeDark);
        return view;
    }

    @Override
    protected int contentLayout() {
        return R.layout.dialog_time_picker_numpad;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        if (this.mNumpad != null) {
            outState.putIntArray(KEY_DIGITS_INPUTTED, this.mNumpad.getDigits());
            outState.putBoolean(KEY_IS_24_HOUR_VIEW, this.mIs24HourMode);
            outState.putInt(KEY_AMPM_STATE, this.mNumpad.getAmPmState());
            outState.putBoolean(KEY_THEME_DARK, this.mThemeDark);
            outState.putBoolean(KEY_THEME_SET_AT_RUNTIME, this.mThemeSetAtRuntime);
        }
    }

    @Override
    public void onDigitInserted(String newStr) {
        this.updateInputText(newStr);
    }

    @Override
    public void onDigitDeleted(String newStr) {
        this.updateInputText(newStr);
    }

    @Override
    public void onDigitsCleared() {
        this.updateInputText("");
    }

    @Override
    public void onInputDisabled() {
    }

    private void updateInputText(String inputText) {
        TimeTextUtils.setText(inputText, this.mInputField);
    }
}

